/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.metadata;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oadd.com.google.common.base.Preconditions;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.metadata.AbstractColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.MapColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.PrimitiveColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.VariantColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.VariantMetadata;

public class VariantSchema
implements VariantMetadata {
    private final Map<TypeProtos.MinorType, ColumnMetadata> types = new HashMap<TypeProtos.MinorType, ColumnMetadata>();
    private VariantColumnMetadata parent;
    private boolean isSimple;

    protected void bind(VariantColumnMetadata parent) {
        this.parent = parent;
    }

    public static AbstractColumnMetadata memberMetadata(TypeProtos.MinorType type) {
        String name = Types.typeKey(type);
        switch (type) {
            case LIST: {
                return new VariantColumnMetadata(name, type, null);
            }
            case MAP: {
                return new MapColumnMetadata(name, TypeProtos.DataMode.OPTIONAL, null);
            }
            case UNION: {
                throw new IllegalArgumentException("Cannot add a union to a union");
            }
        }
        return new PrimitiveColumnMetadata(MaterializedField.create(name, Types.optional(type)));
    }

    @Override
    public ColumnMetadata addType(TypeProtos.MinorType type) {
        this.checkType(type);
        AbstractColumnMetadata dummyCol = VariantSchema.memberMetadata(type);
        this.types.put(type, dummyCol);
        return dummyCol;
    }

    @Override
    public void addType(ColumnMetadata col) {
        this.checkType(col.type());
        Preconditions.checkArgument(col.name().equals(Types.typeKey(col.type())));
        switch (col.type()) {
            case UNION: {
                throw new IllegalArgumentException("Cannot add a union to a union");
            }
            case LIST: {
                if (col.mode() != TypeProtos.DataMode.REQUIRED) break;
                throw new IllegalArgumentException("List type column must be OPTIONAL or REPEATED");
            }
            default: {
                if (col.mode() == TypeProtos.DataMode.OPTIONAL) break;
                throw new IllegalArgumentException("Type column must be OPTIONAL");
            }
        }
        this.types.put(col.type(), col);
    }

    private void checkType(TypeProtos.MinorType type) {
        if (this.types.containsKey(type)) {
            throw new IllegalArgumentException("Variant already contains type: " + type);
        }
    }

    @Override
    public int size() {
        return this.types.size();
    }

    @Override
    public boolean hasType(TypeProtos.MinorType type) {
        return this.types.containsKey(type);
    }

    @Override
    public ColumnMetadata member(TypeProtos.MinorType type) {
        return this.types.get(type);
    }

    @Override
    public ColumnMetadata parent() {
        return this.parent;
    }

    @Override
    public Collection<TypeProtos.MinorType> types() {
        return this.types.keySet();
    }

    @Override
    public Collection<ColumnMetadata> members() {
        return this.types.values();
    }

    public void addMap(MapColumnMetadata mapCol) {
        Preconditions.checkArgument(!mapCol.isArray());
        Preconditions.checkState(!this.isSimple);
        this.checkType(TypeProtos.MinorType.MAP);
        this.types.put(TypeProtos.MinorType.MAP, mapCol);
    }

    public void addList(VariantColumnMetadata listCol) {
        Preconditions.checkArgument(listCol.isArray());
        Preconditions.checkState(!this.isSimple);
        this.checkType(TypeProtos.MinorType.LIST);
        this.types.put(TypeProtos.MinorType.LIST, listCol);
    }

    public ColumnMetadata addType(MaterializedField field) {
        AbstractColumnMetadata col;
        Preconditions.checkState(!this.isSimple);
        TypeProtos.MinorType type = field.getType().getMinorType();
        this.checkType(type);
        switch (type) {
            case LIST: {
                col = new VariantColumnMetadata(field);
                break;
            }
            case MAP: {
                col = new MapColumnMetadata(field);
                break;
            }
            case UNION: {
                throw new IllegalArgumentException("Cannot add a union to a union");
            }
            default: {
                col = new PrimitiveColumnMetadata(field);
            }
        }
        this.types.put(type, col);
        return col;
    }

    @Override
    public boolean isSingleType() {
        return this.types.size() == 1;
    }

    @Override
    public ColumnMetadata listSubtype() {
        if (this.isSingleType()) {
            return this.types.values().iterator().next();
        }
        return new VariantColumnMetadata("$data", TypeProtos.MinorType.UNION, this);
    }

    @Override
    public void becomeSimple() {
        Preconditions.checkState(this.types.size() == 1);
        this.isSimple = true;
    }

    @Override
    public boolean isSimple() {
        return this.isSimple;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + this.types.toString() + ", simple: " + this.isSimple + "]";
    }

    public VariantSchema cloneEmpty() {
        VariantSchema copy = new VariantSchema();
        copy.isSimple = this.isSimple;
        return copy;
    }
}

