/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oadd.org.apache.drill.exec.record.BatchSchema;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.metadata.AbstractColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.MapColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.MetadataUtils;
import oadd.org.apache.drill.exec.record.metadata.TupleMetadata;
import oadd.org.apache.drill.exec.record.metadata.TupleNameSpace;

public class TupleSchema
implements TupleMetadata {
    private MapColumnMetadata parentMap;
    private final TupleNameSpace<ColumnMetadata> nameSpace = new TupleNameSpace();

    public void bind(MapColumnMetadata parentMap) {
        this.parentMap = parentMap;
    }

    public TupleMetadata copy() {
        TupleSchema tuple = new TupleSchema();
        for (ColumnMetadata md : this) {
            tuple.addColumn(((AbstractColumnMetadata)md).copy());
        }
        return tuple;
    }

    @Override
    public ColumnMetadata add(MaterializedField field) {
        AbstractColumnMetadata md = MetadataUtils.fromField(field);
        this.add(md);
        return md;
    }

    public ColumnMetadata addView(MaterializedField field) {
        AbstractColumnMetadata md = MetadataUtils.fromView(field);
        this.add(md);
        return md;
    }

    public void add(AbstractColumnMetadata md) {
        md.bind(this);
        this.nameSpace.add(md.name(), md);
    }

    @Override
    public int addColumn(ColumnMetadata column) {
        this.add((AbstractColumnMetadata)column);
        return this.size() - 1;
    }

    @Override
    public MaterializedField column(String name) {
        ColumnMetadata md = this.metadata(name);
        return md == null ? null : md.schema();
    }

    @Override
    public ColumnMetadata metadata(String name) {
        return this.nameSpace.get(name);
    }

    @Override
    public int index(String name) {
        return this.nameSpace.indexOf(name);
    }

    @Override
    public MaterializedField column(int index) {
        return this.metadata(index).schema();
    }

    @Override
    public ColumnMetadata metadata(int index) {
        return this.nameSpace.get(index);
    }

    @Override
    public MapColumnMetadata parent() {
        return this.parentMap;
    }

    @Override
    public int size() {
        return this.nameSpace.count();
    }

    @Override
    public boolean isEmpty() {
        return this.nameSpace.count() == 0;
    }

    @Override
    public Iterator<ColumnMetadata> iterator() {
        return this.nameSpace.iterator();
    }

    @Override
    public boolean isEquivalent(TupleMetadata other) {
        TupleSchema otherSchema = (TupleSchema)other;
        if (this.nameSpace.count() != otherSchema.nameSpace.count()) {
            return false;
        }
        for (int i = 0; i < this.nameSpace.count(); ++i) {
            if (this.nameSpace.get(i).isEquivalent(otherSchema.nameSpace.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<MaterializedField> toFieldList() {
        ArrayList<MaterializedField> cols = new ArrayList<MaterializedField>();
        for (ColumnMetadata md : this.nameSpace) {
            cols.add(md.schema());
        }
        return cols;
    }

    public BatchSchema toBatchSchema(BatchSchema.SelectionVectorMode svMode) {
        return new BatchSchema(svMode, this.toFieldList());
    }

    @Override
    public String fullName(int index) {
        return this.fullName(this.metadata(index));
    }

    @Override
    public String fullName(ColumnMetadata column) {
        String quotedName = column.name();
        if (quotedName.contains(".")) {
            quotedName = "`" + quotedName + "`";
        }
        if (this.isRoot()) {
            return column.name();
        }
        return this.fullName() + "." + quotedName;
    }

    public String fullName() {
        if (this.isRoot()) {
            return "<root>";
        }
        return this.parentMap.parentTuple().fullName(this.parentMap);
    }

    public boolean isRoot() {
        return this.parentMap == null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append("[").append(this.getClass().getSimpleName()).append(" ");
        boolean first = true;
        for (ColumnMetadata md : this.nameSpace) {
            if (!first) {
                buf.append(", ");
            }
            buf.append(md.toString());
        }
        buf.append("]");
        return buf.toString();
    }
}

