/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.metadata;

import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.metadata.AbstractColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.TupleMetadata;
import oadd.org.apache.drill.exec.record.metadata.TupleSchema;

public class MapColumnMetadata
extends AbstractColumnMetadata {
    private TupleMetadata parentTuple;
    private final TupleSchema mapSchema;

    public MapColumnMetadata(MaterializedField schema) {
        this(schema, null);
    }

    MapColumnMetadata(MaterializedField schema, TupleSchema mapSchema) {
        super(schema);
        this.mapSchema = mapSchema == null ? new TupleSchema() : mapSchema;
        this.mapSchema.bind(this);
    }

    public MapColumnMetadata(MapColumnMetadata from) {
        super(from);
        this.mapSchema = (TupleSchema)from.mapSchema.copy();
    }

    public MapColumnMetadata(String name, TypeProtos.DataMode mode, TupleSchema mapSchema) {
        super(name, TypeProtos.MinorType.MAP, mode);
        this.mapSchema = mapSchema == null ? new TupleSchema() : mapSchema;
    }

    @Override
    public AbstractColumnMetadata copy() {
        return new MapColumnMetadata(this);
    }

    @Override
    protected void bind(TupleSchema parentTuple) {
        this.parentTuple = parentTuple;
    }

    @Override
    public ColumnMetadata.StructureType structureType() {
        return ColumnMetadata.StructureType.TUPLE;
    }

    @Override
    public TupleMetadata mapSchema() {
        return this.mapSchema;
    }

    @Override
    public int expectedWidth() {
        return 0;
    }

    @Override
    public boolean isMap() {
        return true;
    }

    public TupleMetadata parentTuple() {
        return this.parentTuple;
    }

    public TupleSchema mapSchemaImpl() {
        return this.mapSchema;
    }

    @Override
    public ColumnMetadata cloneEmpty() {
        return new MapColumnMetadata(this.name, this.mode, new TupleSchema());
    }

    @Override
    public MaterializedField schema() {
        MaterializedField field = this.emptySchema();
        for (MaterializedField member : this.mapSchema.toFieldList()) {
            field.addChild(member);
        }
        return field;
    }

    @Override
    public MaterializedField emptySchema() {
        return MaterializedField.create(this.name, TypeProtos.MajorType.newBuilder().setMinorType(this.type).setMode(this.mode).build());
    }
}

