/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.collect.Lists;
import oadd.com.google.common.collect.Maps;
import oadd.com.google.common.collect.Sets;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.expr.TypeHelper;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.ops.OperatorContext;
import oadd.org.apache.drill.exec.record.BatchSchema;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.SchemaBuilder;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.record.VectorAccessible;
import oadd.org.apache.drill.exec.record.VectorContainer;
import oadd.org.apache.drill.exec.record.VectorWrapper;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.complex.UnionVector;

public class SchemaUtil {
    public static BatchSchema mergeSchemas(BatchSchema ... schemas) {
        LinkedHashMap typeSetMap = Maps.newLinkedHashMap();
        for (BatchSchema s : schemas) {
            for (Object field : s) {
                TypeProtos.MinorType newType;
                SchemaPath path = SchemaPath.getSimplePath(((MaterializedField)field).getName());
                HashSet<TypeProtos.MinorType> currentTypes = (HashSet<TypeProtos.MinorType>)typeSetMap.get(path);
                if (currentTypes == null) {
                    currentTypes = Sets.newHashSet();
                    typeSetMap.put(path, currentTypes);
                }
                if ((newType = ((MaterializedField)field).getType().getMinorType()) == TypeProtos.MinorType.MAP || newType == TypeProtos.MinorType.LIST) {
                    throw new RuntimeException("Schema change not currently supported for schemas with complex types");
                }
                if (newType == TypeProtos.MinorType.UNION) {
                    currentTypes.addAll(((MaterializedField)field).getType().getSubTypeList());
                    continue;
                }
                currentTypes.add(newType);
            }
        }
        ArrayList<MaterializedField> fields = Lists.newArrayList();
        for (SchemaPath path : typeSetMap.keySet()) {
            Set types = (Set)typeSetMap.get(path);
            if (types.size() > 1) {
                Object field;
                TypeProtos.MajorType.Builder builder = TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.UNION).setMode(TypeProtos.DataMode.OPTIONAL);
                for (TypeProtos.MinorType t : types) {
                    builder.addSubType(t);
                }
                field = MaterializedField.create(path.getLastSegment().getNameSegment().getPath(), builder.build());
                fields.add((MaterializedField)field);
                continue;
            }
            MaterializedField field = MaterializedField.create(path.getLastSegment().getNameSegment().getPath(), Types.optional((TypeProtos.MinorType)types.iterator().next()));
            fields.add(field);
        }
        SchemaBuilder schemaBuilder = new SchemaBuilder();
        BatchSchema s = schemaBuilder.addFields(fields).setSelectionVectorMode(schemas[0].getSelectionVectorMode()).build();
        return s;
    }

    private static ValueVector coerceVector(ValueVector v, VectorContainer c, MaterializedField field, int recordCount, BufferAllocator allocator) {
        if (v != null) {
            int valueCount = v.getAccessor().getValueCount();
            TransferPair tp = v.getTransferPair(allocator);
            tp.transfer();
            if (v.getField().getType().getMinorType().equals(field.getType().getMinorType())) {
                if (field.getType().getMinorType() == TypeProtos.MinorType.UNION) {
                    UnionVector u = (UnionVector)tp.getTo();
                    for (TypeProtos.MinorType t : field.getType().getSubTypeList()) {
                        u.addSubType(t);
                    }
                }
                return tp.getTo();
            }
            ValueVector newVector = TypeHelper.getNewVector(field, allocator);
            Preconditions.checkState(field.getType().getMinorType() == TypeProtos.MinorType.UNION, "Can only convert vector to Union vector");
            UnionVector u = (UnionVector)newVector;
            u.setFirstType(tp.getTo(), valueCount);
            return u;
        }
        v = TypeHelper.getNewVector(field, allocator);
        v.allocateNew();
        v.getMutator().setValueCount(recordCount);
        return v;
    }

    public static VectorContainer coerceContainer(VectorAccessible in, BatchSchema toSchema, OperatorContext context) {
        return SchemaUtil.coerceContainer(in, toSchema, context.getAllocator());
    }

    public static VectorContainer coerceContainer(VectorAccessible in, BatchSchema toSchema, BufferAllocator allocator) {
        int recordCount = in.getRecordCount();
        boolean isHyper = false;
        HashMap<String, Object> vectorMap = Maps.newHashMap();
        for (VectorWrapper w : in) {
            if (w.isHyper()) {
                isHyper = true;
                ValueVector[] vvs = w.getValueVectors();
                vectorMap.put(vvs[0].getField().getName(), vvs);
                continue;
            }
            assert (!isHyper);
            Object v = w.getValueVector();
            vectorMap.put(v.getField().getName(), v);
        }
        VectorContainer c = new VectorContainer(allocator);
        for (MaterializedField field : toSchema) {
            if (isHyper) {
                ValueVector[] vvsOut;
                ValueVector[] vvs = (ValueVector[])vectorMap.remove(field.getName());
                if (vvs == null) {
                    vvsOut = new ValueVector[]{SchemaUtil.coerceVector(null, c, field, recordCount, allocator)};
                } else {
                    vvsOut = new ValueVector[vvs.length];
                    for (int i = 0; i < vvs.length; ++i) {
                        vvsOut[i] = SchemaUtil.coerceVector(vvs[i], c, field, recordCount, allocator);
                    }
                }
                c.add(vvsOut);
                continue;
            }
            ValueVector v = (ValueVector)vectorMap.remove(field.getName());
            c.add(SchemaUtil.coerceVector(v, c, field, recordCount, allocator));
        }
        c.buildSchema(in.getSchema().getSelectionVectorMode());
        c.setRecordCount(recordCount);
        Preconditions.checkState(vectorMap.size() == 0, "Leftover vector from incoming batch");
        return c;
    }
}

