/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.ops;

import java.io.IOException;
import java.util.List;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.exec.exception.ClassTransformationException;
import oadd.org.apache.drill.exec.expr.ClassGenerator;
import oadd.org.apache.drill.exec.expr.CodeGenerator;
import oadd.org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import oadd.org.apache.drill.exec.ops.BufferManager;
import oadd.org.apache.drill.exec.ops.FragmentContext;

public abstract class BaseFragmentContext
implements FragmentContext {
    private final FunctionImplementationRegistry funcRegistry;

    public BaseFragmentContext(FunctionImplementationRegistry funcRegistry) {
        this.funcRegistry = funcRegistry;
    }

    public FunctionImplementationRegistry getFunctionRegistry() {
        return this.funcRegistry;
    }

    @Override
    public <T> T getImplementationClass(ClassGenerator<T> cg) throws ClassTransformationException, IOException {
        return this.getImplementationClass(cg.getCodeGenerator());
    }

    @Override
    public <T> T getImplementationClass(CodeGenerator<T> cg) throws ClassTransformationException, IOException {
        return (T)this.getCompiler().createInstance(cg);
    }

    @Override
    public <T> List<T> getImplementationClass(ClassGenerator<T> cg, int instanceCount) throws ClassTransformationException, IOException {
        return this.getImplementationClass(cg.getCodeGenerator(), instanceCount);
    }

    @Override
    public <T> List<T> getImplementationClass(CodeGenerator<T> cg, int instanceCount) throws ClassTransformationException, IOException {
        return this.getCompiler().createInstances(cg, instanceCount);
    }

    protected abstract BufferManager getBufferManager();

    @Override
    public DrillBuf replace(DrillBuf old, int newSize) {
        return this.getBufferManager().replace(old, newSize);
    }

    @Override
    public DrillBuf getManagedBuffer() {
        return this.getBufferManager().getManagedBuffer();
    }

    @Override
    public DrillBuf getManagedBuffer(int size) {
        return this.getBufferManager().getManagedBuffer(size);
    }
}

