/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.expr.stat;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.BiPredicate;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.LogicalExpressionBase;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.expression.TypedFieldExpr;
import oadd.org.apache.drill.common.expression.visitors.ExprVisitor;
import oadd.org.apache.drill.exec.expr.stat.ParquetFilterPredicate;
import oadd.org.apache.drill.exec.expr.stat.ParquetPredicatesHelper;
import oadd.org.apache.drill.exec.expr.stat.RangeExprEvaluator;
import org.apache.parquet.column.statistics.BooleanStatistics;
import org.apache.parquet.column.statistics.Statistics;

public class ParquetIsPredicate<C extends Comparable<C>>
extends LogicalExpressionBase
implements ParquetFilterPredicate<C> {
    private final LogicalExpression expr;
    private final BiPredicate<Statistics<C>, RangeExprEvaluator<C>> predicate;

    private ParquetIsPredicate(LogicalExpression expr, BiPredicate<Statistics<C>, RangeExprEvaluator<C>> predicate) {
        super(expr.getPosition());
        this.expr = expr;
        this.predicate = predicate;
    }

    @Override
    public Iterator<LogicalExpression> iterator() {
        ArrayList<LogicalExpression> args = new ArrayList<LogicalExpression>();
        args.add(this.expr);
        return args.iterator();
    }

    @Override
    public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
        return visitor.visitUnknown(this, value);
    }

    @Override
    public boolean canDrop(RangeExprEvaluator<C> evaluator) {
        Statistics exprStat = (Statistics)this.expr.accept(evaluator, null);
        if (ParquetPredicatesHelper.isNullOrEmpty(exprStat)) {
            return false;
        }
        return this.predicate.test(exprStat, evaluator);
    }

    private static <C extends Comparable<C>> LogicalExpression createIsNullPredicate(final LogicalExpression expr) {
        return new ParquetIsPredicate<C>(expr, (exprStat, evaluator) -> ParquetPredicatesHelper.hasNoNulls(exprStat)){
            private final boolean isArray;
            {
                super(expr2, predicate);
                this.isArray = this.isArray(expr);
            }

            private boolean isArray(LogicalExpression expression) {
                if (expression instanceof TypedFieldExpr) {
                    TypedFieldExpr typedFieldExpr = (TypedFieldExpr)expression;
                    SchemaPath schemaPath = typedFieldExpr.getPath();
                    return schemaPath.isArray();
                }
                return false;
            }

            @Override
            public boolean canDrop(RangeExprEvaluator<C> evaluator) {
                return !this.isArray && super.canDrop(evaluator);
            }
        };
    }

    private static <C extends Comparable<C>> LogicalExpression createIsNotNullPredicate(LogicalExpression expr) {
        return new ParquetIsPredicate<C>(expr, (exprStat, evaluator) -> ParquetPredicatesHelper.isAllNulls(exprStat, evaluator.getRowCount()));
    }

    private static LogicalExpression createIsTruePredicate(LogicalExpression expr) {
        return new ParquetIsPredicate(expr, (exprStat, evaluator) -> ParquetPredicatesHelper.isAllNulls(exprStat, evaluator.getRowCount()) || exprStat.hasNonNullValue() && !((BooleanStatistics)exprStat).getMax());
    }

    private static LogicalExpression createIsFalsePredicate(LogicalExpression expr) {
        return new ParquetIsPredicate(expr, (exprStat, evaluator) -> ParquetPredicatesHelper.isAllNulls(exprStat, evaluator.getRowCount()) || exprStat.hasNonNullValue() && ((BooleanStatistics)exprStat).getMin());
    }

    private static LogicalExpression createIsNotTruePredicate(LogicalExpression expr) {
        return new ParquetIsPredicate(expr, (exprStat, evaluator) -> ParquetPredicatesHelper.hasNoNulls(exprStat) && exprStat.hasNonNullValue() && ((BooleanStatistics)exprStat).getMin());
    }

    private static LogicalExpression createIsNotFalsePredicate(LogicalExpression expr) {
        return new ParquetIsPredicate(expr, (exprStat, evaluator) -> ParquetPredicatesHelper.hasNoNulls(exprStat) && exprStat.hasNonNullValue() && !((BooleanStatistics)exprStat).getMax());
    }

    public static <C extends Comparable<C>> LogicalExpression createIsPredicate(String function, LogicalExpression expr) {
        switch (function) {
            case "isnull": {
                return ParquetIsPredicate.createIsNullPredicate(expr);
            }
            case "isnotnull": {
                return ParquetIsPredicate.createIsNotNullPredicate(expr);
            }
            case "istrue": {
                return ParquetIsPredicate.createIsTruePredicate(expr);
            }
            case "isnottrue": {
                return ParquetIsPredicate.createIsNotTruePredicate(expr);
            }
            case "isfalse": {
                return ParquetIsPredicate.createIsFalsePredicate(expr);
            }
            case "isnotfalse": {
                return ParquetIsPredicate.createIsNotFalsePredicate(expr);
            }
        }
        logger.warn("Unhandled IS function. Function name: {}", (Object)function);
        return null;
    }
}

