/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.dotdrill;

import java.io.IOException;
import java.io.InputStream;
import oadd.com.google.common.base.Preconditions;
import oadd.org.apache.drill.common.config.LogicalPlanPersistence;
import oadd.org.apache.drill.exec.dotdrill.DotDrillType;
import oadd.org.apache.drill.exec.dotdrill.View;
import oadd.org.apache.drill.exec.store.dfs.DrillFileSystem;
import oadd.org.apache.hadoop.fs.FSDataInputStream;
import oadd.org.apache.hadoop.fs.FileStatus;

public class DotDrillFile {
    private FileStatus status;
    private DotDrillType type;
    private DrillFileSystem fs;

    public static DotDrillFile create(DrillFileSystem fs, FileStatus status) {
        for (DotDrillType d : DotDrillType.values()) {
            if (status.isDir() || !d.matches(status)) continue;
            return new DotDrillFile(fs, status, d);
        }
        return null;
    }

    private DotDrillFile(DrillFileSystem fs, FileStatus status, DotDrillType type) {
        this.fs = fs;
        this.status = status;
        this.type = type;
    }

    public DotDrillType getType() {
        return this.type;
    }

    public String getOwner() {
        return this.status.getOwner();
    }

    public String getBaseName() {
        String fileName = this.status.getPath().getName();
        return fileName.substring(0, fileName.lastIndexOf(this.type.getEnding()));
    }

    public View getView(LogicalPlanPersistence lpPersistence) throws IOException {
        Preconditions.checkArgument(this.type == DotDrillType.VIEW);
        try (FSDataInputStream is = this.fs.open(this.status.getPath());){
            View view = lpPersistence.getMapper().readValue((InputStream)is, View.class);
            return view;
        }
    }
}

