/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.coord.zk;

import java.net.URL;
import oadd.com.google.common.base.Preconditions;
import org.apache.parquet.Strings;

public final class PathUtils {
    public static final String join(String ... parts) {
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            Preconditions.checkNotNull(part, "parts cannot contain null");
            if (Strings.isNullOrEmpty((String)part)) continue;
            sb.append(part).append("/");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        String path = sb.toString();
        return PathUtils.normalize(path);
    }

    public static final String normalize(String path) {
        if (Strings.isNullOrEmpty((String)Preconditions.checkNotNull(path))) {
            return path;
        }
        StringBuilder builder = new StringBuilder();
        char last = path.charAt(0);
        builder.append(last);
        for (int i = 1; i < path.length(); ++i) {
            char cur = path.charAt(i);
            if (last == '/' && cur == last) continue;
            builder.append(cur);
            last = cur;
        }
        return builder.toString();
    }

    public static String getPathWithProtocol(URL url) {
        if (url.getProtocol() != null) {
            return url.getProtocol() + ":" + url.getPath();
        }
        return url.getPath();
    }
}

