/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.coord.local;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import oadd.com.google.common.collect.Maps;
import oadd.org.apache.drill.exec.coord.ClusterCoordinator;
import oadd.org.apache.drill.exec.coord.DistributedSemaphore;
import oadd.org.apache.drill.exec.coord.local.MapBackedStore;
import oadd.org.apache.drill.exec.coord.store.CachingTransientStoreFactory;
import oadd.org.apache.drill.exec.coord.store.TransientStore;
import oadd.org.apache.drill.exec.coord.store.TransientStoreConfig;
import oadd.org.apache.drill.exec.coord.store.TransientStoreFactory;
import oadd.org.apache.drill.exec.proto.CoordinationProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalClusterCoordinator
extends ClusterCoordinator {
    private static final Logger logger = LoggerFactory.getLogger(LocalClusterCoordinator.class);
    private final Map<ClusterCoordinator.RegistrationHandle, CoordinationProtos.DrillbitEndpoint> endpoints = new ConcurrentHashMap<ClusterCoordinator.RegistrationHandle, CoordinationProtos.DrillbitEndpoint>();
    private final ConcurrentMap<String, DistributedSemaphore> semaphores = Maps.newConcurrentMap();
    private final TransientStoreFactory factory = CachingTransientStoreFactory.of(new TransientStoreFactory(){

        @Override
        public <V> TransientStore<V> getOrCreateStore(TransientStoreConfig<V> config) {
            return new MapBackedStore<V>(config);
        }

        @Override
        public void close() throws Exception {
        }
    });

    @Override
    public void close() throws Exception {
        this.factory.close();
        this.endpoints.clear();
    }

    @Override
    public void start(long millis) throws Exception {
        logger.debug("Local Cluster Coordinator started.");
    }

    @Override
    public ClusterCoordinator.RegistrationHandle register(CoordinationProtos.DrillbitEndpoint data) {
        logger.debug("Endpoint registered {}.", (Object)data);
        Handle h = new Handle(data);
        data = data.toBuilder().setState(CoordinationProtos.DrillbitEndpoint.State.ONLINE).build();
        this.endpoints.put(h, data);
        return h;
    }

    @Override
    public void unregister(ClusterCoordinator.RegistrationHandle handle) {
        if (handle == null) {
            return;
        }
        this.endpoints.remove(handle);
    }

    @Override
    public ClusterCoordinator.RegistrationHandle update(ClusterCoordinator.RegistrationHandle handle, CoordinationProtos.DrillbitEndpoint.State state) {
        CoordinationProtos.DrillbitEndpoint endpoint = handle.getEndPoint();
        endpoint = endpoint.toBuilder().setState(state).build();
        handle.setEndPoint(endpoint);
        this.endpoints.put(handle, endpoint);
        return handle;
    }

    @Override
    public Collection<CoordinationProtos.DrillbitEndpoint> getAvailableEndpoints() {
        return this.endpoints.values();
    }

    @Override
    public Collection<CoordinationProtos.DrillbitEndpoint> getOnlineEndPoints() {
        ArrayList<CoordinationProtos.DrillbitEndpoint> runningEndPoints = new ArrayList<CoordinationProtos.DrillbitEndpoint>();
        for (CoordinationProtos.DrillbitEndpoint endpoint : this.endpoints.values()) {
            if (!this.isDrillbitInState(endpoint, CoordinationProtos.DrillbitEndpoint.State.ONLINE)) continue;
            runningEndPoints.add(endpoint);
        }
        return runningEndPoints;
    }

    @Override
    public DistributedSemaphore getSemaphore(String name, int maximumLeases) {
        if (!this.semaphores.containsKey(name)) {
            this.semaphores.putIfAbsent(name, new LocalSemaphore(maximumLeases));
        }
        return (DistributedSemaphore)this.semaphores.get(name);
    }

    @Override
    public <V> TransientStore<V> getOrCreateTransientStore(TransientStoreConfig<V> config) {
        return this.factory.getOrCreateStore(config);
    }

    public class LocalSemaphore
    implements DistributedSemaphore {
        private final Semaphore semaphore;
        private final LocalLease localLease = new LocalLease();

        public LocalSemaphore(int size) {
            this.semaphore = new Semaphore(size);
        }

        @Override
        public DistributedSemaphore.DistributedLease acquire(long timeout, TimeUnit timeUnit) throws Exception {
            if (!this.semaphore.tryAcquire(timeout, timeUnit)) {
                return null;
            }
            return this.localLease;
        }

        private class LocalLease
        implements DistributedSemaphore.DistributedLease {
            private LocalLease() {
            }

            @Override
            public void close() throws Exception {
                LocalSemaphore.this.semaphore.release();
            }
        }
    }

    private class Handle
    implements ClusterCoordinator.RegistrationHandle {
        private final UUID id = UUID.randomUUID();
        private CoordinationProtos.DrillbitEndpoint drillbitEndpoint;

        @Override
        public CoordinationProtos.DrillbitEndpoint getEndPoint() {
            return this.drillbitEndpoint;
        }

        @Override
        public void setEndPoint(CoordinationProtos.DrillbitEndpoint endpoint) {
            this.drillbitEndpoint = endpoint;
        }

        private Handle(CoordinationProtos.DrillbitEndpoint data) {
            this.drillbitEndpoint = data;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Handle other = (Handle)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }

        private LocalClusterCoordinator getOuterType() {
            return LocalClusterCoordinator.this;
        }
    }
}

