/*
 * Decompiled with CFR 0.152.
 */
package oadd.io.netty.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import oadd.com.google.common.base.Preconditions;
import oadd.io.netty.buffer.AbstractByteBuf;
import oadd.io.netty.buffer.ByteBuf;
import oadd.io.netty.buffer.ByteBufAllocator;
import oadd.io.netty.buffer.ByteBufUtil;
import oadd.io.netty.buffer.UnsafeDirectLittleEndian;
import oadd.io.netty.util.internal.PlatformDependent;
import oadd.org.apache.drill.common.HistoricalLog;
import oadd.org.apache.drill.exec.memory.AllocationManager;
import oadd.org.apache.drill.exec.memory.BaseAllocator;
import oadd.org.apache.drill.exec.memory.BoundsChecking;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.ops.BufferManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DrillBuf
extends AbstractByteBuf
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(DrillBuf.class);
    private static final AtomicLong idGenerator = new AtomicLong(0L);
    private final long id = idGenerator.incrementAndGet();
    private final AtomicInteger refCnt;
    private final UnsafeDirectLittleEndian udle;
    private final long addr;
    private final int offset;
    private final AllocationManager.BufferLedger ledger;
    private final BufferManager bufManager;
    private final boolean isEmpty;
    private volatile int length;
    private final HistoricalLog historicalLog = BaseAllocator.DEBUG ? new HistoricalLog(6, "DrillBuf[%d]", this.id) : null;
    private static final int LOG_BYTES_PER_ROW = 10;
    private static final char[] HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final int LONG_NUM_BYTES = 8;
    public static final int INT_NUM_BYTES = 4;
    public static final int SHORT_NUM_BYTES = 2;

    public DrillBuf(AtomicInteger refCnt, AllocationManager.BufferLedger ledger, UnsafeDirectLittleEndian byteBuf, BufferManager manager, ByteBufAllocator alloc, int offset, int length, boolean isEmpty) {
        super(byteBuf.maxCapacity());
        this.refCnt = refCnt;
        this.udle = byteBuf;
        this.isEmpty = isEmpty;
        this.bufManager = manager;
        this.addr = byteBuf.memoryAddress() + (long)offset;
        this.ledger = ledger;
        this.length = length;
        this.offset = offset;
        if (BaseAllocator.DEBUG) {
            this.historicalLog.recordEvent("create()", new Object[0]);
        }
    }

    public DrillBuf reallocIfNeeded(int size) {
        Preconditions.checkArgument(size >= 0, "reallocation size must be non-negative");
        if (this.capacity() >= size) {
            return this;
        }
        if (this.bufManager != null) {
            return this.bufManager.replace(this, size);
        }
        throw new UnsupportedOperationException("Realloc is only available in the context of an operator's UDFs");
    }

    @Override
    public int refCnt() {
        if (this.isEmpty) {
            return 1;
        }
        return this.refCnt.get();
    }

    public long addr() {
        return this.addr;
    }

    private long addr(int index) {
        return this.addr + (long)index;
    }

    private void chk(int index, int width) {
        BoundsChecking.lengthCheck(this, index, width);
    }

    public DrillBuf retain(BufferAllocator target) {
        if (this.isEmpty) {
            return this;
        }
        if (BaseAllocator.DEBUG) {
            this.historicalLog.recordEvent("retain(%s)", target.getName());
        }
        AllocationManager.BufferLedger otherLedger = this.ledger.getLedgerForAllocator(target);
        return otherLedger.newDrillBuf(this.offset, this.length, null);
    }

    public TransferResult transferOwnership(BufferAllocator target) {
        if (this.isEmpty) {
            return new TransferResult(true, this);
        }
        AllocationManager.BufferLedger otherLedger = this.ledger.getLedgerForAllocator(target);
        DrillBuf newBuf = otherLedger.newDrillBuf(this.offset, this.length, null);
        boolean allocationFit = this.ledger.transferBalance(otherLedger);
        return new TransferResult(allocationFit, newBuf);
    }

    public AllocationManager.BufferLedger getLedger() {
        return this.ledger;
    }

    @Override
    public boolean release() {
        return this.release(1);
    }

    @Override
    public boolean release(int decrement) {
        if (this.isEmpty) {
            return false;
        }
        if (decrement < 1) {
            throw new IllegalStateException(String.format("release(%d) argument is not positive. Buffer Info: %s", decrement, this.toVerboseString()));
        }
        int refCnt = this.ledger.decrement(decrement);
        if (BaseAllocator.DEBUG) {
            this.historicalLog.recordEvent("release(%d). original value: %d", decrement, refCnt + decrement);
        }
        if (refCnt < 0) {
            throw new IllegalStateException(String.format("DrillBuf[%d] refCnt has gone negative. Buffer Info: %s", this.id, this.toVerboseString()));
        }
        return refCnt == 0;
    }

    @Override
    public int capacity() {
        return this.length;
    }

    @Override
    public synchronized DrillBuf capacity(int newCapacity) {
        if (newCapacity == this.length) {
            return this;
        }
        Preconditions.checkArgument(newCapacity >= 0);
        if (newCapacity < this.length) {
            this.length = newCapacity;
            return this;
        }
        throw new UnsupportedOperationException("Buffers don't support resizing that increases the size.");
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.udle.alloc();
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }

    @Override
    public ByteBuf order(ByteOrder endianness) {
        return this;
    }

    @Override
    public ByteBuf unwrap() {
        return this.udle;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public ByteBuf readBytes(int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf readSlice(int length) {
        DrillBuf slice = this.slice(this.readerIndex(), length);
        this.readerIndex(this.readerIndex() + length);
        return slice;
    }

    @Override
    public ByteBuf copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf copy(int index, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf slice() {
        return this.slice(this.readerIndex(), this.readableBytes());
    }

    public static String bufferState(ByteBuf buf) {
        int cap = buf.capacity();
        int mcap = buf.maxCapacity();
        int ri = buf.readerIndex();
        int rb = buf.readableBytes();
        int wi = buf.writerIndex();
        int wb = buf.writableBytes();
        return String.format("cap/max: %d/%d, ri: %d, rb: %d, wi: %d, wb: %d", cap, mcap, ri, rb, wi, wb);
    }

    @Override
    public DrillBuf slice(int index, int length) {
        if (this.isEmpty) {
            return this;
        }
        DrillBuf newBuf = this.ledger.newDrillBuf(this.offset + index, length);
        newBuf.writerIndex(length);
        return newBuf;
    }

    @Override
    public DrillBuf duplicate() {
        return this.slice(0, this.length);
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer nioBuffer() {
        return this.nioBuffer(this.readerIndex(), this.readableBytes());
    }

    @Override
    public ByteBuffer nioBuffer(int index, int length) {
        return this.udle.nioBuffer(this.offset + index, length);
    }

    @Override
    public ByteBuffer internalNioBuffer(int index, int length) {
        return this.udle.internalNioBuffer(this.offset + index, length);
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        return new ByteBuffer[]{this.nioBuffer()};
    }

    @Override
    public ByteBuffer[] nioBuffers(int index, int length) {
        return new ByteBuffer[]{this.nioBuffer(index, length)};
    }

    @Override
    public boolean hasArray() {
        return this.udle.hasArray();
    }

    @Override
    public byte[] array() {
        return this.udle.array();
    }

    @Override
    public int arrayOffset() {
        return this.udle.arrayOffset();
    }

    @Override
    public boolean hasMemoryAddress() {
        return true;
    }

    @Override
    public long memoryAddress() {
        return this.addr;
    }

    @Override
    public String toString() {
        return String.format("DrillBuf[%d], udle: [%d %d..%d]", this.id, this.udle.id, this.offset, this.offset + this.capacity());
    }

    @Override
    public String toString(Charset charset) {
        return this.toString(this.readerIndex, this.readableBytes(), charset);
    }

    @Override
    public String toString(int index, int length, Charset charset) {
        if (length == 0) {
            return "";
        }
        return ByteBufUtil.decodeString(this, index, length, charset);
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public ByteBuf retain(int increment) {
        int originalReferenceCount;
        Preconditions.checkArgument(increment > 0, "retain(%d) argument is not positive", increment);
        if (this.isEmpty) {
            return this;
        }
        if (BaseAllocator.DEBUG) {
            this.historicalLog.recordEvent("retain(%d)", increment);
        }
        Preconditions.checkArgument((originalReferenceCount = this.refCnt.getAndAdd(increment)) > 0);
        return this;
    }

    @Override
    public ByteBuf retain() {
        return this.retain(1);
    }

    @Override
    public long getLong(int index) {
        this.chk(index, 8);
        long v = PlatformDependent.getLong(this.addr(index));
        return v;
    }

    @Override
    public float getFloat(int index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    @Override
    public double getDouble(int index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    @Override
    public char getChar(int index) {
        return (char)this.getShort(index);
    }

    @Override
    public long getUnsignedInt(int index) {
        return (long)this.getInt(index) & 0xFFFFFFFFL;
    }

    @Override
    public int getInt(int index) {
        this.chk(index, 4);
        int v = PlatformDependent.getInt(this.addr(index));
        return v;
    }

    @Override
    public int getUnsignedShort(int index) {
        return this.getShort(index) & 0xFFFF;
    }

    @Override
    public short getShort(int index) {
        this.chk(index, 2);
        short v = PlatformDependent.getShort(this.addr(index));
        return v;
    }

    @Override
    public ByteBuf setShort(int index, int value) {
        this.chk(index, 2);
        PlatformDependent.putShort(this.addr(index), (short)value);
        return this;
    }

    @Override
    public ByteBuf setInt(int index, int value) {
        this.chk(index, 4);
        PlatformDependent.putInt(this.addr(index), value);
        return this;
    }

    @Override
    public ByteBuf setLong(int index, long value) {
        this.chk(index, 8);
        PlatformDependent.putLong(this.addr(index), value);
        return this;
    }

    @Override
    public ByteBuf setChar(int index, int value) {
        this.chk(index, 2);
        PlatformDependent.putShort(this.addr(index), (short)value);
        return this;
    }

    @Override
    public ByteBuf setFloat(int index, float value) {
        this.chk(index, 4);
        PlatformDependent.putInt(this.addr(index), Float.floatToRawIntBits(value));
        return this;
    }

    @Override
    public ByteBuf setDouble(int index, double value) {
        this.chk(index, 8);
        PlatformDependent.putLong(this.addr(index), Double.doubleToRawLongBits(value));
        return this;
    }

    @Override
    public ByteBuf writeShort(int value) {
        BoundsChecking.ensureWritable(this, 2);
        PlatformDependent.putShort(this.addr(this.writerIndex), (short)value);
        this.writerIndex += 2;
        return this;
    }

    @Override
    public ByteBuf writeInt(int value) {
        BoundsChecking.ensureWritable(this, 4);
        PlatformDependent.putInt(this.addr(this.writerIndex), value);
        this.writerIndex += 4;
        return this;
    }

    @Override
    public ByteBuf writeLong(long value) {
        BoundsChecking.ensureWritable(this, 8);
        PlatformDependent.putLong(this.addr(this.writerIndex), value);
        this.writerIndex += 8;
        return this;
    }

    @Override
    public ByteBuf writeChar(int value) {
        BoundsChecking.ensureWritable(this, 2);
        PlatformDependent.putShort(this.addr(this.writerIndex), (short)value);
        this.writerIndex += 2;
        return this;
    }

    @Override
    public ByteBuf writeFloat(float value) {
        BoundsChecking.ensureWritable(this, 4);
        PlatformDependent.putInt(this.addr(this.writerIndex), Float.floatToRawIntBits(value));
        this.writerIndex += 4;
        return this;
    }

    @Override
    public ByteBuf writeDouble(double value) {
        BoundsChecking.ensureWritable(this, 8);
        PlatformDependent.putLong(this.addr(this.writerIndex), Double.doubleToRawLongBits(value));
        this.writerIndex += 8;
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.udle.getBytes(index + this.offset, dst, dstIndex, length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuffer dst) {
        this.udle.getBytes(index + this.offset, dst);
        return this;
    }

    @Override
    public ByteBuf setByte(int index, int value) {
        this.chk(index, 1);
        PlatformDependent.putByte(this.addr(index), (byte)value);
        return this;
    }

    public void setByte(int index, byte b) {
        this.chk(index, 1);
        PlatformDependent.putByte(this.addr(index), b);
    }

    public void writeByteUnsafe(byte b) {
        PlatformDependent.putByte(this.addr(this.readerIndex), b);
        ++this.readerIndex;
    }

    @Override
    protected byte _getByte(int index) {
        return this.getByte(index);
    }

    @Override
    protected short _getShort(int index) {
        return this.getShort(index);
    }

    @Override
    protected int _getInt(int index) {
        return this.getInt(index);
    }

    @Override
    protected long _getLong(int index) {
        return this.getLong(index);
    }

    @Override
    protected void _setByte(int index, int value) {
        this.setByte(index, value);
    }

    @Override
    protected void _setShort(int index, int value) {
        this.setShort(index, value);
    }

    @Override
    protected void _setMedium(int index, int value) {
        this.setMedium(index, value);
    }

    @Override
    protected void _setInt(int index, int value) {
        this.setInt(index, value);
    }

    @Override
    protected void _setLong(int index, long value) {
        this.setLong(index, value);
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        int BULK_COPY_THR = 16;
        if (length < 16 && this.udle.hasMemoryAddress() && dst.hasMemoryAddress()) {
            if (dst.capacity() < dstIndex + length) {
                throw new IndexOutOfBoundsException();
            }
            for (int idx = 0; idx < length; ++idx) {
                byte value = this.getByte(index + idx);
                PlatformDependent.putByte(dst.memoryAddress() + (long)dstIndex + (long)idx, value);
            }
        } else {
            this.udle.getBytes(index + this.offset, dst, dstIndex, length);
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        this.udle.getBytes(index + this.offset, out, length);
        return this;
    }

    @Override
    protected int _getUnsignedMedium(int index) {
        long addr = this.addr(index);
        return (PlatformDependent.getByte(addr) & 0xFF) << 16 | (PlatformDependent.getByte(addr + 1L) & 0xFF) << 8 | PlatformDependent.getByte(addr + 2L) & 0xFF;
    }

    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        return this.udle.getBytes(index + this.offset, out, length);
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        this.udle.setBytes(index + this.offset, src, srcIndex, length);
        return this;
    }

    public ByteBuf setBytes(int index, ByteBuffer src, int srcIndex, int length) {
        if (src.isDirect()) {
            this.checkIndex(index, length);
            PlatformDependent.copyMemory(PlatformDependent.directBufferAddress(src) + (long)srcIndex, this.memoryAddress() + (long)index, length);
        } else if (srcIndex == 0 && src.capacity() == length) {
            this.udle.setBytes(index + this.offset, src);
        } else {
            ByteBuffer newBuf = src.duplicate();
            newBuf.position(srcIndex);
            newBuf.limit(srcIndex + length);
            this.udle.setBytes(index + this.offset, src);
        }
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        this.udle.setBytes(index + this.offset, src, srcIndex, length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuffer src) {
        this.udle.setBytes(index + this.offset, src);
        return this;
    }

    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        return this.udle.setBytes(index + this.offset, in, length);
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        return this.udle.setBytes(index + this.offset, in, length);
    }

    @Override
    public byte getByte(int index) {
        this.chk(index, 1);
        return PlatformDependent.getByte(this.addr(index));
    }

    @Override
    public void close() {
        this.release();
    }

    public int getPossibleMemoryConsumed() {
        return this.ledger.getSize();
    }

    public int getActualMemoryConsumed() {
        return this.ledger.getAccountedSize();
    }

    public String toHexString(int start, int length) {
        Preconditions.checkArgument(start >= 0);
        StringBuilder sb = new StringBuilder("buffer byte dump");
        int end = Math.min(length, this.length - start);
        for (int i = 0; i < end; ++i) {
            if (i % 10 == 0) {
                sb.append(String.format("%n [%05d-%05d]", i + start, Math.min(i + 10 - 1, end - 1) + start));
            }
            byte b = this._getByte(i + start);
            sb.append(" 0x").append(HEX_CHAR[b >> 4]).append(HEX_CHAR[b & 0xF]);
        }
        if (length > end) {
            sb.append(String.format("%n [%05d-%05d] <ioob>", start + end, start + length));
        }
        return sb.append(System.lineSeparator()).toString();
    }

    public long getId() {
        return this.id;
    }

    public String toVerboseString() {
        if (this.isEmpty) {
            return this.toString();
        }
        StringBuilder sb = new StringBuilder();
        this.ledger.print(sb, 0, BaseAllocator.Verbosity.LOG_WITH_STACKTRACE);
        return sb.toString();
    }

    public void print(StringBuilder sb, int indent, BaseAllocator.Verbosity verbosity) {
        BaseAllocator.indent(sb, indent).append(this.toString());
        if (BaseAllocator.DEBUG && !this.isEmpty && verbosity.includeHistoricalLog) {
            sb.append("\n");
            this.historicalLog.buildHistory(sb, indent + 1, verbosity.includeStackTraces);
        }
    }

    public byte[] unsafeGetMemory(int srcOffset, int length) {
        byte[] buf = new byte[length];
        PlatformDependent.copyMemory(this.addr + (long)srcOffset, buf, 0, (long)length);
        return buf;
    }

    public static short getShort(byte[] data, int index) {
        DrillBuf.check(index, 2, data.length);
        return PlatformDependent.getShort(data, index);
    }

    public static int getInt(byte[] data, int index) {
        DrillBuf.check(index, 4, data.length);
        return PlatformDependent.getInt(data, index);
    }

    public static long getLong(byte[] data, int index) {
        DrillBuf.check(index, 8, data.length);
        return PlatformDependent.getLong(data, index);
    }

    public static void putShort(byte[] src, int srcIndex, byte[] dest, int destIndex) {
        DrillBuf.check(srcIndex, 2, src.length);
        DrillBuf.check(destIndex, 2, dest.length);
        short value = PlatformDependent.getShort(src, srcIndex);
        PlatformDependent.putShort(dest, destIndex, value);
    }

    public static void putInt(byte[] src, int srcIndex, byte[] dest, int destIndex) {
        DrillBuf.check(srcIndex, 4, src.length);
        DrillBuf.check(destIndex, 4, dest.length);
        int value = PlatformDependent.getInt(src, srcIndex);
        PlatformDependent.putInt(dest, destIndex, value);
    }

    public static void putLong(byte[] src, int srcIndex, byte[] dest, int destIndex) {
        DrillBuf.check(srcIndex, 8, src.length);
        DrillBuf.check(destIndex, 8, dest.length);
        long value = PlatformDependent.getLong(src, srcIndex);
        PlatformDependent.putLong(dest, destIndex, value);
    }

    public static void putShort(byte[] dest, int destIndex, short value) {
        DrillBuf.check(destIndex, 2, dest.length);
        PlatformDependent.putShort(dest, destIndex, value);
    }

    public static void putInt(byte[] dest, int destIndex, int value) {
        DrillBuf.check(destIndex, 4, dest.length);
        PlatformDependent.putInt(dest, destIndex, value);
    }

    public static void putLong(byte[] dest, int destIndex, long value) {
        DrillBuf.check(destIndex, 8, dest.length);
        PlatformDependent.putLong(dest, destIndex, value);
    }

    private static void check(int index, int len, int bufferLen) {
        if (BoundsChecking.BOUNDS_CHECKING_ENABLED) {
            if (index < 0 || len < 0) {
                throw new IllegalArgumentException(String.format("index: [%d], len: [%d]", index, len));
            }
            if (index + len > bufferLen) {
                throw new IndexOutOfBoundsException(String.format("Trying to access more than buffer length; index: [%d], len: [%d], buffer-len: [%d]", index, len, bufferLen));
            }
        }
    }

    public class TransferResult {
        public final boolean allocationFit;
        public final DrillBuf buffer;

        private TransferResult(boolean allocationFit, DrillBuf buffer) {
            this.allocationFit = allocationFit;
            this.buffer = buffer;
        }
    }
}

