/*
 * Decompiled with CFR 0.152.
 */
package com.jasonclawson.jackson.dataformat.hocon;

import com.jasonclawson.jackson.dataformat.hocon.HoconJsonLocation;
import com.jasonclawson.jackson.dataformat.hocon.HoconNodeCursor;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import oadd.com.fasterxml.jackson.core.Base64Variant;
import oadd.com.fasterxml.jackson.core.JsonLocation;
import oadd.com.fasterxml.jackson.core.JsonParseException;
import oadd.com.fasterxml.jackson.core.JsonParser;
import oadd.com.fasterxml.jackson.core.JsonStreamContext;
import oadd.com.fasterxml.jackson.core.JsonToken;
import oadd.com.fasterxml.jackson.core.ObjectCodec;
import oadd.com.fasterxml.jackson.core.Version;
import oadd.com.fasterxml.jackson.core.base.ParserMinimalBase;
import oadd.com.fasterxml.jackson.databind.cfg.PackageVersion;
import oadd.com.typesafe.config.ConfigObject;
import oadd.com.typesafe.config.ConfigValue;
import oadd.com.typesafe.config.ConfigValueType;

public class HoconTreeTraversingParser
extends ParserMinimalBase {
    protected ObjectCodec _objectCodec;
    protected HoconNodeCursor _nodeCursor;
    protected JsonToken _nextToken;
    protected boolean _startContainer;
    protected boolean _closed;
    private final ConfigObject _rootObject;

    public ConfigObject getConfigObject() {
        return this._rootObject;
    }

    public HoconTreeTraversingParser(ConfigObject n) {
        this(n, null);
    }

    public HoconTreeTraversingParser(ConfigObject n, ObjectCodec codec) {
        super(0);
        this._rootObject = n;
        this._objectCodec = codec;
        if (n.valueType() == ConfigValueType.LIST) {
            this._nextToken = JsonToken.START_ARRAY;
            this._nodeCursor = new HoconNodeCursor.Array(n, null);
        } else if (n.valueType() == ConfigValueType.OBJECT) {
            if (HoconNodeCursor.isNumericallyIndexed(n)) {
                this._nextToken = JsonToken.START_ARRAY;
                this._nodeCursor = new HoconNodeCursor.NumericallyIndexedObjectBackedArray(n, null);
            } else {
                this._nextToken = JsonToken.START_OBJECT;
                this._nodeCursor = new HoconNodeCursor.Object(n, null);
            }
        } else {
            this._nodeCursor = new HoconNodeCursor.RootValue(n, null);
        }
    }

    public static JsonToken asJsonToken(ConfigValue value) {
        if (HoconNodeCursor.isNumericallyIndexed(value)) {
            return JsonToken.START_ARRAY;
        }
        switch (value.valueType()) {
            case BOOLEAN: {
                boolean bool = (Boolean)value.unwrapped();
                return bool ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
            }
            case NULL: {
                return JsonToken.VALUE_NULL;
            }
            case NUMBER: {
                Number unwrapped = (Number)value.unwrapped();
                if (unwrapped instanceof Double) {
                    return JsonToken.VALUE_NUMBER_FLOAT;
                }
                return JsonToken.VALUE_NUMBER_INT;
            }
            case STRING: {
                return JsonToken.VALUE_STRING;
            }
            case LIST: {
                return JsonToken.START_ARRAY;
            }
            case OBJECT: {
                return JsonToken.START_OBJECT;
            }
        }
        throw new IllegalArgumentException("Unhandled type " + (Object)((Object)value.valueType()));
    }

    @Override
    public void setCodec(ObjectCodec c) {
        this._objectCodec = c;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public void close() throws IOException {
        if (!this._closed) {
            this._closed = true;
            this._nodeCursor = null;
            this._currToken = null;
        }
    }

    @Override
    public JsonToken nextToken() throws IOException, JsonParseException {
        if (this._nextToken != null) {
            this._currToken = this._nextToken;
            this._nextToken = null;
            return this._currToken;
        }
        if (this._startContainer) {
            this._startContainer = false;
            if (!this._nodeCursor.currentHasChildren()) {
                this._currToken = this._currToken == JsonToken.START_OBJECT ? JsonToken.END_OBJECT : JsonToken.END_ARRAY;
                return this._currToken;
            }
            this._nodeCursor = this._nodeCursor.iterateChildren();
            this._currToken = this._nodeCursor.nextToken();
            if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
                this._startContainer = true;
            }
            return this._currToken;
        }
        if (this._nodeCursor == null) {
            this._closed = true;
            return null;
        }
        this._currToken = this._nodeCursor.nextToken();
        if (this._currToken != null) {
            if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
                this._startContainer = true;
            }
            return this._currToken;
        }
        this._currToken = this._nodeCursor.endToken();
        this._nodeCursor = this._nodeCursor.getParent();
        return this._currToken;
    }

    @Override
    public JsonParser skipChildren() throws IOException, JsonParseException {
        if (this._currToken == JsonToken.START_OBJECT) {
            this._startContainer = false;
            this._currToken = JsonToken.END_OBJECT;
        } else if (this._currToken == JsonToken.START_ARRAY) {
            this._startContainer = false;
            this._currToken = JsonToken.END_ARRAY;
        }
        return this;
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public String getCurrentName() {
        return this._nodeCursor == null ? null : this._nodeCursor.getCurrentName();
    }

    @Override
    public void overrideCurrentName(String name) {
        if (this._nodeCursor != null) {
            this._nodeCursor.overrideCurrentName(name);
        }
    }

    @Override
    public JsonStreamContext getParsingContext() {
        return this._nodeCursor;
    }

    @Override
    public JsonLocation getTokenLocation() {
        ConfigValue node = this.currentNode();
        return node == null ? JsonLocation.NA : new HoconJsonLocation(node.origin());
    }

    @Override
    public JsonLocation getCurrentLocation() {
        ConfigValue node = this.currentNode();
        return node == null ? JsonLocation.NA : new HoconJsonLocation(node.origin());
    }

    @Override
    public String getText() {
        if (this._closed) {
            return null;
        }
        switch (this._currToken) {
            case FIELD_NAME: {
                return this._nodeCursor.getCurrentName();
            }
            case VALUE_STRING: {
                return (String)this.currentNode().unwrapped();
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return String.valueOf(this.currentNode().unwrapped());
            }
            case VALUE_EMBEDDED_OBJECT: {
                throw new UnsupportedOperationException("VALUE_EMBEDDED_OBJECT is not supported by HOCON");
            }
        }
        return this._currToken == null ? null : this._currToken.asString();
    }

    @Override
    public char[] getTextCharacters() throws IOException, JsonParseException {
        return this.getText().toCharArray();
    }

    @Override
    public int getTextLength() throws IOException, JsonParseException {
        return this.getText().length();
    }

    @Override
    public int getTextOffset() throws IOException, JsonParseException {
        return 0;
    }

    @Override
    public boolean hasTextCharacters() {
        return false;
    }

    @Override
    public JsonParser.NumberType getNumberType() throws IOException, JsonParseException {
        ConfigValue n = this.currentNumericNode();
        if (n == null) {
            return null;
        }
        Number value = (Number)n.unwrapped();
        if (value instanceof Double) {
            return JsonParser.NumberType.DOUBLE;
        }
        if (value instanceof Long) {
            return JsonParser.NumberType.LONG;
        }
        return JsonParser.NumberType.INT;
    }

    @Override
    public BigInteger getBigIntegerValue() throws IOException, JsonParseException {
        Long value = ((Number)this.currentNumericNode().unwrapped()).longValue();
        return BigInteger.valueOf(value);
    }

    @Override
    public BigDecimal getDecimalValue() throws IOException, JsonParseException {
        Double value = ((Number)this.currentNumericNode().unwrapped()).doubleValue();
        return BigDecimal.valueOf(value);
    }

    @Override
    public double getDoubleValue() throws IOException, JsonParseException {
        return ((Number)this.currentNumericNode().unwrapped()).doubleValue();
    }

    @Override
    public float getFloatValue() throws IOException, JsonParseException {
        return ((Number)this.currentNumericNode().unwrapped()).floatValue();
    }

    @Override
    public long getLongValue() throws IOException, JsonParseException {
        return ((Number)this.currentNumericNode().unwrapped()).longValue();
    }

    @Override
    public int getIntValue() throws IOException, JsonParseException {
        return ((Number)this.currentNumericNode().unwrapped()).intValue();
    }

    @Override
    public Number getNumberValue() throws IOException, JsonParseException {
        return (Number)this.currentNumericNode().unwrapped();
    }

    @Override
    public Object getEmbeddedObject() {
        return null;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant b64variant) throws IOException, JsonParseException {
        return null;
    }

    @Override
    public int readBinaryValue(Base64Variant b64variant, OutputStream out) throws IOException, JsonParseException {
        byte[] data = this.getBinaryValue(b64variant);
        if (data != null) {
            out.write(data, 0, data.length);
            return data.length;
        }
        return 0;
    }

    protected ConfigValue currentNode() {
        if (this._closed || this._nodeCursor == null) {
            return null;
        }
        return this._nodeCursor.currentNode();
    }

    protected ConfigValue currentNumericNode() throws JsonParseException {
        ConfigValue n = this.currentNode();
        if (n == null || n.valueType() != ConfigValueType.NUMBER) {
            JsonToken t = n == null ? null : HoconTreeTraversingParser.asJsonToken(n);
            throw this._constructError("Current token (" + (Object)((Object)t) + ") not numeric, can not use numeric value accessors");
        }
        return n;
    }

    @Override
    protected void _handleEOF() throws JsonParseException {
        this._throwInternal();
    }
}

