/*
 * Decompiled with CFR 0.152.
 */
package com.jasonclawson.jackson.dataformat.hocon;

import com.jasonclawson.jackson.dataformat.hocon.HoconTreeTraversingParser;
import com.jasonclawson.jackson.dataformat.hocon.UTF8Reader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import oadd.com.fasterxml.jackson.core.JsonEncoding;
import oadd.com.fasterxml.jackson.core.JsonFactory;
import oadd.com.fasterxml.jackson.core.JsonGenerator;
import oadd.com.fasterxml.jackson.core.JsonParseException;
import oadd.com.fasterxml.jackson.core.JsonParser;
import oadd.com.fasterxml.jackson.core.ObjectCodec;
import oadd.com.fasterxml.jackson.core.format.InputAccessor;
import oadd.com.fasterxml.jackson.core.format.MatchStrength;
import oadd.com.fasterxml.jackson.core.io.IOContext;
import oadd.com.typesafe.config.Config;
import oadd.com.typesafe.config.ConfigFactory;

public class HoconFactory
extends JsonFactory {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT_NAME_HOCON = "HOCON";
    private static final byte UTF8_BOM_1 = -17;
    private static final byte UTF8_BOM_2 = -69;
    private static final byte UTF8_BOM_3 = -65;

    public HoconFactory() {
        this(null);
    }

    public HoconFactory(ObjectCodec oc) {
        super(oc);
    }

    public HoconFactory(HoconFactory src, ObjectCodec oc) {
        super(src, oc);
    }

    @Override
    public HoconFactory copy() {
        this._checkInvalidCopy(HoconFactory.class);
        return new HoconFactory(this, null);
    }

    @Override
    protected Object readResolve() {
        return new HoconFactory(this, this._objectCodec);
    }

    @Override
    public String getFormatName() {
        return FORMAT_NAME_HOCON;
    }

    @Override
    public MatchStrength hasFormat(InputAccessor acc) throws IOException {
        if (!acc.hasMoreBytes()) {
            return MatchStrength.INCONCLUSIVE;
        }
        byte b = acc.nextByte();
        if (b == -17) {
            if (!acc.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (acc.nextByte() != -69) {
                return MatchStrength.NO_MATCH;
            }
            if (!acc.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (acc.nextByte() != -65) {
                return MatchStrength.NO_MATCH;
            }
            if (!acc.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            b = acc.nextByte();
        }
        if (b == 123 || Character.isLetter((char)b) || Character.isDigit((char)b)) {
            return MatchStrength.WEAK_MATCH;
        }
        return MatchStrength.INCONCLUSIVE;
    }

    @Override
    public HoconTreeTraversingParser createParser(String content) throws IOException, JsonParseException {
        Reader r = new StringReader(content);
        IOContext ctxt = this._createContext(r, true);
        if (this._inputDecorator != null) {
            r = this._inputDecorator.decorate(ctxt, r);
        }
        return this._createParser(r, ctxt);
    }

    @Override
    public HoconTreeTraversingParser createParser(File f) throws IOException, JsonParseException {
        Config resolvedConfig = ConfigFactory.parseFile(f).resolve();
        return new HoconTreeTraversingParser(resolvedConfig.root(), this._objectCodec);
    }

    @Override
    public HoconTreeTraversingParser createParser(URL url) throws IOException, JsonParseException {
        Config resolvedConfig = ConfigFactory.parseURL(url).resolve();
        return new HoconTreeTraversingParser(resolvedConfig.root(), this._objectCodec);
    }

    @Override
    public HoconTreeTraversingParser createParser(InputStream in) throws IOException, JsonParseException {
        IOContext ctxt = this._createContext(in, false);
        if (this._inputDecorator != null) {
            in = this._inputDecorator.decorate(ctxt, in);
        }
        return this._createParser(in, ctxt);
    }

    @Override
    public JsonParser createParser(Reader r) throws IOException, JsonParseException {
        IOContext ctxt = this._createContext(r, false);
        if (this._inputDecorator != null) {
            r = this._inputDecorator.decorate(ctxt, r);
        }
        return this._createParser(r, ctxt);
    }

    @Override
    public HoconTreeTraversingParser createParser(byte[] data) throws IOException, JsonParseException {
        InputStream in;
        IOContext ctxt = this._createContext(data, true);
        if (this._inputDecorator != null && (in = this._inputDecorator.decorate(ctxt, data, 0, data.length)) != null) {
            return this._createParser(in, ctxt);
        }
        return this._createParser(data, 0, data.length, ctxt);
    }

    @Override
    public HoconTreeTraversingParser createParser(byte[] data, int offset, int len) throws IOException, JsonParseException {
        InputStream in;
        IOContext ctxt = this._createContext(data, true);
        if (this._inputDecorator != null && (in = this._inputDecorator.decorate(ctxt, data, offset, len)) != null) {
            return this._createParser(in, ctxt);
        }
        return this._createParser(data, offset, len, ctxt);
    }

    @Override
    @Deprecated
    public HoconTreeTraversingParser createJsonParser(String content) throws IOException, JsonParseException {
        return this.createParser(content);
    }

    @Override
    @Deprecated
    public HoconTreeTraversingParser createJsonParser(File f) throws IOException, JsonParseException {
        return this.createParser(f);
    }

    @Override
    @Deprecated
    public HoconTreeTraversingParser createJsonParser(URL url) throws IOException, JsonParseException {
        return this.createParser(url);
    }

    @Override
    @Deprecated
    public HoconTreeTraversingParser createJsonParser(InputStream in) throws IOException, JsonParseException {
        return this.createParser(in);
    }

    @Override
    @Deprecated
    public JsonParser createJsonParser(Reader r) throws IOException, JsonParseException {
        return this.createParser(r);
    }

    @Override
    @Deprecated
    public HoconTreeTraversingParser createJsonParser(byte[] data) throws IOException, JsonParseException {
        return this.createParser(data);
    }

    @Override
    @Deprecated
    public HoconTreeTraversingParser createJsonParser(byte[] data, int offset, int len) throws IOException, JsonParseException {
        return this.createParser(data, offset, len);
    }

    @Override
    public JsonGenerator createGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        throw new UnsupportedOperationException("Generating HOCON is not supported yet");
    }

    @Override
    public JsonGenerator createGenerator(OutputStream out) throws IOException {
        throw new UnsupportedOperationException("Generating HOCON is not supported yet");
    }

    @Override
    public JsonGenerator createGenerator(Writer out) throws IOException {
        throw new UnsupportedOperationException("Generating HOCON is not supported yet");
    }

    @Override
    @Deprecated
    public JsonGenerator createJsonGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        throw new UnsupportedOperationException("Generating HOCON is not supported yet");
    }

    @Override
    @Deprecated
    public JsonGenerator createJsonGenerator(OutputStream out) throws IOException {
        throw new UnsupportedOperationException("Generating HOCON is not supported yet");
    }

    @Override
    @Deprecated
    public JsonGenerator createJsonGenerator(Writer out) throws IOException {
        throw new UnsupportedOperationException("Generating HOCON is not supported yet");
    }

    @Override
    protected HoconTreeTraversingParser _createParser(InputStream in, IOContext ctxt) throws IOException, JsonParseException {
        Reader r = this._createReader(in, null, ctxt);
        return this._createParser(r, ctxt);
    }

    @Override
    protected HoconTreeTraversingParser _createParser(Reader r, IOContext ctxt) throws IOException, JsonParseException {
        Config resolvedConfig = ConfigFactory.parseReader(r).resolve();
        return new HoconTreeTraversingParser(resolvedConfig.root(), this._objectCodec);
    }

    @Override
    protected HoconTreeTraversingParser _createParser(byte[] data, int offset, int len, IOContext ctxt) throws IOException, JsonParseException {
        Reader r = this._createReader(data, offset, len, null, ctxt);
        return this._createParser(r, ctxt);
    }

    @Override
    protected JsonGenerator _createGenerator(Writer out, IOContext ctxt) throws IOException {
        throw new UnsupportedOperationException("Generating HOCON is not supported yet");
    }

    @Override
    @Deprecated
    protected JsonGenerator _createUTF8Generator(OutputStream out, IOContext ctxt) throws IOException {
        throw new UnsupportedOperationException("Generating HOCON is not supported yet");
    }

    @Override
    protected Writer _createWriter(OutputStream out, JsonEncoding enc, IOContext ctxt) throws IOException {
        throw new UnsupportedOperationException("Generating HOCON is not supported yet");
    }

    protected Reader _createReader(InputStream in, JsonEncoding enc, IOContext ctxt) throws IOException {
        if (enc == null) {
            enc = JsonEncoding.UTF8;
        }
        if (enc == JsonEncoding.UTF8) {
            boolean autoClose = ctxt.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE);
            return new UTF8Reader(in, autoClose);
        }
        return new InputStreamReader(in, enc.getJavaName());
    }

    protected Reader _createReader(byte[] data, int offset, int len, JsonEncoding enc, IOContext ctxt) throws IOException {
        if (enc == null) {
            enc = JsonEncoding.UTF8;
        }
        if (enc == null || enc == JsonEncoding.UTF8) {
            return new UTF8Reader(data, offset, len, true);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(data, offset, len);
        return new InputStreamReader((InputStream)in, enc.getJavaName());
    }
}

