/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.jute;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.TreeMap;
import oadd.org.apache.jute.OutputArchive;
import oadd.org.apache.jute.Record;
import oadd.org.apache.jute.Utils;

public class CsvOutputArchive
implements OutputArchive {
    private PrintStream stream;
    private boolean isFirst = true;

    static CsvOutputArchive getArchive(OutputStream strm) throws UnsupportedEncodingException {
        return new CsvOutputArchive(strm);
    }

    private void throwExceptionOnError(String tag) throws IOException {
        if (this.stream.checkError()) {
            throw new IOException("Error serializing " + tag);
        }
    }

    private void printCommaUnlessFirst() {
        if (!this.isFirst) {
            this.stream.print(",");
        }
        this.isFirst = false;
    }

    public CsvOutputArchive(OutputStream out) throws UnsupportedEncodingException {
        this.stream = new PrintStream(out, true, "UTF-8");
    }

    public void writeByte(byte b, String tag) throws IOException {
        this.writeLong(b, tag);
    }

    public void writeBool(boolean b, String tag) throws IOException {
        this.printCommaUnlessFirst();
        String val = b ? "T" : "F";
        this.stream.print(val);
        this.throwExceptionOnError(tag);
    }

    public void writeInt(int i, String tag) throws IOException {
        this.writeLong(i, tag);
    }

    public void writeLong(long l, String tag) throws IOException {
        this.printCommaUnlessFirst();
        this.stream.print(l);
        this.throwExceptionOnError(tag);
    }

    public void writeFloat(float f, String tag) throws IOException {
        this.writeDouble(f, tag);
    }

    public void writeDouble(double d, String tag) throws IOException {
        this.printCommaUnlessFirst();
        this.stream.print(d);
        this.throwExceptionOnError(tag);
    }

    public void writeString(String s, String tag) throws IOException {
        this.printCommaUnlessFirst();
        this.stream.print(Utils.toCSVString(s));
        this.throwExceptionOnError(tag);
    }

    public void writeBuffer(byte[] buf, String tag) throws IOException {
        this.printCommaUnlessFirst();
        this.stream.print(Utils.toCSVBuffer(buf));
        this.throwExceptionOnError(tag);
    }

    public void writeRecord(Record r, String tag) throws IOException {
        if (r == null) {
            return;
        }
        r.serialize(this, tag);
    }

    public void startRecord(Record r, String tag) throws IOException {
        if (tag != null && !"".equals(tag)) {
            this.printCommaUnlessFirst();
            this.stream.print("s{");
            this.isFirst = true;
        }
    }

    public void endRecord(Record r, String tag) throws IOException {
        if (tag == null || "".equals(tag)) {
            this.stream.print("\n");
            this.isFirst = true;
        } else {
            this.stream.print("}");
            this.isFirst = false;
        }
    }

    public void startVector(List v, String tag) throws IOException {
        this.printCommaUnlessFirst();
        this.stream.print("v{");
        this.isFirst = true;
    }

    public void endVector(List v, String tag) throws IOException {
        this.stream.print("}");
        this.isFirst = false;
    }

    public void startMap(TreeMap v, String tag) throws IOException {
        this.printCommaUnlessFirst();
        this.stream.print("m{");
        this.isFirst = true;
    }

    public void endMap(TreeMap v, String tag) throws IOException {
        this.stream.print("}");
        this.isFirst = false;
    }
}

