/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.metrics2.util;

import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class MBeans {
    private static final Log LOG = LogFactory.getLog(MBeans.class);

    public static ObjectName register(String serviceName, String nameName, Object theMbean) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName name = MBeans.getMBeanName(serviceName, nameName);
        try {
            mbs.registerMBean(theMbean, name);
            LOG.debug("Registered " + name);
            return name;
        }
        catch (InstanceAlreadyExistsException iaee) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Failed to register MBean \"" + name + "\"", iaee);
            } else {
                LOG.warn("Failed to register MBean \"" + name + "\": Instance already exists.");
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to register MBean \"" + name + "\"", e);
        }
        return null;
    }

    public static void unregister(ObjectName mbeanName) {
        LOG.debug("Unregistering " + mbeanName);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        if (mbeanName == null) {
            LOG.debug("Stacktrace: ", new Throwable());
            return;
        }
        try {
            mbs.unregisterMBean(mbeanName);
        }
        catch (Exception e) {
            LOG.warn("Error unregistering " + mbeanName, e);
        }
        DefaultMetricsSystem.removeMBeanName(mbeanName);
    }

    private static ObjectName getMBeanName(String serviceName, String nameName) {
        ObjectName name = null;
        String nameStr = "Hadoop:service=" + serviceName + ",name=" + nameName;
        try {
            name = DefaultMetricsSystem.newMBeanName(nameStr);
        }
        catch (Exception e) {
            LOG.warn("Error creating MBean object name: " + nameStr, e);
        }
        return name;
    }
}

