/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.io.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.conf.Configurable;
import oadd.org.apache.hadoop.conf.Configuration;
import oadd.org.apache.hadoop.io.compress.CompressionCodec;
import oadd.org.apache.hadoop.io.compress.CompressionInputStream;
import oadd.org.apache.hadoop.io.compress.CompressionOutputStream;
import oadd.org.apache.hadoop.io.compress.Compressor;
import oadd.org.apache.hadoop.io.compress.CompressorStream;
import oadd.org.apache.hadoop.io.compress.Decompressor;
import oadd.org.apache.hadoop.io.compress.DecompressorStream;
import oadd.org.apache.hadoop.io.compress.DirectDecompressionCodec;
import oadd.org.apache.hadoop.io.compress.DirectDecompressor;
import oadd.org.apache.hadoop.io.compress.zlib.ZlibFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class DefaultCodec
implements Configurable,
CompressionCodec,
DirectDecompressionCodec {
    private static final Log LOG = LogFactory.getLog(DefaultCodec.class);
    Configuration conf;

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return CompressionCodec.Util.createOutputStreamWithCodecPool(this, this.conf, out);
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        return new CompressorStream(out, compressor, this.conf.getInt("oadd.io.file.buffer.size", 4096));
    }

    @Override
    public Class<? extends Compressor> getCompressorType() {
        return ZlibFactory.getZlibCompressorType(this.conf);
    }

    @Override
    public Compressor createCompressor() {
        return ZlibFactory.getZlibCompressor(this.conf);
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return CompressionCodec.Util.createInputStreamWithCodecPool(this, this.conf, in);
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        return new DecompressorStream(in, decompressor, this.conf.getInt("oadd.io.file.buffer.size", 4096));
    }

    @Override
    public Class<? extends Decompressor> getDecompressorType() {
        return ZlibFactory.getZlibDecompressorType(this.conf);
    }

    @Override
    public Decompressor createDecompressor() {
        return ZlibFactory.getZlibDecompressor(this.conf);
    }

    @Override
    public DirectDecompressor createDirectDecompressor() {
        return ZlibFactory.getZlibDirectDecompressor(this.conf);
    }

    @Override
    public String getDefaultExtension() {
        return ".deflate";
    }
}

