/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.expr.holders.RepeatedListHolder;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedListVector;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import oadd.org.apache.drill.exec.vector.complex.impl.NullReader;
import oadd.org.apache.drill.exec.vector.complex.impl.RepeatedListWriter;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;

public class RepeatedListReaderImpl
extends AbstractFieldReader {
    private static final int NO_VALUES = 0x7FFFFFFE;
    private static final TypeProtos.MajorType TYPE = Types.repeated(TypeProtos.MinorType.LIST);
    private final String name;
    private final RepeatedListVector container;
    private FieldReader reader;
    private int currentOffset;
    private int maxOffset;

    public RepeatedListReaderImpl(String name, RepeatedListVector container) {
        this.name = name;
        this.container = container;
    }

    @Override
    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    @Override
    public void copyAsValue(BaseWriter.ListWriter writer) {
        if (this.currentOffset == 0x7FFFFFFE) {
            return;
        }
        RepeatedListWriter impl = (RepeatedListWriter)writer;
        impl.container.copyFromSafe(this.idx(), impl.idx(), this.container);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        if (this.currentOffset == 0x7FFFFFFE) {
            return;
        }
        RepeatedListWriter impl = (RepeatedListWriter)writer.list(name);
        impl.container.copyFromSafe(this.idx(), impl.idx(), this.container);
    }

    @Override
    public void reset() {
        super.reset();
        this.currentOffset = 0;
        this.maxOffset = 0;
        if (this.reader != null) {
            this.reader.reset();
        }
        this.reader = null;
    }

    @Override
    public int size() {
        return this.maxOffset - this.currentOffset;
    }

    @Override
    public void setPosition(int index) {
        if (index < 0 || index == 0x7FFFFFFE) {
            this.currentOffset = 0x7FFFFFFE;
            return;
        }
        super.setPosition(index);
        RepeatedListHolder h = new RepeatedListHolder();
        this.container.getAccessor().get(index, h);
        if (h.start == h.end) {
            this.currentOffset = 0x7FFFFFFE;
        } else {
            this.currentOffset = h.start - 1;
            this.maxOffset = h.end;
            if (this.reader != null) {
                this.reader.setPosition(this.currentOffset);
            }
        }
    }

    @Override
    public boolean next() {
        if (this.currentOffset + 1 < this.maxOffset) {
            ++this.currentOffset;
            if (this.reader != null) {
                this.reader.setPosition(this.currentOffset);
            }
            return true;
        }
        this.currentOffset = 0x7FFFFFFE;
        return false;
    }

    @Override
    public Object readObject() {
        return this.container.getAccessor().getObject(this.idx());
    }

    @Override
    public FieldReader reader() {
        if (this.reader == null) {
            ValueVector child = this.container.getChild(this.name);
            this.reader = child == null ? NullReader.INSTANCE : child.getReader();
            this.reader.setPosition(this.currentOffset);
        }
        return this.reader;
    }

    @Override
    public boolean isSet() {
        return true;
    }
}

