/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.holders.IntervalHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableIntervalHolder;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import oadd.org.joda.time.Period;

public class NullableIntervalHolderReaderImpl
extends AbstractFieldReader {
    private NullableIntervalHolder holder;

    public NullableIntervalHolderReaderImpl(NullableIntervalHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return NullableIntervalHolder.TYPE;
    }

    @Override
    public boolean isSet() {
        return this.holder.isSet == 1;
    }

    @Override
    public void read(IntervalHolder h) {
        h.months = this.holder.months;
        h.days = this.holder.days;
        h.milliseconds = this.holder.milliseconds;
    }

    @Override
    public void read(NullableIntervalHolder h) {
        h.months = this.holder.months;
        h.days = this.holder.days;
        h.milliseconds = this.holder.milliseconds;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public Period readPeriod() {
        if (!this.isSet()) {
            return null;
        }
        Period p = new Period();
        return p.plusMonths(this.holder.months).plusDays(this.holder.days).plusMillis(this.holder.milliseconds);
    }

    @Override
    public Object readObject() {
        return this.readSingleObject();
    }

    private Object readSingleObject() {
        if (!this.isSet()) {
            return null;
        }
        Period p = new Period();
        return p.plusMonths(this.holder.months).plusDays(this.holder.days).plusMillis(this.holder.milliseconds);
    }
}

