/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.impl;

import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.vector.accessor.ColumnAccessors;
import oadd.org.apache.drill.exec.vector.accessor.impl.AbstractArrayReader;
import oadd.org.apache.drill.exec.vector.accessor.impl.AbstractArrayWriter;
import oadd.org.apache.drill.exec.vector.accessor.impl.AbstractColumnReader;
import oadd.org.apache.drill.exec.vector.accessor.impl.AbstractColumnWriter;

public class ColumnAccessorFactory {
    private static Class<? extends AbstractColumnWriter>[][] columnWriters = ColumnAccessorFactory.buildColumnWriters();
    private static Class<? extends AbstractColumnReader>[][] columnReaders = ColumnAccessorFactory.buildColumnReaders();
    private static Class<? extends AbstractArrayWriter>[] arrayWriters = ColumnAccessorFactory.buildArrayWriters();
    private static Class<? extends AbstractArrayReader>[] arrayReaders = ColumnAccessorFactory.buildArrayReaders();

    private static Class<? extends AbstractColumnWriter>[][] buildColumnWriters() {
        int typeCount = TypeProtos.MinorType.values().length;
        int modeCount = TypeProtos.DataMode.values().length;
        Class[][] writers = new Class[typeCount][];
        for (int i = 0; i < typeCount; ++i) {
            writers[i] = new Class[modeCount];
        }
        ColumnAccessors.defineWriters(writers);
        return writers;
    }

    private static Class<? extends AbstractColumnReader>[][] buildColumnReaders() {
        int typeCount = TypeProtos.MinorType.values().length;
        int modeCount = TypeProtos.DataMode.values().length;
        Class[][] readers = new Class[typeCount][];
        for (int i = 0; i < typeCount; ++i) {
            readers[i] = new Class[modeCount];
        }
        ColumnAccessors.defineReaders(readers);
        return readers;
    }

    private static Class<? extends AbstractArrayWriter>[] buildArrayWriters() {
        int typeCount = TypeProtos.MinorType.values().length;
        Class[] writers = new Class[typeCount];
        ColumnAccessors.defineArrayWriters(writers);
        return writers;
    }

    private static Class<? extends AbstractArrayReader>[] buildArrayReaders() {
        int typeCount = TypeProtos.MinorType.values().length;
        Class[] readers = new Class[typeCount];
        ColumnAccessors.defineArrayReaders(readers);
        return readers;
    }

    public static AbstractColumnWriter newWriter(TypeProtos.MajorType type) {
        try {
            if (type.getMode() == TypeProtos.DataMode.REPEATED) {
                Class<? extends AbstractArrayWriter> writerClass = arrayWriters[type.getMinorType().ordinal()];
                if (writerClass == null) {
                    throw new UnsupportedOperationException();
                }
                return new AbstractArrayWriter.ArrayColumnWriter(writerClass.newInstance());
            }
            Class<? extends AbstractColumnWriter> writerClass = columnWriters[type.getMinorType().ordinal()][type.getMode().ordinal()];
            if (writerClass == null) {
                throw new UnsupportedOperationException();
            }
            return writerClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }

    public static AbstractColumnReader newReader(TypeProtos.MajorType type) {
        try {
            if (type.getMode() == TypeProtos.DataMode.REPEATED) {
                Class<? extends AbstractArrayReader> readerClass = arrayReaders[type.getMinorType().ordinal()];
                if (readerClass == null) {
                    throw new UnsupportedOperationException();
                }
                return new AbstractArrayReader.ArrayColumnReader(readerClass.newInstance());
            }
            Class<? extends AbstractColumnReader> readerClass = columnReaders[type.getMinorType().ordinal()][type.getMode().ordinal()];
            if (readerClass == null) {
                throw new UnsupportedOperationException();
            }
            return readerClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }
}

