/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor;

import java.io.InputStream;
import oadd.io.netty.buffer.ByteBufInputStream;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.common.util.DrillStringUtils;
import oadd.org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import oadd.org.apache.drill.exec.vector.NullableVarBinaryVector;
import oadd.org.apache.drill.exec.vector.accessor.AbstractSqlAccessor;

public class NullableVarBinaryAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.optional(TypeProtos.MinorType.VARBINARY);
    private final NullableVarBinaryVector.Accessor ac;

    public NullableVarBinaryAccessor(NullableVarBinaryVector vector) {
        this.ac = vector.getAccessor();
    }

    @Override
    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    @Override
    public boolean isNull(int index) {
        return this.ac.isNull(index);
    }

    @Override
    public Class<?> getObjectClass() {
        return byte[].class;
    }

    @Override
    public Object getObject(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return this.ac.getObject(index);
    }

    @Override
    public InputStream getStream(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        NullableVarBinaryHolder h = new NullableVarBinaryHolder();
        this.ac.get(index, h);
        return new ByteBufInputStream(h.buffer.slice(h.start, h.end));
    }

    @Override
    public byte[] getBytes(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return this.ac.get(index);
    }

    @Override
    public String getString(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        byte[] b = this.ac.get(index);
        return DrillStringUtils.toBinaryString(b);
    }
}

