/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor;

import java.math.BigDecimal;
import oadd.org.apache.drill.exec.vector.accessor.ArrayWriter;
import oadd.org.apache.drill.exec.vector.accessor.ColumnWriter;
import oadd.org.joda.time.Duration;
import oadd.org.joda.time.Period;

public class AccessorUtilities {
    private AccessorUtilities() {
    }

    public static void setFromInt(ColumnWriter writer, int value) {
        switch (writer.valueType()) {
            case BYTES: {
                writer.setBytes(Integer.toHexString(value).getBytes());
                break;
            }
            case DOUBLE: {
                writer.setDouble(value);
                break;
            }
            case INTEGER: {
                writer.setInt(value);
                break;
            }
            case LONG: {
                writer.setLong(value);
                break;
            }
            case STRING: {
                writer.setString(Integer.toString(value));
                break;
            }
            case DECIMAL: {
                writer.setDecimal(BigDecimal.valueOf(value));
                break;
            }
            case PERIOD: {
                writer.setPeriod(Duration.millis(value).toPeriod());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown writer type: " + (Object)((Object)writer.valueType()));
            }
        }
    }

    public static int sv4Batch(int sv4Index) {
        return sv4Index >>> 16;
    }

    public static int sv4Index(int sv4Index) {
        return sv4Index & 0xFFFF;
    }

    public static void setBooleanArray(ArrayWriter arrayWriter, boolean[] value) {
        for (int i = 0; i < value.length; ++i) {
            arrayWriter.setInt(value[i] ? 1 : 0);
        }
    }

    public static void setByteArray(ArrayWriter arrayWriter, byte[] value) {
        for (int i = 0; i < value.length; ++i) {
            arrayWriter.setInt(value[i]);
        }
    }

    public static void setShortArray(ArrayWriter arrayWriter, short[] value) {
        for (int i = 0; i < value.length; ++i) {
            arrayWriter.setInt(value[i]);
        }
    }

    public static void setIntArray(ArrayWriter arrayWriter, int[] value) {
        for (int i = 0; i < value.length; ++i) {
            arrayWriter.setInt(value[i]);
        }
    }

    public static void setLongArray(ArrayWriter arrayWriter, long[] value) {
        for (int i = 0; i < value.length; ++i) {
            arrayWriter.setLong(value[i]);
        }
    }

    public static void setFloatArray(ArrayWriter arrayWriter, float[] value) {
        for (int i = 0; i < value.length; ++i) {
            arrayWriter.setDouble(value[i]);
        }
    }

    public static void setDoubleArray(ArrayWriter arrayWriter, double[] value) {
        for (int i = 0; i < value.length; ++i) {
            arrayWriter.setDouble(value[i]);
        }
    }

    public static void setStringArray(ArrayWriter arrayWriter, String[] value) {
        for (int i = 0; i < value.length; ++i) {
            arrayWriter.setString(value[i]);
        }
    }

    public static void setPeriodArray(ArrayWriter arrayWriter, Period[] value) {
        for (int i = 0; i < value.length; ++i) {
            arrayWriter.setPeriod(value[i]);
        }
    }

    public static void setBigDecimalArray(ArrayWriter arrayWriter, BigDecimal[] value) {
        for (int i = 0; i < value.length; ++i) {
            arrayWriter.setDecimal(value[i]);
        }
    }
}

