/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.util.List;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import oadd.org.apache.drill.exec.expr.holders.RepeatedVarCharHolder;
import oadd.org.apache.drill.exec.expr.holders.VarCharHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.util.JsonStringArrayList;
import oadd.org.apache.drill.exec.util.Text;
import oadd.org.apache.drill.exec.vector.AddOrGetResult;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VarCharVector;
import oadd.org.apache.drill.exec.vector.VectorDescriptor;
import oadd.org.apache.drill.exec.vector.VectorOverflowException;
import oadd.org.apache.drill.exec.vector.complex.BaseRepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedVariableWidthVectorLike;
import oadd.org.apache.drill.exec.vector.complex.impl.RepeatedVarCharReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class RepeatedVarCharVector
extends BaseRepeatedValueVector
implements RepeatedVariableWidthVectorLike {
    private VarCharVector values;
    private final FieldReader reader = new RepeatedVarCharReaderImpl(this);
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public RepeatedVarCharVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        this.addOrGetVector(VectorDescriptor.create(Types.required(field.getType().getMinorType())));
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public VarCharVector getDataVector() {
        return this.values;
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((RepeatedVarCharVector)to);
    }

    public AddOrGetResult<VarCharVector> addOrGetVector(VectorDescriptor descriptor) {
        AddOrGetResult<VarCharVector> result = super.addOrGetVector(descriptor);
        if (result.isCreated()) {
            this.values = result.getVector();
        }
        return result;
    }

    public void transferTo(RepeatedVarCharVector target) {
        target.clear();
        this.offsets.transferTo(target.offsets);
        this.values.transferTo(target.values);
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int groups, RepeatedVarCharVector to) {
        UInt4Vector.Accessor a = this.offsets.getAccessor();
        UInt4Vector.Mutator m = to.offsets.getMutator();
        int startPos = a.get(startIndex);
        int endPos = a.get(startIndex + groups);
        int valuesToCopy = endPos - startPos;
        this.values.splitAndTransferTo(startPos, valuesToCopy, to.values);
        to.offsets.clear();
        to.offsets.allocateNew(groups + 1);
        int normalizedPos = 0;
        for (int i = 0; i < groups + 1; ++i) {
            normalizedPos = a.get(startIndex + i) - startPos;
            m.set(i, normalizedPos);
        }
        m.setValueCount(groups == 0 ? 0 : groups + 1);
    }

    public void copyFrom(int inIndex, int outIndex, RepeatedVarCharVector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.add(outIndex, vAccessor.get(inIndex, i));
        }
    }

    public void copyFromSafe(int inIndex, int outIndex, RepeatedVarCharVector v) {
        Accessor vAccessor = v.getAccessor();
        int count = vAccessor.getInnerValueCountAt(inIndex);
        this.mutator.startNewValue(outIndex);
        for (int i = 0; i < count; ++i) {
            this.mutator.addSafe(outIndex, vAccessor.get(inIndex, i));
        }
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        this.copyFromSafe(fromIndex, toIndex, (RepeatedVarCharVector)from);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            if (!this.offsets.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            if (!this.values.allocateNewSafe()) {
                boolean bl = false;
                return bl;
            }
            success = true;
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.offsets.zeroVector();
        this.mutator.reset();
        return true;
    }

    @Override
    public void allocateNew() {
        try {
            this.offsets.allocateNew();
            this.values.allocateNew();
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    @Override
    protected UserBitShared.SerializedField.Builder getMetadataBuilder() {
        return super.getMetadataBuilder().setVarByteLength(this.values.getVarByteLength());
    }

    @Override
    public void allocateNew(int totalBytes, int valueCount, int innerValueCount) {
        try {
            this.offsets.allocateNew(valueCount + 1);
            this.values.allocateNew(totalBytes, innerValueCount);
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.offsets.zeroVector();
        this.mutator.reset();
    }

    @Override
    public int getByteCapacity() {
        return this.values.getByteCapacity();
    }

    public final class Mutator
    extends BaseRepeatedValueVector.BaseRepeatedMutator
    implements RepeatedValueVector.RepeatedMutator {
        private Mutator() {
        }

        public void add(int index, byte[] value) {
            int nextOffset = RepeatedVarCharVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVarCharVector.this.values.getMutator().set(nextOffset, value);
            RepeatedVarCharVector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, byte[] bytes) {
            this.addSafe(index, bytes, 0, bytes.length);
        }

        public void addEntry(int index, byte[] bytes) throws VectorOverflowException {
            this.addEntry(index, bytes, 0, bytes.length);
        }

        public void addSafe(int index, byte[] bytes, int start, int length) {
            int nextOffset = RepeatedVarCharVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVarCharVector.this.values.getMutator().setSafe(nextOffset, bytes, start, length);
            RepeatedVarCharVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addEntry(int index, byte[] bytes, int start, int length) throws VectorOverflowException {
            if (index >= 65536) {
                throw new VectorOverflowException();
            }
            int nextOffset = RepeatedVarCharVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVarCharVector.this.values.getMutator().setArrayItem(nextOffset, bytes, start, length);
            RepeatedVarCharVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void setSafe(int index, RepeatedVarCharHolder h) {
            VarCharHolder ih = new VarCharHolder();
            VarCharVector.Accessor hVectorAccessor = h.vector.getAccessor();
            RepeatedVarCharVector.this.mutator.startNewValue(index);
            for (int i = h.start; i < h.end; ++i) {
                hVectorAccessor.get(i, ih);
                RepeatedVarCharVector.this.mutator.addSafe(index, ih);
            }
        }

        public void addSafe(int index, VarCharHolder holder) {
            int nextOffset = RepeatedVarCharVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVarCharVector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedVarCharVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addEntry(int index, VarCharHolder holder) throws VectorOverflowException {
            if (index >= 65536) {
                throw new VectorOverflowException();
            }
            int nextOffset = RepeatedVarCharVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVarCharVector.this.values.getMutator().setArrayItem(nextOffset, holder);
            RepeatedVarCharVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addSafe(int index, NullableVarCharHolder holder) {
            int nextOffset = RepeatedVarCharVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVarCharVector.this.values.getMutator().setSafe(nextOffset, holder);
            RepeatedVarCharVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void addEntry(int index, NullableVarCharHolder holder) throws VectorOverflowException {
            if (index >= 65536) {
                throw new VectorOverflowException();
            }
            int nextOffset = RepeatedVarCharVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVarCharVector.this.values.getMutator().setArrayItem(nextOffset, holder);
            RepeatedVarCharVector.this.offsets.getMutator().setSafe(index + 1, nextOffset + 1);
        }

        public void fillEmptiesBounded(int lastWrite, int index) throws VectorOverflowException {
            if (index >= 65536) {
                throw new VectorOverflowException();
            }
            int fillOffset = RepeatedVarCharVector.this.offsets.getAccessor().get(lastWrite + 1);
            UInt4Vector.Mutator offsetMutator = RepeatedVarCharVector.this.offsets.getMutator();
            for (int i = lastWrite; i < index; ++i) {
                offsetMutator.setSafe(i + 1, fillOffset);
            }
        }

        public void addSafe(int rowIndex, int start, int end, DrillBuf buffer) {
            int nextOffset = RepeatedVarCharVector.this.offsets.getAccessor().get(rowIndex + 1);
            RepeatedVarCharVector.this.values.getMutator().setSafe(nextOffset, start, end, buffer);
            RepeatedVarCharVector.this.offsets.getMutator().setSafe(rowIndex + 1, nextOffset + 1);
        }

        public void addEntry(int rowIndex, int start, int end, DrillBuf buffer) throws VectorOverflowException {
            if (rowIndex >= 65536) {
                throw new VectorOverflowException();
            }
            int nextOffset = RepeatedVarCharVector.this.offsets.getAccessor().get(rowIndex + 1);
            RepeatedVarCharVector.this.values.getMutator().setArrayItem(nextOffset, start, end, buffer);
            RepeatedVarCharVector.this.offsets.getMutator().setSafe(rowIndex + 1, nextOffset + 1);
        }

        protected void add(int index, VarCharHolder holder) {
            int nextOffset = RepeatedVarCharVector.this.offsets.getAccessor().get(index + 1);
            RepeatedVarCharVector.this.values.getMutator().set(nextOffset, holder);
            RepeatedVarCharVector.this.offsets.getMutator().set(index + 1, nextOffset + 1);
        }

        public void add(int index, RepeatedVarCharHolder holder) {
            VarCharVector.Accessor accessor = holder.vector.getAccessor();
            VarCharHolder innerHolder = new VarCharHolder();
            for (int i = holder.start; i < holder.end; ++i) {
                accessor.get(i, innerHolder);
                this.add(index, innerHolder);
            }
        }

        @Override
        public void generateTestData(int valCount) {
            int[] sizes = new int[]{1, 2, 0, 6};
            int size = 0;
            int runningOffset = 0;
            UInt4Vector.Mutator offsetsMutator = RepeatedVarCharVector.this.offsets.getMutator();
            int i = 1;
            while (i < valCount + 1) {
                offsetsMutator.set(i, runningOffset += sizes[size % sizes.length]);
                ++i;
                ++size;
            }
            RepeatedVarCharVector.this.values.getMutator().generateTestData(valCount * 9);
            this.setValueCount(size);
        }

        @Override
        public void reset() {
        }
    }

    public final class Accessor
    extends BaseRepeatedValueVector.BaseRepeatedAccessor {
        @Override
        public List<Text> getObject(int index) {
            JsonStringArrayList<Text> vals = new JsonStringArrayList<Text>();
            UInt4Vector.Accessor offsetsAccessor = RepeatedVarCharVector.this.offsets.getAccessor();
            int start = offsetsAccessor.get(index);
            int end = offsetsAccessor.get(index + 1);
            VarCharVector.Accessor valuesAccessor = RepeatedVarCharVector.this.values.getAccessor();
            for (int i = start; i < end; ++i) {
                vals.add(valuesAccessor.getObject(i));
            }
            return vals;
        }

        public Text getSingleObject(int index, int arrayIndex) {
            int start = RepeatedVarCharVector.this.offsets.getAccessor().get(index);
            return RepeatedVarCharVector.this.values.getAccessor().getObject(start + arrayIndex);
        }

        public byte[] get(int index, int positionIndex) {
            return RepeatedVarCharVector.this.values.getAccessor().get(RepeatedVarCharVector.this.offsets.getAccessor().get(index) + positionIndex);
        }

        public void get(int index, RepeatedVarCharHolder holder) {
            holder.start = RepeatedVarCharVector.this.offsets.getAccessor().get(index);
            holder.end = RepeatedVarCharVector.this.offsets.getAccessor().get(index + 1);
            holder.vector = RepeatedVarCharVector.this.values;
        }

        public void get(int index, int positionIndex, VarCharHolder holder) {
            int offset = RepeatedVarCharVector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            assert (positionIndex < this.getInnerValueCountAt(index));
            RepeatedVarCharVector.this.values.getAccessor().get(offset + positionIndex, holder);
        }

        public void get(int index, int positionIndex, NullableVarCharHolder holder) {
            int offset = RepeatedVarCharVector.this.offsets.getAccessor().get(index);
            assert (offset >= 0);
            if (positionIndex >= this.getInnerValueCountAt(index)) {
                holder.isSet = 0;
                return;
            }
            RepeatedVarCharVector.this.values.getAccessor().get(offset + positionIndex, holder);
        }
    }

    private class TransferImpl
    implements TransferPair {
        final RepeatedVarCharVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new RepeatedVarCharVector(field, allocator);
        }

        public TransferImpl(RepeatedVarCharVector to) {
            this.to = to;
        }

        @Override
        public RepeatedVarCharVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            RepeatedVarCharVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            RepeatedVarCharVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, RepeatedVarCharVector.this);
        }
    }
}

