/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.util.Set;
import oadd.com.google.common.collect.ObjectArrays;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.expr.holders.NullableTinyIntHolder;
import oadd.org.apache.drill.exec.expr.holders.TinyIntHolder;
import oadd.org.apache.drill.exec.memory.AllocationManager;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.BaseValueVector;
import oadd.org.apache.drill.exec.vector.FixedWidthVector;
import oadd.org.apache.drill.exec.vector.NullableVector;
import oadd.org.apache.drill.exec.vector.NullableVectorDefinitionSetter;
import oadd.org.apache.drill.exec.vector.TinyIntVector;
import oadd.org.apache.drill.exec.vector.UInt1Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorOverflowException;
import oadd.org.apache.drill.exec.vector.complex.impl.NullableTinyIntReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NullableTinyIntVector
extends BaseDataValueVector
implements FixedWidthVector,
NullableVector {
    private static final Logger logger = LoggerFactory.getLogger(NullableTinyIntVector.class);
    private final FieldReader reader = new NullableTinyIntReaderImpl(this);
    private final MaterializedField bitsField = MaterializedField.create("$bits$", Types.required(TypeProtos.MinorType.UINT1));
    private final UInt1Vector bits = new UInt1Vector(this.bitsField, this.allocator);
    private final TinyIntVector values = new TinyIntVector(this.field, this.allocator);
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public NullableTinyIntVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public int getValueCapacity() {
        return Math.min(this.bits.getValueCapacity(), this.values.getValueCapacity());
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] buffers = ObjectArrays.concat(this.bits.getBuffers(false), this.values.getBuffers(false), DrillBuf.class);
        if (clear) {
            for (DrillBuf buffer : buffers) {
                buffer.retain(1);
            }
            this.clear();
        }
        return buffers;
    }

    @Override
    public void close() {
        this.bits.close();
        this.values.close();
        super.close();
    }

    @Override
    public void clear() {
        this.bits.clear();
        this.values.clear();
        super.clear();
    }

    @Override
    public int getBufferSize() {
        return this.values.getBufferSize() + this.bits.getBufferSize();
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return this.values.getBufferSizeFor(valueCount) + this.bits.getBufferSizeFor(valueCount);
    }

    @Override
    public DrillBuf getBuffer() {
        return this.values.getBuffer();
    }

    @Override
    public TinyIntVector getValuesVector() {
        return this.values;
    }

    @Override
    public UInt1Vector getBitsVector() {
        return this.bits;
    }

    @Override
    public void setInitialCapacity(int numRecords) {
        this.bits.setInitialCapacity(numRecords);
        this.values.setInitialCapacity(numRecords);
    }

    @Override
    public UserBitShared.SerializedField.Builder getMetadataBuilder() {
        return super.getMetadataBuilder().addChild(this.bits.getMetadata()).addChild(this.values.getMetadata());
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating buffer.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            success = this.values.allocateNewSafe() && this.bits.allocateNewSafe();
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
        return success;
    }

    @Override
    public void collectLedgers(Set<AllocationManager.BufferLedger> ledgers) {
        this.bits.collectLedgers(ledgers);
        this.values.collectLedgers(ledgers);
    }

    @Override
    public int getPayloadByteCount(int valueCount) {
        return this.bits.getPayloadByteCount(valueCount) + this.values.getPayloadByteCount(valueCount);
    }

    @Override
    public void allocateNew(int valueCount) {
        try {
            this.values.allocateNew(valueCount);
            this.bits.allocateNew(valueCount);
        }
        catch (OutOfMemoryException e) {
            this.clear();
            throw e;
        }
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
    }

    @Override
    public void reset() {
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
        super.reset();
    }

    @Override
    public void zeroVector() {
        this.bits.zeroVector();
        this.values.zeroVector();
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        this.clear();
        UserBitShared.SerializedField bitsField = metadata.getChild(0);
        this.bits.load(bitsField, buffer);
        int capacity = buffer.capacity();
        int bitsLength = bitsField.getBufferLength();
        UserBitShared.SerializedField valuesField = metadata.getChild(1);
        this.values.load(valuesField, buffer.slice(bitsLength, capacity - bitsLength));
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((NullableTinyIntVector)to);
    }

    public void transferTo(NullableTinyIntVector target) {
        this.bits.transferTo(target.bits);
        this.values.transferTo(target.values);
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, NullableTinyIntVector target) {
        this.bits.splitAndTransferTo(startIndex, length, target.bits);
        this.values.splitAndTransferTo(startIndex, length, target.values);
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    public TinyIntVector convertToRequiredVector() {
        TinyIntVector v = new TinyIntVector(this.getField().getOtherNullableVersion(), this.allocator);
        if (v.data != null) {
            v.data.release(1);
        }
        v.data = this.values.data;
        v.data.retain(1);
        this.clear();
        return v;
    }

    public void copyFrom(int fromIndex, int thisIndex, NullableTinyIntVector from) {
        Accessor fromAccessor = from.getAccessor();
        if (!fromAccessor.isNull(fromIndex)) {
            this.mutator.set(thisIndex, fromAccessor.get(fromIndex));
        }
    }

    public void copyFromSafe(int fromIndex, int thisIndex, TinyIntVector from) {
        this.values.copyFromSafe(fromIndex, thisIndex, from);
        this.bits.getMutator().setSafe(thisIndex, 1);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, NullableTinyIntVector from) {
        this.bits.copyFromSafe(fromIndex, thisIndex, from.bits);
        this.values.copyFromSafe(fromIndex, thisIndex, from.values);
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        NullableTinyIntVector fromVector = (NullableTinyIntVector)from;
        this.bits.copyFromSafe(fromIndex, toIndex, fromVector.bits);
        this.values.copyFromSafe(fromIndex, toIndex, fromVector.values);
    }

    @Override
    public void exchange(ValueVector other) {
        NullableTinyIntVector target = (NullableTinyIntVector)other;
        this.bits.exchange(target.bits);
        this.values.exchange(target.values);
        this.mutator.exchange(other.getMutator());
    }

    @Override
    public void toNullable(ValueVector nullableVector) {
        this.exchange(nullableVector);
        this.clear();
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator
    implements NullableVectorDefinitionSetter {
        private int setCount;

        private Mutator() {
        }

        public TinyIntVector getVectorWithValues() {
            return NullableTinyIntVector.this.values;
        }

        @Override
        public void setIndexDefined(int index) {
            NullableTinyIntVector.this.bits.getMutator().set(index, 1);
        }

        public void set(int index, int value) {
            ++this.setCount;
            TinyIntVector.Mutator valuesMutator = NullableTinyIntVector.this.values.getMutator();
            UInt1Vector.Mutator bitsMutator = NullableTinyIntVector.this.bits.getMutator();
            bitsMutator.set(index, 1);
            valuesMutator.set(index, value);
        }

        public void setNull(int index) {
            NullableTinyIntVector.this.bits.getMutator().setSafe(index, 0);
        }

        public void setSkipNull(int index, TinyIntHolder holder) {
            NullableTinyIntVector.this.values.getMutator().set(index, holder);
        }

        public void setSkipNull(int index, NullableTinyIntHolder holder) {
            NullableTinyIntVector.this.values.getMutator().set(index, holder);
        }

        public void setNullBounded(int index) throws VectorOverflowException {
            NullableTinyIntVector.this.bits.getMutator().setScalar(index, 0);
        }

        public void set(int index, NullableTinyIntHolder holder) {
            TinyIntVector.Mutator valuesMutator = NullableTinyIntVector.this.values.getMutator();
            NullableTinyIntVector.this.bits.getMutator().set(index, holder.isSet);
            valuesMutator.set(index, holder);
        }

        public void set(int index, TinyIntHolder holder) {
            TinyIntVector.Mutator valuesMutator = NullableTinyIntVector.this.values.getMutator();
            NullableTinyIntVector.this.bits.getMutator().set(index, 1);
            valuesMutator.set(index, holder);
        }

        public boolean isSafe(int outIndex) {
            return outIndex < NullableTinyIntVector.this.getValueCapacity();
        }

        public void set(int index, int isSet, byte valueField) {
            TinyIntVector.Mutator valuesMutator = NullableTinyIntVector.this.values.getMutator();
            NullableTinyIntVector.this.bits.getMutator().set(index, isSet);
            valuesMutator.set(index, valueField);
        }

        public void setSafe(int index, int isSet, byte valueField) {
            NullableTinyIntVector.this.bits.getMutator().setSafe(index, isSet);
            NullableTinyIntVector.this.values.getMutator().setSafe(index, valueField);
            ++this.setCount;
        }

        public void setScalar(int index, int isSet, byte valueField) throws VectorOverflowException {
            NullableTinyIntVector.this.values.getMutator().setScalar(index, valueField);
            NullableTinyIntVector.this.bits.getMutator().setSafe(index, isSet);
            ++this.setCount;
        }

        public void setSafe(int index, NullableTinyIntHolder value) {
            NullableTinyIntVector.this.bits.getMutator().setSafe(index, value.isSet);
            NullableTinyIntVector.this.values.getMutator().setSafe(index, value);
            ++this.setCount;
        }

        public void setScalar(int index, NullableTinyIntHolder value) throws VectorOverflowException {
            NullableTinyIntVector.this.values.getMutator().setScalar(index, value);
            NullableTinyIntVector.this.bits.getMutator().setSafe(index, value.isSet);
            ++this.setCount;
        }

        public void setSafe(int index, TinyIntHolder value) {
            NullableTinyIntVector.this.bits.getMutator().setSafe(index, 1);
            NullableTinyIntVector.this.values.getMutator().setSafe(index, value);
            ++this.setCount;
        }

        public void setScalar(int index, TinyIntHolder value) throws VectorOverflowException {
            NullableTinyIntVector.this.values.getMutator().setScalar(index, value);
            NullableTinyIntVector.this.bits.getMutator().setSafe(index, 1);
            ++this.setCount;
        }

        public void setSafe(int index, byte value) {
            NullableTinyIntVector.this.bits.getMutator().setSafe(index, 1);
            NullableTinyIntVector.this.values.getMutator().setSafe(index, value);
            ++this.setCount;
        }

        public void setScalar(int index, byte value) throws VectorOverflowException {
            NullableTinyIntVector.this.values.getMutator().setScalar(index, value);
            NullableTinyIntVector.this.bits.getMutator().setSafe(index, 1);
            ++this.setCount;
        }

        @Override
        public void setValueCount(int valueCount) {
            assert (valueCount >= 0);
            NullableTinyIntVector.this.values.getMutator().setValueCount(valueCount);
            NullableTinyIntVector.this.bits.getMutator().setValueCount(valueCount);
        }

        @Override
        public void generateTestData(int valueCount) {
            NullableTinyIntVector.this.bits.getMutator().generateTestDataAlt(valueCount);
            NullableTinyIntVector.this.values.getMutator().generateTestData(valueCount);
            this.setValueCount(valueCount);
        }

        @Override
        public void reset() {
            this.setCount = 0;
        }

        @Override
        public void exchange(ValueVector.Mutator other) {
            Mutator target = (Mutator)other;
            int temp = this.setCount;
            this.setCount = target.setCount;
            target.setCount = temp;
        }

        public void fromNotNullable(TinyIntVector srce) {
            NullableTinyIntVector.this.clear();
            int valueCount = srce.getAccessor().getValueCount();
            BaseValueVector.fillBitsVector(NullableTinyIntVector.this.getBitsVector(), valueCount);
            NullableTinyIntVector.this.getValuesVector().exchange(srce);
            this.setValueCount(valueCount);
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        final UInt1Vector.Accessor bAccessor;
        final TinyIntVector.Accessor vAccessor;

        public Accessor() {
            this.bAccessor = NullableTinyIntVector.this.bits.getAccessor();
            this.vAccessor = NullableTinyIntVector.this.values.getAccessor();
        }

        public byte get(int index) {
            if (this.isNull(index)) {
                throw new IllegalStateException("Can't get a null value");
            }
            return this.vAccessor.get(index);
        }

        @Override
        public boolean isNull(int index) {
            return this.isSet(index) == 0;
        }

        public int isSet(int index) {
            return this.bAccessor.get(index);
        }

        public void get(int index, NullableTinyIntHolder holder) {
            this.vAccessor.get(index, holder);
            holder.isSet = this.bAccessor.get(index);
        }

        @Override
        public Byte getObject(int index) {
            if (this.isNull(index)) {
                return null;
            }
            return this.vAccessor.getObject(index);
        }

        @Override
        public int getValueCount() {
            return NullableTinyIntVector.this.bits.getAccessor().getValueCount();
        }

        public void reset() {
        }
    }

    private class TransferImpl
    implements TransferPair {
        NullableTinyIntVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new NullableTinyIntVector(field, allocator);
        }

        public TransferImpl(NullableTinyIntVector to) {
            this.to = to;
        }

        @Override
        public NullableTinyIntVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            NullableTinyIntVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            NullableTinyIntVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, NullableTinyIntVector.this);
        }
    }
}

