/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.util.Set;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.exec.memory.AllocationManager;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.vector.BaseValueVector;
import oadd.org.apache.drill.exec.vector.ValueVector;

public abstract class BaseDataValueVector
extends BaseValueVector {
    protected static final byte[] emptyByteArray = new byte[0];
    protected DrillBuf data;

    public BaseDataValueVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        this.data = allocator.getEmpty();
    }

    @Override
    public void clear() {
        if (this.data != null) {
            this.data.release();
        }
        this.data = this.allocator.getEmpty();
        super.clear();
    }

    @Override
    public void close() {
        this.clear();
        if (this.data != null) {
            this.data.release();
            this.data = null;
        }
        super.close();
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] out;
        if (this.getBufferSize() == 0) {
            out = new DrillBuf[]{};
        } else {
            out = new DrillBuf[]{this.data};
            this.data.readerIndex(0);
            if (clear) {
                this.data.retain(1);
            }
        }
        if (clear) {
            this.clear();
        }
        return out;
    }

    @Override
    public int getBufferSize() {
        if (this.getAccessor().getValueCount() == 0) {
            return 0;
        }
        return this.data.writerIndex();
    }

    public DrillBuf getBuffer() {
        return this.data;
    }

    public void reset() {
    }

    @Override
    public void exchange(ValueVector other) {
        BaseDataValueVector target = (BaseDataValueVector)other;
        DrillBuf temp = this.data;
        this.data = target.data;
        target.data = temp;
        this.getReader().reset();
        this.getMutator().exchange(target.getMutator());
    }

    @Override
    public void collectLedgers(Set<AllocationManager.BufferLedger> ledgers) {
        AllocationManager.BufferLedger ledger = this.data.getLedger();
        if (ledger != null) {
            ledgers.add(ledger);
        }
    }
}

