/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.testing.store;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import oadd.com.google.common.collect.Iterables;
import oadd.com.google.common.collect.Maps;
import oadd.org.apache.drill.common.concurrent.AutoCloseableLock;
import oadd.org.apache.drill.exec.exception.VersionMismatchException;
import oadd.org.apache.drill.exec.store.sys.BasePersistentStore;
import oadd.org.apache.drill.exec.store.sys.PersistentStoreMode;
import oadd.org.apache.drill.exec.store.sys.store.DataChangeVersion;

public class NoWriteLocalStore<V>
extends BasePersistentStore<V> {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final AutoCloseableLock readLock = new AutoCloseableLock(this.readWriteLock.readLock());
    private final AutoCloseableLock writeLock = new AutoCloseableLock(this.readWriteLock.writeLock());
    private final ConcurrentMap<String, V> store = Maps.newConcurrentMap();
    private int version = -1;

    public void delete(String key) {
        try (AutoCloseableLock lock = this.writeLock.open();){
            this.store.remove(key);
            ++this.version;
        }
    }

    public PersistentStoreMode getMode() {
        return PersistentStoreMode.PERSISTENT;
    }

    public boolean contains(String key) {
        return this.contains(key, null);
    }

    public boolean contains(String key, DataChangeVersion dataChangeVersion) {
        try (AutoCloseableLock lock = this.readLock.open();){
            if (dataChangeVersion != null) {
                dataChangeVersion.setVersion(this.version);
            }
            boolean bl = this.store.containsKey(key);
            return bl;
        }
    }

    public V get(String key) {
        return this.get(key, null);
    }

    public V get(String key, DataChangeVersion dataChangeVersion) {
        try (AutoCloseableLock lock = this.readLock.open();){
            if (dataChangeVersion != null) {
                dataChangeVersion.setVersion(this.version);
            }
            Object v = this.store.get(key);
            return v;
        }
    }

    public void put(String key, V value) {
        this.put(key, value, null);
    }

    public void put(String key, V value, DataChangeVersion dataChangeVersion) {
        try (AutoCloseableLock lock = this.writeLock.open();){
            if (dataChangeVersion != null && dataChangeVersion.getVersion() != this.version) {
                throw new VersionMismatchException("Version mismatch detected", dataChangeVersion.getVersion());
            }
            this.store.put(key, value);
            ++this.version;
        }
    }

    public boolean putIfAbsent(String key, V value) {
        try (AutoCloseableLock lock = this.writeLock.open();){
            V old = this.store.putIfAbsent(key, value);
            if (old == null) {
                ++this.version;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public Iterator<Map.Entry<String, V>> getRange(int skip, int take) {
        try (AutoCloseableLock lock = this.readLock.open();){
            Iterator<Map.Entry<String, V>> iterator = Iterables.limit(Iterables.skip(this.store.entrySet(), skip), take).iterator();
            return iterator;
        }
    }

    public void close() throws Exception {
        try (AutoCloseableLock lock = this.writeLock.open();){
            this.store.clear();
            this.version = -1;
        }
    }
}

