/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.ops;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import oadd.com.google.common.annotations.VisibleForTesting;
import oadd.com.google.common.base.Function;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.collect.Lists;
import oadd.com.google.common.collect.Maps;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.calcite.schema.SchemaPlus;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.exceptions.ExecutionSetupException;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.compile.CodeCompiler;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import oadd.org.apache.drill.exec.expr.holders.ValueHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.ops.AccountingDataTunnel;
import oadd.org.apache.drill.exec.ops.AccountingUserConnection;
import oadd.org.apache.drill.exec.ops.BaseFragmentContext;
import oadd.org.apache.drill.exec.ops.BufferManager;
import oadd.org.apache.drill.exec.ops.BufferManagerImpl;
import oadd.org.apache.drill.exec.ops.Consumer;
import oadd.org.apache.drill.exec.ops.ContextInformation;
import oadd.org.apache.drill.exec.ops.FragmentContextInterface;
import oadd.org.apache.drill.exec.ops.FragmentStats;
import oadd.org.apache.drill.exec.ops.OperatorContext;
import oadd.org.apache.drill.exec.ops.OperatorContextImpl;
import oadd.org.apache.drill.exec.ops.OperatorStats;
import oadd.org.apache.drill.exec.ops.QueryContext;
import oadd.org.apache.drill.exec.ops.SendingAccountor;
import oadd.org.apache.drill.exec.ops.StatusHandler;
import oadd.org.apache.drill.exec.ops.UdfUtilities;
import oadd.org.apache.drill.exec.physical.base.PhysicalOperator;
import oadd.org.apache.drill.exec.planner.physical.PlannerSettings;
import oadd.org.apache.drill.exec.proto.BitControl;
import oadd.org.apache.drill.exec.proto.CoordinationProtos;
import oadd.org.apache.drill.exec.proto.ExecProtos;
import oadd.org.apache.drill.exec.proto.GeneralRPCProtos;
import oadd.org.apache.drill.exec.proto.helper.QueryIdHelper;
import oadd.org.apache.drill.exec.rpc.RpcException;
import oadd.org.apache.drill.exec.rpc.RpcOutcomeListener;
import oadd.org.apache.drill.exec.rpc.UserClientConnection;
import oadd.org.apache.drill.exec.rpc.control.ControlTunnel;
import oadd.org.apache.drill.exec.rpc.control.WorkEventBus;
import oadd.org.apache.drill.exec.server.DrillbitContext;
import oadd.org.apache.drill.exec.server.options.FragmentOptionManager;
import oadd.org.apache.drill.exec.server.options.OptionList;
import oadd.org.apache.drill.exec.server.options.OptionManager;
import oadd.org.apache.drill.exec.server.options.OptionSet;
import oadd.org.apache.drill.exec.store.PartitionExplorer;
import oadd.org.apache.drill.exec.store.SchemaConfig;
import oadd.org.apache.drill.exec.testing.ExecutionControls;
import oadd.org.apache.drill.exec.util.ImpersonationUtil;
import oadd.org.apache.drill.exec.work.batch.IncomingBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentContext
extends BaseFragmentContext
implements AutoCloseable,
UdfUtilities,
FragmentContextInterface {
    private static final Logger logger = LoggerFactory.getLogger(FragmentContext.class);
    private final Map<CoordinationProtos.DrillbitEndpoint, AccountingDataTunnel> tunnels = Maps.newHashMap();
    private final List<OperatorContextImpl> contexts = Lists.newLinkedList();
    private final DrillbitContext context;
    private final UserClientConnection connection;
    private final QueryContext queryContext;
    private final FragmentStats stats;
    private final BufferAllocator allocator;
    private final BitControl.PlanFragment fragment;
    private final ContextInformation contextInformation;
    private IncomingBuffers buffers;
    private final OptionManager fragmentOptions;
    private final BufferManager bufferManager;
    private ExecutorState executorState;
    private final ExecutionControls executionControls;
    private final SendingAccountor sendingAccountor = new SendingAccountor();
    private final Consumer<RpcException> exceptionConsumer = new Consumer<RpcException>(){

        @Override
        public void accept(RpcException e) {
            FragmentContext.this.fail(e);
        }

        @Override
        public void interrupt(InterruptedException e) {
            if (FragmentContext.this.shouldContinue()) {
                logger.error("Received an unexpected interrupt while waiting for the data send to complete.", e);
                FragmentContext.this.fail(e);
            }
        }
    };
    private final RpcOutcomeListener<GeneralRPCProtos.Ack> statusHandler = new StatusHandler(this.exceptionConsumer, this.sendingAccountor);
    private final AccountingUserConnection accountingUserConnection;
    private final Map<String, Map<TypeProtos.MinorType, ValueHolder>> constantValueHolderCache;

    public FragmentContext(DrillbitContext dbContext, BitControl.PlanFragment fragment, FunctionImplementationRegistry funcRegistry) throws ExecutionSetupException {
        this(dbContext, fragment, null, null, funcRegistry);
    }

    public FragmentContext(DrillbitContext dbContext, BitControl.PlanFragment fragment, QueryContext queryContext, UserClientConnection connection, FunctionImplementationRegistry funcRegistry) throws ExecutionSetupException {
        super(funcRegistry);
        OptionList list;
        this.context = dbContext;
        this.queryContext = queryContext;
        this.connection = connection;
        this.accountingUserConnection = new AccountingUserConnection(connection, this.sendingAccountor, this.statusHandler);
        this.fragment = fragment;
        this.contextInformation = new ContextInformation(fragment.getCredentials(), fragment.getContext());
        logger.debug("Getting initial memory allocation of {}", (Object)fragment.getMemInitial());
        logger.debug("Fragment max allocation: {}", (Object)fragment.getMemMax());
        if (!fragment.hasOptionsJson() || fragment.getOptionsJson().isEmpty()) {
            list = new OptionList();
        } else {
            try {
                list = dbContext.getLpPersistence().getMapper().readValue(fragment.getOptionsJson(), OptionList.class);
            }
            catch (Exception e) {
                throw new ExecutionSetupException("Failure while reading plan options.", e);
            }
        }
        this.fragmentOptions = new FragmentOptionManager((OptionManager)this.context.getOptionManager(), list);
        this.executionControls = new ExecutionControls(this.fragmentOptions, dbContext.getEndpoint());
        try {
            this.allocator = this.context.getAllocator().newChildAllocator("frag:" + QueryIdHelper.getFragmentId(fragment.getHandle()), fragment.getMemInitial(), fragment.getMemMax());
            Preconditions.checkNotNull(this.allocator, "Unable to acuqire allocator");
        }
        catch (OutOfMemoryException e) {
            throw UserException.memoryError(e).addContext("Fragment", this.getHandle().getMajorFragmentId() + ":" + this.getHandle().getMinorFragmentId()).build(logger);
        }
        catch (Throwable e) {
            throw new ExecutionSetupException("Failure while getting memory allocator for fragment.", e);
        }
        this.stats = new FragmentStats(this.allocator, fragment.getAssignment());
        this.bufferManager = new BufferManagerImpl(this.allocator);
        this.constantValueHolderCache = Maps.newHashMap();
    }

    public FragmentContext(DrillbitContext dbContext, BitControl.PlanFragment fragment, UserClientConnection connection, FunctionImplementationRegistry funcRegistry) throws ExecutionSetupException {
        this(dbContext, fragment, null, connection, funcRegistry);
    }

    public OptionManager getOptions() {
        return this.fragmentOptions;
    }

    @Override
    public OptionSet getOptionSet() {
        return this.fragmentOptions;
    }

    public void setBuffers(IncomingBuffers buffers) {
        Preconditions.checkArgument(this.buffers == null, "Can only set buffers once.");
        this.buffers = buffers;
    }

    public void setExecutorState(ExecutorState executorState) {
        Preconditions.checkArgument(this.executorState == null, "ExecutorState can only be set once.");
        this.executorState = executorState;
    }

    public void fail(Throwable cause) {
        this.executorState.fail(cause);
    }

    @Override
    public boolean shouldContinue() {
        return this.executorState.shouldContinue();
    }

    @Override
    public DrillbitContext getDrillbitContext() {
        return this.context;
    }

    public SchemaPlus getFullRootSchema() {
        if (this.queryContext == null) {
            this.fail(new UnsupportedOperationException("Schema tree can only be created in root fragment. This is a non-root fragment."));
            return null;
        }
        boolean isImpersonationEnabled = this.isImpersonationEnabled();
        SchemaConfig schemaConfig = SchemaConfig.newBuilder((String)(isImpersonationEnabled ? this.queryContext.getQueryUserName() : ImpersonationUtil.getProcessUserName()), (SchemaConfig.SchemaConfigInfoProvider)this.queryContext).setIgnoreAuthErrors(isImpersonationEnabled).build();
        return this.queryContext.getFullRootSchema(schemaConfig);
    }

    public CoordinationProtos.DrillbitEndpoint getIdentity() {
        return this.context.getEndpoint();
    }

    public FragmentStats getStats() {
        return this.stats;
    }

    @Override
    public ContextInformation getContextInformation() {
        return this.contextInformation;
    }

    public CoordinationProtos.DrillbitEndpoint getForemanEndpoint() {
        return this.fragment.getForeman();
    }

    public ExecProtos.FragmentHandle getHandle() {
        return this.fragment.getHandle();
    }

    public String getFragIdString() {
        ExecProtos.FragmentHandle handle = this.getHandle();
        String frag = handle != null ? handle.getMajorFragmentId() + ":" + handle.getMinorFragmentId() : "0:0";
        return frag;
    }

    @Deprecated
    public BufferAllocator getAllocator() {
        if (this.allocator == null) {
            logger.debug("Fragment: " + this.getFragIdString() + " Allocator is NULL");
        }
        return this.allocator;
    }

    public BufferAllocator getNewChildAllocator(String operatorName, int operatorId, long initialReservation, long maximumReservation) throws OutOfMemoryException {
        return this.allocator.newChildAllocator("op:" + QueryIdHelper.getFragmentId(this.fragment.getHandle()) + ":" + operatorId + ":" + operatorName, initialReservation, maximumReservation);
    }

    public boolean isOverMemoryLimit() {
        return this.allocator.isOverLimit();
    }

    @Override
    protected CodeCompiler getCompiler() {
        return this.context.getCompiler();
    }

    public AccountingUserConnection getUserDataTunnel() {
        Preconditions.checkState(this.connection != null, "Only Root fragment can get UserDataTunnel");
        return this.accountingUserConnection;
    }

    public ControlTunnel getControlTunnel(CoordinationProtos.DrillbitEndpoint endpoint) {
        return this.context.getController().getTunnel(endpoint);
    }

    public AccountingDataTunnel getDataTunnel(CoordinationProtos.DrillbitEndpoint endpoint) {
        AccountingDataTunnel tunnel = this.tunnels.get(endpoint);
        if (tunnel == null) {
            tunnel = new AccountingDataTunnel(this.context.getDataConnectionsPool().getTunnel(endpoint), this.sendingAccountor, this.statusHandler);
            this.tunnels.put(endpoint, tunnel);
        }
        return tunnel;
    }

    public IncomingBuffers getBuffers() {
        return this.buffers;
    }

    public OperatorContext newOperatorContext(PhysicalOperator popConfig, OperatorStats stats) throws OutOfMemoryException {
        OperatorContextImpl context = new OperatorContextImpl(popConfig, this, stats);
        this.contexts.add(context);
        return context;
    }

    public OperatorContext newOperatorContext(PhysicalOperator popConfig) throws OutOfMemoryException {
        OperatorContextImpl context = new OperatorContextImpl(popConfig, this);
        this.contexts.add(context);
        return context;
    }

    @Deprecated
    @VisibleForTesting
    public Throwable getFailureCause() {
        return this.executorState.getFailureCause();
    }

    @Deprecated
    @VisibleForTesting
    public boolean isFailed() {
        return this.executorState.isFailed();
    }

    @Override
    public DrillConfig getConfig() {
        return this.context.getConfig();
    }

    public void setFragmentLimit(long limit) {
        this.allocator.setLimit(limit);
    }

    @Override
    public ExecutionControls getExecutionControls() {
        return this.executionControls;
    }

    public String getQueryUserName() {
        return this.fragment.getCredentials().getUserName();
    }

    public boolean isImpersonationEnabled() {
        if (this.getConfig() == null) {
            return false;
        }
        return this.getConfig().getBoolean("drill.exec.impersonation.enabled");
    }

    @Override
    public void close() {
        this.waitForSendComplete();
        for (OperatorContextImpl opContext : this.contexts) {
            this.suppressingClose(opContext);
        }
        this.suppressingClose(this.bufferManager);
        this.suppressingClose((AutoCloseable)this.buffers);
        this.suppressingClose(this.allocator);
    }

    private void suppressingClose(AutoCloseable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    @Override
    public PartitionExplorer getPartitionExplorer() {
        throw new UnsupportedOperationException(String.format("The partition explorer interface can only be used in functions that can be evaluated at planning time. Make sure that the %s configuration option is set to true.", PlannerSettings.CONSTANT_FOLDING.getOptionName()));
    }

    @Override
    public ValueHolder getConstantValueHolder(String value, TypeProtos.MinorType type, Function<DrillBuf, ValueHolder> holderInitializer) {
        Map<TypeProtos.MinorType, ValueHolder> holdersByType;
        ValueHolder valueHolder;
        if (!this.constantValueHolderCache.containsKey(value)) {
            this.constantValueHolderCache.put(value, Maps.newHashMap());
        }
        if ((valueHolder = (holdersByType = this.constantValueHolderCache.get(value)).get(type)) == null) {
            valueHolder = holderInitializer.apply(this.getManagedBuffer());
            holdersByType.put(type, valueHolder);
        }
        return valueHolder;
    }

    public Executor getExecutor() {
        return this.context.getExecutor();
    }

    public void waitForSendComplete() {
        this.sendingAccountor.waitForSendComplete();
    }

    public WorkEventBus getWorkEventbus() {
        return this.context.getWorkBus();
    }

    public boolean isBuffersDone() {
        Preconditions.checkState(this.buffers != null, "Incoming Buffers is not set in this fragment context");
        return this.buffers.isDone();
    }

    @Override
    protected BufferManager getBufferManager() {
        return this.bufferManager;
    }

    public static interface ExecutorState {
        public boolean shouldContinue();

        public void fail(Throwable var1);

        @Deprecated
        @VisibleForTesting
        public boolean isFailed();

        @Deprecated
        @VisibleForTesting
        public Throwable getFailureCause();
    }
}

