/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.expr.stat;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oadd.com.google.common.base.Preconditions;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.expression.FunctionHolderExpression;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.expression.ValueExpressions;
import oadd.org.apache.drill.common.expression.fn.CastFunctions;
import oadd.org.apache.drill.common.expression.fn.FuncHolder;
import oadd.org.apache.drill.common.expression.visitors.AbstractExprVisitor;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.expr.DrillSimpleFunc;
import oadd.org.apache.drill.exec.expr.fn.DrillSimpleFuncHolder;
import oadd.org.apache.drill.exec.expr.fn.interpreter.InterpreterEvaluator;
import oadd.org.apache.drill.exec.expr.holders.BigIntHolder;
import oadd.org.apache.drill.exec.expr.holders.Float4Holder;
import oadd.org.apache.drill.exec.expr.holders.Float8Holder;
import oadd.org.apache.drill.exec.expr.holders.IntHolder;
import oadd.org.apache.drill.exec.expr.holders.ValueHolder;
import oadd.org.apache.drill.exec.expr.stat.TypedFieldExpr;
import oadd.org.apache.drill.exec.store.parquet.stat.ColumnStatistics;
import oadd.org.apache.drill.exec.vector.ValueHolderHelper;
import org.apache.parquet.column.statistics.DoubleStatistics;
import org.apache.parquet.column.statistics.FloatStatistics;
import org.apache.parquet.column.statistics.IntStatistics;
import org.apache.parquet.column.statistics.LongStatistics;
import org.apache.parquet.column.statistics.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeExprEvaluator
extends AbstractExprVisitor<Statistics, Void, RuntimeException> {
    static final Logger logger = LoggerFactory.getLogger(RangeExprEvaluator.class);
    private final Map<SchemaPath, ColumnStatistics> columnStatMap;
    private final long rowCount;
    static Map<TypeProtos.MinorType, Set<TypeProtos.MinorType>> CAST_FUNC = new HashMap<TypeProtos.MinorType, Set<TypeProtos.MinorType>>();

    public RangeExprEvaluator(Map<SchemaPath, ColumnStatistics> columnStatMap, long rowCount) {
        this.columnStatMap = columnStatMap;
        this.rowCount = rowCount;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    @Override
    public Statistics visitUnknown(LogicalExpression e, Void value) throws RuntimeException {
        if (e instanceof TypedFieldExpr) {
            TypedFieldExpr fieldExpr = (TypedFieldExpr)e;
            ColumnStatistics columnStatistics = this.columnStatMap.get(fieldExpr.getPath());
            if (columnStatistics != null) {
                return columnStatistics.getStatistics();
            }
            Preconditions.checkArgument(fieldExpr.getMajorType().equals(Types.OPTIONAL_INT));
            IntStatistics intStatistics = new IntStatistics();
            intStatistics.setNumNulls(this.rowCount);
            return intStatistics;
        }
        return null;
    }

    @Override
    public Statistics visitIntConstant(ValueExpressions.IntExpression expr, Void value) throws RuntimeException {
        return this.getStatistics(expr.getInt());
    }

    @Override
    public Statistics visitLongConstant(ValueExpressions.LongExpression expr, Void value) throws RuntimeException {
        return this.getStatistics(expr.getLong());
    }

    @Override
    public Statistics visitFloatConstant(ValueExpressions.FloatExpression expr, Void value) throws RuntimeException {
        return this.getStatistics(expr.getFloat());
    }

    @Override
    public Statistics visitDoubleConstant(ValueExpressions.DoubleExpression expr, Void value) throws RuntimeException {
        return this.getStatistics(expr.getDouble());
    }

    @Override
    public Statistics visitDateConstant(ValueExpressions.DateExpression expr, Void value) throws RuntimeException {
        long dateInMillis = expr.getDate();
        return this.getStatistics(dateInMillis);
    }

    @Override
    public Statistics visitTimeStampConstant(ValueExpressions.TimeStampExpression tsExpr, Void value) throws RuntimeException {
        long tsInMillis = tsExpr.getTimeStamp();
        return this.getStatistics(tsInMillis);
    }

    @Override
    public Statistics visitTimeConstant(ValueExpressions.TimeExpression timeExpr, Void value) throws RuntimeException {
        int milliSeconds = timeExpr.getTime();
        return this.getStatistics(milliSeconds);
    }

    @Override
    public Statistics visitFunctionHolderExpression(FunctionHolderExpression holderExpr, Void value) throws RuntimeException {
        Statistics stat;
        FuncHolder funcHolder = holderExpr.getHolder();
        if (!(funcHolder instanceof DrillSimpleFuncHolder)) {
            return null;
        }
        String funcName = ((DrillSimpleFuncHolder)funcHolder).getRegisteredNames()[0];
        if (CastFunctions.isCastFunction(funcName) && (stat = ((LogicalExpression)holderExpr.args.get(0)).accept(this, null)) != null && !stat.isEmpty()) {
            return this.evalCastFunc(holderExpr, stat);
        }
        return null;
    }

    private IntStatistics getStatistics(int value) {
        return this.getStatistics(value, value);
    }

    private IntStatistics getStatistics(int min, int max) {
        IntStatistics intStatistics = new IntStatistics();
        intStatistics.setMinMax(min, max);
        return intStatistics;
    }

    private LongStatistics getStatistics(long value) {
        return this.getStatistics(value, value);
    }

    private LongStatistics getStatistics(long min, long max) {
        LongStatistics longStatistics = new LongStatistics();
        longStatistics.setMinMax(min, max);
        return longStatistics;
    }

    private DoubleStatistics getStatistics(double value) {
        return this.getStatistics(value, value);
    }

    private DoubleStatistics getStatistics(double min, double max) {
        DoubleStatistics doubleStatistics = new DoubleStatistics();
        doubleStatistics.setMinMax(min, max);
        return doubleStatistics;
    }

    private FloatStatistics getStatistics(float value) {
        return this.getStatistics(value, value);
    }

    private FloatStatistics getStatistics(float min, float max) {
        FloatStatistics floatStatistics = new FloatStatistics();
        floatStatistics.setMinMax(min, max);
        return floatStatistics;
    }

    private Statistics evalCastFunc(FunctionHolderExpression holderExpr, Statistics input) {
        try {
            ValueHolder maxHolder;
            ValueHolder minHolder;
            DrillSimpleFuncHolder funcHolder = (DrillSimpleFuncHolder)holderExpr.getHolder();
            DrillSimpleFunc interpreter = funcHolder.createInterpreter();
            TypeProtos.MinorType srcType = ((LogicalExpression)holderExpr.args.get(0)).getMajorType().getMinorType();
            TypeProtos.MinorType destType = holderExpr.getMajorType().getMinorType();
            if (srcType.equals(destType)) {
                return input;
            }
            if (!CAST_FUNC.containsKey(srcType) || !CAST_FUNC.get(srcType).contains(destType)) {
                return null;
            }
            switch (srcType) {
                case INT: {
                    minHolder = ValueHolderHelper.getIntHolder(((IntStatistics)input).getMin());
                    maxHolder = ValueHolderHelper.getIntHolder(((IntStatistics)input).getMax());
                    break;
                }
                case BIGINT: {
                    minHolder = ValueHolderHelper.getBigIntHolder(((LongStatistics)input).getMin());
                    maxHolder = ValueHolderHelper.getBigIntHolder(((LongStatistics)input).getMax());
                    break;
                }
                case FLOAT4: {
                    minHolder = ValueHolderHelper.getFloat4Holder(((FloatStatistics)input).getMin());
                    maxHolder = ValueHolderHelper.getFloat4Holder(((FloatStatistics)input).getMax());
                    break;
                }
                case FLOAT8: {
                    minHolder = ValueHolderHelper.getFloat8Holder(((DoubleStatistics)input).getMin());
                    maxHolder = ValueHolderHelper.getFloat8Holder(((DoubleStatistics)input).getMax());
                    break;
                }
                default: {
                    return null;
                }
            }
            ValueHolder[] args1 = new ValueHolder[]{minHolder};
            ValueHolder[] args2 = new ValueHolder[]{maxHolder};
            ValueHolder minFuncHolder = InterpreterEvaluator.evaluateFunction((DrillSimpleFunc)interpreter, (ValueHolder[])args1, (String)holderExpr.getName());
            ValueHolder maxFuncHolder = InterpreterEvaluator.evaluateFunction((DrillSimpleFunc)interpreter, (ValueHolder[])args2, (String)holderExpr.getName());
            switch (destType) {
                case INT: {
                    return this.getStatistics(((IntHolder)minFuncHolder).value, ((IntHolder)maxFuncHolder).value);
                }
                case BIGINT: {
                    return this.getStatistics(((BigIntHolder)minFuncHolder).value, ((BigIntHolder)maxFuncHolder).value);
                }
                case FLOAT4: {
                    return this.getStatistics(((Float4Holder)minFuncHolder).value, ((Float4Holder)maxFuncHolder).value);
                }
                case FLOAT8: {
                    return this.getStatistics(((Float8Holder)minFuncHolder).value, ((Float8Holder)maxFuncHolder).value);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new DrillRuntimeException("Error in evaluating function of " + holderExpr.getName());
        }
    }

    static {
        CAST_FUNC.put(TypeProtos.MinorType.FLOAT4, new HashSet());
        CAST_FUNC.get(TypeProtos.MinorType.FLOAT4).add(TypeProtos.MinorType.FLOAT8);
        CAST_FUNC.get(TypeProtos.MinorType.FLOAT4).add(TypeProtos.MinorType.INT);
        CAST_FUNC.get(TypeProtos.MinorType.FLOAT4).add(TypeProtos.MinorType.BIGINT);
        CAST_FUNC.put(TypeProtos.MinorType.FLOAT8, new HashSet());
        CAST_FUNC.get(TypeProtos.MinorType.FLOAT8).add(TypeProtos.MinorType.FLOAT4);
        CAST_FUNC.get(TypeProtos.MinorType.FLOAT8).add(TypeProtos.MinorType.INT);
        CAST_FUNC.get(TypeProtos.MinorType.FLOAT8).add(TypeProtos.MinorType.BIGINT);
        CAST_FUNC.put(TypeProtos.MinorType.INT, new HashSet());
        CAST_FUNC.get(TypeProtos.MinorType.INT).add(TypeProtos.MinorType.FLOAT4);
        CAST_FUNC.get(TypeProtos.MinorType.INT).add(TypeProtos.MinorType.FLOAT8);
        CAST_FUNC.get(TypeProtos.MinorType.INT).add(TypeProtos.MinorType.BIGINT);
        CAST_FUNC.put(TypeProtos.MinorType.BIGINT, new HashSet());
        CAST_FUNC.get(TypeProtos.MinorType.BIGINT).add(TypeProtos.MinorType.INT);
        CAST_FUNC.get(TypeProtos.MinorType.BIGINT).add(TypeProtos.MinorType.FLOAT4);
        CAST_FUNC.get(TypeProtos.MinorType.BIGINT).add(TypeProtos.MinorType.FLOAT8);
    }
}

