/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.expr.stat;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oadd.org.apache.drill.common.expression.BooleanOperator;
import oadd.org.apache.drill.common.expression.ExpressionPosition;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.LogicalExpressionBase;
import oadd.org.apache.drill.common.expression.visitors.ExprVisitor;
import oadd.org.apache.drill.exec.expr.stat.ParquetFilterPredicate;
import oadd.org.apache.drill.exec.expr.stat.RangeExprEvaluator;
import org.apache.parquet.column.statistics.Statistics;

public abstract class ParquetPredicates {
    protected static boolean isAllNulls(Statistics stat, long rowCount) {
        return stat.getNumNulls() == rowCount;
    }

    protected static boolean hasNulls(Statistics stat) {
        return stat.getNumNulls() > 0L;
    }

    public static class NEPredicate
    extends ParquetCompPredicate {
        public NEPredicate(LogicalExpression left, LogicalExpression right) {
            super(left, right);
        }

        @Override
        public boolean canDrop(RangeExprEvaluator evaluator) {
            Statistics leftStat = this.left.accept(evaluator, null);
            Statistics rightStat = this.right.accept(evaluator, null);
            if (leftStat == null || rightStat == null || leftStat.isEmpty() || rightStat.isEmpty()) {
                return false;
            }
            if (ParquetPredicates.isAllNulls(leftStat, evaluator.getRowCount()) || ParquetPredicates.isAllNulls(rightStat, evaluator.getRowCount())) {
                return true;
            }
            return leftStat.genericGetMin().compareTo(leftStat.genericGetMax()) == 0 && rightStat.genericGetMin().compareTo(rightStat.genericGetMax()) == 0 && leftStat.genericGetMax().compareTo(rightStat.genericGetMax()) == 0;
        }
    }

    public static class LEPredicate
    extends ParquetCompPredicate {
        public LEPredicate(LogicalExpression left, LogicalExpression right) {
            super(left, right);
        }

        @Override
        public boolean canDrop(RangeExprEvaluator evaluator) {
            Statistics leftStat = this.left.accept(evaluator, null);
            Statistics rightStat = this.right.accept(evaluator, null);
            if (leftStat == null || rightStat == null || leftStat.isEmpty() || rightStat.isEmpty()) {
                return false;
            }
            if (ParquetPredicates.isAllNulls(leftStat, evaluator.getRowCount()) || ParquetPredicates.isAllNulls(rightStat, evaluator.getRowCount())) {
                return true;
            }
            return rightStat.genericGetMax().compareTo(leftStat.genericGetMin()) < 0;
        }
    }

    public static class LTPredicate
    extends ParquetCompPredicate {
        public LTPredicate(LogicalExpression left, LogicalExpression right) {
            super(left, right);
        }

        @Override
        public boolean canDrop(RangeExprEvaluator evaluator) {
            Statistics leftStat = this.left.accept(evaluator, null);
            Statistics rightStat = this.right.accept(evaluator, null);
            if (leftStat == null || rightStat == null || leftStat.isEmpty() || rightStat.isEmpty()) {
                return false;
            }
            if (ParquetPredicates.isAllNulls(leftStat, evaluator.getRowCount()) || ParquetPredicates.isAllNulls(rightStat, evaluator.getRowCount())) {
                return true;
            }
            return rightStat.genericGetMax().compareTo(leftStat.genericGetMin()) <= 0;
        }
    }

    public static class GEPredicate
    extends ParquetCompPredicate {
        public GEPredicate(LogicalExpression left, LogicalExpression right) {
            super(left, right);
        }

        @Override
        public boolean canDrop(RangeExprEvaluator evaluator) {
            Statistics leftStat = this.left.accept(evaluator, null);
            Statistics rightStat = this.right.accept(evaluator, null);
            if (leftStat == null || rightStat == null || leftStat.isEmpty() || rightStat.isEmpty()) {
                return false;
            }
            if (ParquetPredicates.isAllNulls(leftStat, evaluator.getRowCount()) || ParquetPredicates.isAllNulls(rightStat, evaluator.getRowCount())) {
                return true;
            }
            return leftStat.genericGetMax().compareTo(rightStat.genericGetMin()) < 0;
        }
    }

    public static class GTPredicate
    extends ParquetCompPredicate {
        public GTPredicate(LogicalExpression left, LogicalExpression right) {
            super(left, right);
        }

        @Override
        public boolean canDrop(RangeExprEvaluator evaluator) {
            Statistics leftStat = this.left.accept(evaluator, null);
            Statistics rightStat = this.right.accept(evaluator, null);
            if (leftStat == null || rightStat == null || leftStat.isEmpty() || rightStat.isEmpty()) {
                return false;
            }
            if (ParquetPredicates.isAllNulls(leftStat, evaluator.getRowCount()) || ParquetPredicates.isAllNulls(rightStat, evaluator.getRowCount())) {
                return true;
            }
            return leftStat.genericGetMax().compareTo(rightStat.genericGetMin()) <= 0;
        }
    }

    public static class EqualPredicate
    extends ParquetCompPredicate {
        public EqualPredicate(LogicalExpression left, LogicalExpression right) {
            super(left, right);
        }

        @Override
        public boolean canDrop(RangeExprEvaluator evaluator) {
            Statistics leftStat = this.left.accept(evaluator, null);
            Statistics rightStat = this.right.accept(evaluator, null);
            if (leftStat == null || rightStat == null || leftStat.isEmpty() || rightStat.isEmpty()) {
                return false;
            }
            if (ParquetPredicates.isAllNulls(leftStat, evaluator.getRowCount()) || ParquetPredicates.isAllNulls(rightStat, evaluator.getRowCount())) {
                return true;
            }
            return leftStat.genericGetMax().compareTo(rightStat.genericGetMin()) < 0 || rightStat.genericGetMax().compareTo(leftStat.genericGetMin()) < 0;
        }

        public String toString() {
            return this.left.toString() + " = " + this.right.toString();
        }
    }

    public static class OrPredicate
    extends ParquetBooleanPredicate {
        public OrPredicate(String name, List<LogicalExpression> args, ExpressionPosition pos) {
            super(name, args, pos);
        }

        @Override
        public boolean canDrop(RangeExprEvaluator evaluator) {
            for (LogicalExpression child : this) {
                if (((ParquetFilterPredicate)((Object)child)).canDrop(evaluator)) continue;
                return false;
            }
            return true;
        }
    }

    public static class AndPredicate
    extends ParquetBooleanPredicate {
        public AndPredicate(String name, List<LogicalExpression> args, ExpressionPosition pos) {
            super(name, args, pos);
        }

        @Override
        public boolean canDrop(RangeExprEvaluator evaluator) {
            for (LogicalExpression child : this) {
                if (!((ParquetFilterPredicate)((Object)child)).canDrop(evaluator)) continue;
                return true;
            }
            return false;
        }
    }

    public static abstract class ParquetBooleanPredicate
    extends BooleanOperator
    implements ParquetFilterPredicate {
        public ParquetBooleanPredicate(String name, List<LogicalExpression> args, ExpressionPosition pos) {
            super(name, args, pos);
        }

        @Override
        public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitBooleanOperator(this, value);
        }
    }

    public static abstract class ParquetCompPredicate
    extends LogicalExpressionBase
    implements ParquetFilterPredicate {
        protected final LogicalExpression left;
        protected final LogicalExpression right;

        public ParquetCompPredicate(LogicalExpression left, LogicalExpression right) {
            super(left.getPosition());
            this.left = left;
            this.right = right;
        }

        @Override
        public Iterator<LogicalExpression> iterator() {
            ArrayList<LogicalExpression> args = new ArrayList<LogicalExpression>();
            args.add(this.left);
            args.add(this.right);
            return args.iterator();
        }

        @Override
        public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitUnknown(this, value);
        }
    }
}

