/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.expr;

import java.util.ArrayList;
import oadd.com.google.common.collect.Lists;
import oadd.org.apache.drill.common.expression.BooleanOperator;
import oadd.org.apache.drill.common.expression.CastExpression;
import oadd.org.apache.drill.common.expression.ConvertExpression;
import oadd.org.apache.drill.common.expression.FunctionCall;
import oadd.org.apache.drill.common.expression.FunctionHolderExpression;
import oadd.org.apache.drill.common.expression.IfExpression;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.NullExpression;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.expression.TypedNullConstant;
import oadd.org.apache.drill.common.expression.ValueExpressions;
import oadd.org.apache.drill.common.expression.visitors.AbstractExprVisitor;
import oadd.org.apache.drill.exec.expr.ValueVectorReadExpression;

class EqualityVisitor
extends AbstractExprVisitor<Boolean, LogicalExpression, RuntimeException> {
    EqualityVisitor() {
    }

    @Override
    public Boolean visitFunctionCall(FunctionCall call, LogicalExpression value) throws RuntimeException {
        if (!(value instanceof FunctionCall)) {
            return false;
        }
        if (!this.checkType(call, value)) {
            return false;
        }
        if (!call.getName().equals(((FunctionCall)value).getName())) {
            return false;
        }
        return this.checkChildren(call, value);
    }

    @Override
    public Boolean visitFunctionHolderExpression(FunctionHolderExpression holder, LogicalExpression value) throws RuntimeException {
        if (!(value instanceof FunctionHolderExpression)) {
            return false;
        }
        if (!this.checkType(holder, value)) {
            return false;
        }
        if (!holder.getName().equals(((FunctionHolderExpression)value).getName())) {
            return false;
        }
        if (holder.isRandom()) {
            return false;
        }
        return this.checkChildren(holder, value);
    }

    @Override
    public Boolean visitIfExpression(IfExpression ifExpr, LogicalExpression value) throws RuntimeException {
        if (!(value instanceof IfExpression)) {
            return false;
        }
        return this.checkChildren(ifExpr, value);
    }

    @Override
    public Boolean visitBooleanOperator(BooleanOperator call, LogicalExpression value) throws RuntimeException {
        if (!(value instanceof BooleanOperator)) {
            return false;
        }
        if (!call.getName().equals(((BooleanOperator)value).getName())) {
            return false;
        }
        return this.checkChildren(call, value);
    }

    @Override
    public Boolean visitSchemaPath(SchemaPath path, LogicalExpression value) throws RuntimeException {
        if (!(value instanceof SchemaPath)) {
            return false;
        }
        return path.equals(value);
    }

    @Override
    public Boolean visitIntConstant(ValueExpressions.IntExpression intExpr, LogicalExpression value) throws RuntimeException {
        if (!(value instanceof ValueExpressions.IntExpression)) {
            return false;
        }
        return intExpr.getInt() == ((ValueExpressions.IntExpression)value).getInt();
    }

    @Override
    public Boolean visitFloatConstant(ValueExpressions.FloatExpression fExpr, LogicalExpression value) throws RuntimeException {
        if (!(value instanceof ValueExpressions.FloatExpression)) {
            return false;
        }
        return fExpr.getFloat() == ((ValueExpressions.FloatExpression)value).getFloat();
    }

    @Override
    public Boolean visitLongConstant(ValueExpressions.LongExpression intExpr, LogicalExpression value) throws RuntimeException {
        if (!(value instanceof ValueExpressions.LongExpression)) {
            return false;
        }
        return intExpr.getLong() == ((ValueExpressions.LongExpression)value).getLong();
    }

    @Override
    public Boolean visitDateConstant(ValueExpressions.DateExpression intExpr, LogicalExpression value) throws RuntimeException {
        if (!(value instanceof ValueExpressions.DateExpression)) {
            return false;
        }
        return intExpr.getDate() == ((ValueExpressions.DateExpression)value).getDate();
    }

    @Override
    public Boolean visitTimeConstant(ValueExpressions.TimeExpression intExpr, LogicalExpression value) throws RuntimeException {
        if (!(value instanceof ValueExpressions.TimeExpression)) {
            return false;
        }
        return intExpr.getTime() == ((ValueExpressions.TimeExpression)value).getTime();
    }

    @Override
    public Boolean visitTimeStampConstant(ValueExpressions.TimeStampExpression intExpr, LogicalExpression value) throws RuntimeException {
        if (!(value instanceof ValueExpressions.TimeStampExpression)) {
            return false;
        }
        return intExpr.getTimeStamp() == ((ValueExpressions.TimeStampExpression)value).getTimeStamp();
    }

    @Override
    public Boolean visitIntervalYearConstant(ValueExpressions.IntervalYearExpression intExpr, LogicalExpression value) throws RuntimeException {
        if (!(value instanceof ValueExpressions.IntervalYearExpression)) {
            return false;
        }
        return intExpr.getIntervalYear() == ((ValueExpressions.IntervalYearExpression)value).getIntervalYear();
    }

    @Override
    public Boolean visitIntervalDayConstant(ValueExpressions.IntervalDayExpression intExpr, LogicalExpression value) throws RuntimeException {
        if (!(value instanceof ValueExpressions.IntervalDayExpression)) {
            return false;
        }
        return intExpr.getIntervalDay() == ((ValueExpressions.IntervalDayExpression)value).getIntervalDay() && intExpr.getIntervalMillis() == ((ValueExpressions.IntervalDayExpression)value).getIntervalMillis();
    }

    @Override
    public Boolean visitDecimal9Constant(ValueExpressions.Decimal9Expression decExpr, LogicalExpression value) throws RuntimeException {
        if (!(value instanceof ValueExpressions.Decimal9Expression)) {
            return false;
        }
        if (decExpr.getIntFromDecimal() != ((ValueExpressions.Decimal9Expression)value).getIntFromDecimal()) {
            return false;
        }
        if (decExpr.getScale() != ((ValueExpressions.Decimal9Expression)value).getScale()) {
            return false;
        }
        if (decExpr.getPrecision() != ((ValueExpressions.Decimal9Expression)value).getPrecision()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitDecimal18Constant(ValueExpressions.Decimal18Expression decExpr, LogicalExpression value) throws RuntimeException {
        if (!(value instanceof ValueExpressions.Decimal18Expression)) {
            return false;
        }
        if (decExpr.getLongFromDecimal() != ((ValueExpressions.Decimal18Expression)value).getLongFromDecimal()) {
            return false;
        }
        if (decExpr.getScale() != ((ValueExpressions.Decimal18Expression)value).getScale()) {
            return false;
        }
        if (decExpr.getPrecision() != ((ValueExpressions.Decimal18Expression)value).getPrecision()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitDecimal28Constant(ValueExpressions.Decimal28Expression decExpr, LogicalExpression value) throws RuntimeException {
        if (!(value instanceof ValueExpressions.Decimal28Expression)) {
            return false;
        }
        if (decExpr.getBigDecimal() != ((ValueExpressions.Decimal28Expression)value).getBigDecimal()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitDecimal38Constant(ValueExpressions.Decimal38Expression decExpr, LogicalExpression value) throws RuntimeException {
        if (!(value instanceof ValueExpressions.Decimal38Expression)) {
            return false;
        }
        if (decExpr.getBigDecimal() != ((ValueExpressions.Decimal38Expression)value).getBigDecimal()) {
            return false;
        }
        if (!decExpr.getMajorType().equals(((ValueExpressions.Decimal38Expression)value).getMajorType())) {
            return false;
        }
        return false;
    }

    @Override
    public Boolean visitDoubleConstant(ValueExpressions.DoubleExpression dExpr, LogicalExpression value) throws RuntimeException {
        if (!(value instanceof ValueExpressions.DoubleExpression)) {
            return false;
        }
        return dExpr.getDouble() == ((ValueExpressions.DoubleExpression)value).getDouble();
    }

    @Override
    public Boolean visitBooleanConstant(ValueExpressions.BooleanExpression e, LogicalExpression value) throws RuntimeException {
        if (!(value instanceof ValueExpressions.BooleanExpression)) {
            return false;
        }
        return e.getBoolean() == ((ValueExpressions.BooleanExpression)value).getBoolean();
    }

    @Override
    public Boolean visitQuotedStringConstant(ValueExpressions.QuotedString e, LogicalExpression value) throws RuntimeException {
        if (!(value instanceof ValueExpressions.QuotedString)) {
            return false;
        }
        return e.getString().equals(((ValueExpressions.QuotedString)value).getString());
    }

    @Override
    public Boolean visitNullExpression(NullExpression e, LogicalExpression value) throws RuntimeException {
        if (!(value instanceof NullExpression)) {
            return false;
        }
        return e.getMajorType().equals(value.getMajorType());
    }

    @Override
    public Boolean visitCastExpression(CastExpression e, LogicalExpression value) throws RuntimeException {
        if (!(value instanceof CastExpression)) {
            return false;
        }
        if (!e.getMajorType().equals(value.getMajorType())) {
            return false;
        }
        return this.checkChildren(e, value);
    }

    @Override
    public Boolean visitConvertExpression(ConvertExpression e, LogicalExpression value) throws RuntimeException {
        if (!(value instanceof ConvertExpression)) {
            return false;
        }
        if (!e.getConvertFunction().equals(((ConvertExpression)value).getConvertFunction())) {
            return false;
        }
        return this.checkChildren(e, value);
    }

    @Override
    public Boolean visitNullConstant(TypedNullConstant e, LogicalExpression value) throws RuntimeException {
        if (!(value instanceof TypedNullConstant)) {
            return false;
        }
        return value.getMajorType().equals(e.getMajorType());
    }

    @Override
    public Boolean visitUnknown(LogicalExpression e, LogicalExpression value) throws RuntimeException {
        if (e instanceof ValueVectorReadExpression && value instanceof ValueVectorReadExpression) {
            return this.visitValueVectorReadExpression((ValueVectorReadExpression)e, (ValueVectorReadExpression)value);
        }
        return false;
    }

    private Boolean visitValueVectorReadExpression(ValueVectorReadExpression e, ValueVectorReadExpression value) {
        return e.getTypedFieldId().equals(value.getTypedFieldId());
    }

    private boolean checkChildren(LogicalExpression thisExpr, LogicalExpression thatExpr) {
        ArrayList<LogicalExpression> theseChildren = Lists.newArrayList(thisExpr);
        ArrayList<LogicalExpression> thoseChildren = Lists.newArrayList(thatExpr);
        if (theseChildren.size() != thoseChildren.size()) {
            return false;
        }
        for (int i = 0; i < theseChildren.size(); ++i) {
            if (((LogicalExpression)theseChildren.get(i)).accept(this, thoseChildren.get(i)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private boolean checkType(LogicalExpression e1, LogicalExpression e2) {
        return e1.getMajorType().equals(e2.getMajorType());
    }
}

