/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.expr;

import java.util.Iterator;
import java.util.List;
import oadd.org.apache.drill.common.expression.ExpressionPosition;
import oadd.org.apache.drill.common.expression.FunctionHolderExpression;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.DrillSimpleFunc;
import oadd.org.apache.drill.exec.expr.fn.DrillFuncHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillFuncHolderExpr
extends FunctionHolderExpression
implements Iterable<LogicalExpression> {
    static final Logger logger = LoggerFactory.getLogger(DrillFuncHolderExpr.class);
    private DrillFuncHolder holder;
    private DrillSimpleFunc interpreter;

    public DrillFuncHolderExpr(String nameUsed, DrillFuncHolder holder, List<LogicalExpression> args, ExpressionPosition pos) {
        super(nameUsed, pos, args);
        this.holder = holder;
    }

    @Override
    public TypeProtos.MajorType getMajorType() {
        return this.holder.getReturnType((List)this.args);
    }

    @Override
    public Iterator<LogicalExpression> iterator() {
        return this.args.iterator();
    }

    public DrillFuncHolder getHolder() {
        return this.holder;
    }

    @Override
    public boolean isAggregating() {
        return this.holder.isAggregating();
    }

    @Override
    public boolean isRandom() {
        return !this.holder.isDeterministic();
    }

    @Override
    public boolean argConstantOnly(int i) {
        return this.holder.isConstant(i);
    }

    @Override
    public int getSelfCost() {
        return this.holder.getCostCategory();
    }

    @Override
    public int getCumulativeCost() {
        int cost = this.getSelfCost();
        for (LogicalExpression arg : this.args) {
            cost += arg.getCumulativeCost();
        }
        return cost;
    }

    @Override
    public DrillFuncHolderExpr copy(List<LogicalExpression> args) {
        return new DrillFuncHolderExpr(this.nameUsed, this.holder, args, this.getPosition());
    }

    public void setInterpreter(DrillSimpleFunc interpreter) {
        this.interpreter = interpreter;
    }

    public DrillSimpleFunc getInterpreter() {
        return this.interpreter;
    }
}

