/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.expr;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JLabel;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.collect.Lists;
import oadd.com.google.common.collect.Maps;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.ExecConstants;
import oadd.org.apache.drill.exec.compile.sig.CodeGeneratorArgument;
import oadd.org.apache.drill.exec.compile.sig.CodeGeneratorMethod;
import oadd.org.apache.drill.exec.compile.sig.GeneratorMapping;
import oadd.org.apache.drill.exec.compile.sig.MappingSet;
import oadd.org.apache.drill.exec.compile.sig.SignatureHolder;
import oadd.org.apache.drill.exec.exception.SchemaChangeException;
import oadd.org.apache.drill.exec.expr.CodeGenerator;
import oadd.org.apache.drill.exec.expr.DebugStringBuilder;
import oadd.org.apache.drill.exec.expr.DirectExpression;
import oadd.org.apache.drill.exec.expr.EvaluationVisitor;
import oadd.org.apache.drill.exec.expr.SizedJBlock;
import oadd.org.apache.drill.exec.expr.TypeHelper;
import oadd.org.apache.drill.exec.expr.fn.WorkspaceReference;
import oadd.org.apache.drill.exec.record.TypedFieldId;
import oadd.org.apache.drill.exec.server.options.OptionSet;
import oadd.org.apache.drill.exec.vector.ValueVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassGenerator<T> {
    public static final GeneratorMapping DEFAULT_SCALAR_MAP = GeneratorMapping.GM((String)"doSetup", (String)"doEval", null, null);
    public static final GeneratorMapping DEFAULT_CONSTANT_MAP = GeneratorMapping.GM((String)"doSetup", (String)"doSetup", null, null);
    static final Logger logger = LoggerFactory.getLogger(ClassGenerator.class);
    private final SignatureHolder sig;
    private final EvaluationVisitor evaluationVisitor;
    private final Map<ValueVectorSetup, JVar> vvDeclaration = Maps.newHashMap();
    private final Map<String, ClassGenerator<T>> innerClasses = Maps.newHashMap();
    private final List<TypedFieldId> workspaceTypes = Lists.newArrayList();
    private final Map<WorkspaceReference, JVar> workspaceVectors = Maps.newHashMap();
    private final CodeGenerator<T> codeGenerator;
    public final JDefinedClass clazz;
    private final JCodeModel model;
    private final OptionSet optionManager;
    private ClassGenerator<T> innerClassGenerator;
    private LinkedList<SizedJBlock>[] blocks;
    private LinkedList<SizedJBlock>[] oldBlocks;
    private long maxIndex;
    private int index = 0;
    private int labelIndex = 0;
    private MappingSet mappings;

    public static MappingSet getDefaultMapping() {
        return new MappingSet("inIndex", "outIndex", new GeneratorMapping[]{DEFAULT_CONSTANT_MAP, DEFAULT_SCALAR_MAP});
    }

    ClassGenerator(CodeGenerator<T> codeGenerator, MappingSet mappingSet, SignatureHolder signature, EvaluationVisitor eval, JDefinedClass clazz, JCodeModel model, OptionSet optionManager) throws JClassAlreadyExistsException {
        this.codeGenerator = codeGenerator;
        this.clazz = clazz;
        this.mappings = mappingSet;
        this.sig = signature;
        this.evaluationVisitor = eval;
        this.model = model;
        this.optionManager = optionManager;
        this.blocks = new LinkedList[this.sig.size()];
        for (int i = 0; i < this.sig.size(); ++i) {
            this.blocks[i] = Lists.newLinkedList();
        }
        this.rotateBlock();
        for (SignatureHolder child : signature.getChildHolders()) {
            Class innerClass = child.getSignatureClass();
            String innerClassName = innerClass.getSimpleName();
            int mods = 12;
            if ((innerClass.getModifiers() & 8) != 0) {
                mods += 16;
            }
            JDefinedClass innerClazz = clazz._class(mods, innerClassName);
            this.innerClasses.put(innerClassName, new ClassGenerator<T>(codeGenerator, mappingSet, child, eval, innerClazz, model, optionManager));
        }
        long maxExprsNumber = optionManager != null ? optionManager.getOption(ExecConstants.CODE_GEN_EXP_IN_METHOD_SIZE_VALIDATOR) : 50L;
        this.maxIndex = Math.round((65535.0 / (1.0 + 3.0 / (double)((long)(3 * this.sig.size()) + maxExprsNumber)) - 1000.0) / 3.0);
    }

    public ClassGenerator<T> getInnerGenerator(String name) {
        ClassGenerator<T> inner = this.innerClasses.get(name);
        Preconditions.checkNotNull(inner);
        return inner;
    }

    public MappingSet getMappingSet() {
        return this.mappings;
    }

    public void setMappingSet(MappingSet mappings) {
        if (this.innerClassGenerator != null) {
            this.innerClassGenerator.setMappingSet(mappings);
        }
        this.mappings = mappings;
    }

    public CodeGenerator<T> getCodeGenerator() {
        return this.codeGenerator;
    }

    private GeneratorMapping getCurrentMapping() {
        return this.mappings.getCurrentMapping();
    }

    public JBlock getBlock(String methodName) {
        JBlock blk = this.blocks[this.sig.get(methodName)].getLast().getBlock();
        Preconditions.checkNotNull(blk, "Requested method name of %s was not available for signature %s.", methodName, this.sig);
        return blk;
    }

    public JBlock getBlock(BlockType type) {
        return this.getBlock(this.getCurrentMapping().getMethodName(type));
    }

    public JBlock getSetupBlock() {
        return this.getBlock(this.getCurrentMapping().getMethodName(BlockType.SETUP));
    }

    public JBlock getEvalBlock() {
        return this.getBlock(this.getCurrentMapping().getMethodName(BlockType.EVAL));
    }

    public JBlock getResetBlock() {
        return this.getBlock(this.getCurrentMapping().getMethodName(BlockType.RESET));
    }

    public JBlock getCleanupBlock() {
        return this.getBlock(this.getCurrentMapping().getMethodName(BlockType.CLEANUP));
    }

    public void nestEvalBlock(JBlock block) {
        String methodName = this.getCurrentMapping().getMethodName(BlockType.EVAL);
        this.evaluationVisitor.newScope();
        this.blocks[this.sig.get(methodName)].addLast(new SizedJBlock(block));
    }

    public void unNestEvalBlock() {
        String methodName = this.getCurrentMapping().getMethodName(BlockType.EVAL);
        this.evaluationVisitor.leaveScope();
        this.blocks[this.sig.get(methodName)].removeLast();
    }

    public JLabel getEvalBlockLabel(String prefix) {
        return this.getEvalBlock().label(prefix + this.labelIndex++);
    }

    private JBlock createInnerBlock(BlockType type) {
        JBlock currBlock = this.getBlock(type);
        JBlock innerBlock = new JBlock();
        currBlock.add((JStatement)innerBlock);
        return innerBlock;
    }

    protected JBlock createInnerEvalBlock() {
        return this.createInnerBlock(BlockType.EVAL);
    }

    public JVar declareVectorValueSetupAndMember(String batchName, TypedFieldId fieldId) {
        return this.declareVectorValueSetupAndMember(DirectExpression.direct(batchName), fieldId);
    }

    public JVar declareVectorValueSetupAndMember(DirectExpression batchName, TypedFieldId fieldId) {
        JClass vvClass;
        if (this.innerClassGenerator != null) {
            return this.innerClassGenerator.declareVectorValueSetupAndMember(batchName, fieldId);
        }
        ValueVectorSetup setup = new ValueVectorSetup(batchName, fieldId);
        Class<? extends ValueVector> valueVectorClass = fieldId.getIntermediateClass();
        JClass retClass = vvClass = this.model.ref(valueVectorClass);
        String vectorAccess = "getValueVector";
        if (fieldId.isHyperReader()) {
            retClass = retClass.array();
            vectorAccess = "getValueVectors";
        }
        JVar vv = this.declareClassField("vv", (JType)retClass);
        JClass t = this.model.ref(SchemaChangeException.class);
        JClass objClass = this.model.ref(Object.class);
        JBlock b = this.getSetupBlock();
        JVar fieldArr = b.decl((JType)this.model.INT.array(), "fieldIds" + this.index++, (JExpression)JExpr.newArray((JType)this.model.INT, (int)fieldId.getFieldIds().length));
        int[] fieldIndices = fieldId.getFieldIds();
        for (int i = 0; i < fieldIndices.length; ++i) {
            b.assign((JAssignmentTarget)fieldArr.component(JExpr.lit((int)i)), JExpr.lit((int)fieldIndices[i]));
        }
        JInvocation invoke = batchName.invoke("getValueAccessorById").arg(vvClass.dotclass()).arg((JExpression)fieldArr);
        JVar obj = b.decl((JType)objClass, this.getNextVar("tmp"), (JExpression)invoke.invoke(vectorAccess));
        b._if(obj.eq(JExpr._null()))._then()._throw((JExpression)JExpr._new((JClass)t).arg(JExpr.lit((String)String.format("Failure while loading vector %s with id: %s.", vv.name(), fieldId.toString()))));
        b.assign((JAssignmentTarget)vv, (JExpression)JExpr.cast((JType)retClass, (JExpression)obj));
        this.vvDeclaration.put(setup, vv);
        return vv;
    }

    public HoldingContainer addExpr(LogicalExpression ex) {
        return this.addExpr(ex, BlkCreateMode.TRUE);
    }

    public HoldingContainer addExpr(LogicalExpression ex, BlkCreateMode mode) {
        if (mode == BlkCreateMode.TRUE || mode == BlkCreateMode.TRUE_IF_BOUND) {
            this.rotateBlock(mode);
        }
        for (LinkedList<SizedJBlock> b : this.blocks) {
            b.getLast().incCounter();
        }
        return this.evaluationVisitor.addExpr(ex, this);
    }

    public void rotateBlock() {
        this.rotateBlock(BlkCreateMode.TRUE);
    }

    private void setupValidBlocks() {
        if (this.createNestedClass()) {
            this.setupInnerClassBlocks();
        }
    }

    private boolean createNestedClass() {
        if (this.hasMaxIndexValue()) {
            if (this.innerClassGenerator == null) {
                try {
                    JDefinedClass innerClazz = this.clazz._class(4, this.clazz.name() + "0");
                    this.innerClassGenerator = new ClassGenerator<T>(this.codeGenerator, this.mappings, this.sig, this.evaluationVisitor, innerClazz, this.model, this.optionManager);
                }
                catch (JClassAlreadyExistsException e) {
                    throw new DrillRuntimeException(e);
                }
                this.oldBlocks = this.blocks;
                this.innerClassGenerator.index = this.index;
                this.innerClassGenerator.maxIndex += (long)this.index;
                this.setupInnerClassBlocks();
                return true;
            }
            return super.createNestedClass();
        }
        return false;
    }

    private boolean hasMaxIndexValue() {
        return (long)(this.index + this.clazz.fields().size() * 2 / 3) > this.maxIndex;
    }

    private void setupInnerClassBlocks() {
        if (this.innerClassGenerator != null) {
            super.setupInnerClassBlocks();
            this.blocks = this.innerClassGenerator.blocks;
        }
    }

    private void rotateBlock(BlkCreateMode mode) {
        boolean blockRotated = false;
        for (LinkedList<SizedJBlock> b : this.blocks) {
            if (mode != BlkCreateMode.TRUE && (mode != BlkCreateMode.TRUE_IF_BOUND || this.optionManager == null || (long)b.getLast().getCount() <= this.optionManager.getOption(ExecConstants.CODE_GEN_EXP_IN_METHOD_SIZE_VALIDATOR))) continue;
            b.add(new SizedJBlock(new JBlock(true, true)));
            blockRotated = true;
        }
        if (blockRotated) {
            this.evaluationVisitor.previousExpressions.clear();
            this.setupValidBlocks();
        }
    }

    void flushCode() {
        JFieldVar innerClassField = null;
        if (this.innerClassGenerator != null) {
            this.blocks = this.oldBlocks;
            innerClassField = this.clazz.field(0, (JType)this.model.ref(this.innerClassGenerator.clazz.name()), "innerClassField");
            this.innerClassGenerator.flushCode();
        }
        int i = 0;
        for (CodeGeneratorMethod method : this.sig) {
            JMethod outer = this.clazz.method(1, this.model._ref(method.getReturnType()), method.getMethodName());
            for (CodeGeneratorArgument arg : method) {
                outer.param(arg.getType(), arg.getName());
            }
            for (Class c : method.getThrowsIterable()) {
                outer._throws(this.model.ref(c));
            }
            outer._throws(SchemaChangeException.class);
            int methodIndex = 0;
            int exprsInMethod = 0;
            boolean isVoidMethod = method.getReturnType() == Void.TYPE;
            for (SizedJBlock sb : this.blocks[i++]) {
                JBlock b = sb.getBlock();
                if (b.isEmpty()) continue;
                if (this.optionManager != null && (long)exprsInMethod > this.optionManager.getOption(ExecConstants.CODE_GEN_EXP_IN_METHOD_SIZE_VALIDATOR)) {
                    JMethod inner = this.clazz.method(4, this.model._ref(method.getReturnType()), method.getMethodName() + methodIndex);
                    JInvocation methodCall = JExpr.invoke((JMethod)inner);
                    for (CodeGeneratorArgument arg : method) {
                        inner.param(arg.getType(), arg.getName());
                        methodCall.arg(JExpr.direct((String)arg.getName()));
                    }
                    for (Class c : method.getThrowsIterable()) {
                        inner._throws(this.model.ref(c));
                    }
                    inner._throws(SchemaChangeException.class);
                    if (isVoidMethod) {
                        outer.body().add((JStatement)methodCall);
                    } else {
                        outer.body()._return((JExpression)methodCall);
                    }
                    outer = inner;
                    exprsInMethod = 0;
                    ++methodIndex;
                }
                outer.body().add((JStatement)b);
                exprsInMethod += sb.getCount();
            }
            if (innerClassField == null) continue;
            if (method.getMethodName().equals("__DRILL_INIT__")) {
                JInvocation rhs = JExpr._new((JClass)this.innerClassGenerator.clazz);
                JBlock block = new JBlock().assign((JAssignmentTarget)innerClassField, (JExpression)rhs);
                outer.body().add((JStatement)block);
            }
            ArrayList<JType> argTypes = new ArrayList<JType>();
            for (CodeGeneratorArgument arg : method) {
                argTypes.add(this.model._ref(arg.getType()));
            }
            JMethod inner = this.innerClassGenerator.clazz.getMethod(method.getMethodName(), argTypes.toArray(new JType[0]));
            if (inner == null) continue;
            if (inner.body().isEmpty()) {
                this.innerClassGenerator.clazz.methods().remove(inner);
                continue;
            }
            JInvocation methodCall = innerClassField.invoke(inner);
            for (CodeGeneratorArgument arg : method) {
                methodCall.arg(JExpr.direct((String)arg.getName()));
            }
            if (isVoidMethod) {
                outer.body().add((JStatement)methodCall);
                continue;
            }
            outer.body()._return((JExpression)methodCall);
        }
        for (ClassGenerator<T> child : this.innerClasses.values()) {
            child.flushCode();
        }
    }

    public JCodeModel getModel() {
        return this.model;
    }

    public String getNextVar() {
        return "v" + this.index++;
    }

    public String getNextVar(String prefix) {
        return prefix + this.index++;
    }

    public JVar declareClassField(String prefix, JType t) {
        return this.declareClassField(prefix, t, null);
    }

    public JVar declareClassField(String prefix, JType t, JExpression init) {
        if (this.innerClassGenerator != null && this.hasMaxIndexValue()) {
            return this.innerClassGenerator.clazz.field(0, t, prefix + this.index++, init);
        }
        return this.clazz.field(0, t, prefix + this.index++, init);
    }

    public HoldingContainer declare(TypeProtos.MajorType t) {
        return this.declare(t, true);
    }

    public HoldingContainer declare(TypeProtos.MajorType t, boolean includeNewInstance) {
        JType holderType = this.getHolderType(t);
        JVar var = includeNewInstance ? this.getEvalBlock().decl(holderType, "out" + this.index, (JExpression)JExpr._new((JType)holderType)) : this.getEvalBlock().decl(holderType, "out" + this.index);
        JFieldRef outputSet = null;
        if (t.getMode() == TypeProtos.DataMode.OPTIONAL) {
            outputSet = var.ref("isSet");
        }
        ++this.index;
        return new HoldingContainer(t, var, var.ref("value"), outputSet);
    }

    public List<TypedFieldId> getWorkspaceTypes() {
        return this.workspaceTypes;
    }

    public Map<WorkspaceReference, JVar> getWorkspaceVectors() {
        return this.workspaceVectors;
    }

    public void preparePlainJava() {
        Constructor<?>[] ctors;
        Class baseClass = this.sig.getSignatureClass();
        this.clazz._extends(baseClass);
        for (Constructor<?> ctor : ctors = baseClass.getConstructors()) {
            this.addCtor(ctor.getParameterTypes());
        }
        if (ctors.length == 0) {
            this.addCtor(new Class[0]);
        }
        for (ClassGenerator<T> child : this.innerClasses.values()) {
            child.preparePlainJava();
            String innerClassName = child.clazz.name();
            JMethod shim = this.clazz.method(2, child.sig.getSignatureClass(), "new" + innerClassName);
            JInvocation childNew = JExpr._new((JClass)child.clazz);
            Constructor<?>[] childCtors = child.sig.getSignatureClass().getConstructors();
            Class[] params = childCtors.length == 0 ? new Class[]{} : childCtors[0].getParameterTypes();
            for (int i = 1; i < params.length; ++i) {
                Class p = params[i];
                childNew.arg((JExpression)shim.param(this.model._ref(p), "arg" + i));
            }
            shim.body()._return((JExpression)childNew);
        }
    }

    private void addCtor(Class<?>[] parameters) {
        JMethod ctor = this.clazz.constructor(1);
        JBlock body = ctor.body();
        if (parameters.length > 0) {
            JInvocation superCall = JExpr.invoke((String)"super");
            for (int i = 1; i < parameters.length; ++i) {
                Class<?> p = parameters[i];
                superCall.arg((JExpression)ctor.param(this.model._ref(p), "arg" + i));
            }
            body.add((JStatement)superCall);
        }
        JTryBlock tryBlock = body._try();
        tryBlock.body().invoke("__DRILL_INIT__");
        JCatchBlock catchBlock = tryBlock._catch(this.model.ref(SchemaChangeException.class));
        catchBlock.body()._throw((JExpression)JExpr._new((JClass)this.model.ref(UnsupportedOperationException.class)).arg((JExpression)catchBlock.param("e")));
    }

    public JType getHolderType(TypeProtos.MajorType t) {
        return TypeHelper.getHolderType(this.model, t.getMinorType(), t.getMode());
    }

    public static class HoldingContainer {
        private final JVar holder;
        private final JFieldRef value;
        private final JFieldRef isSet;
        private final TypeProtos.MajorType type;
        private boolean isConstant;
        private final boolean singularRepeated;
        private final boolean isReader;

        public HoldingContainer(TypeProtos.MajorType t, JVar holder, JFieldRef value, JFieldRef isSet) {
            this(t, holder, value, isSet, false, false);
        }

        public HoldingContainer(TypeProtos.MajorType t, JVar holder, JFieldRef value, JFieldRef isSet, boolean singularRepeated, boolean isReader) {
            this.holder = holder;
            this.value = value;
            this.isSet = isSet;
            this.type = t;
            this.isConstant = false;
            this.singularRepeated = singularRepeated;
            this.isReader = isReader;
        }

        public boolean isReader() {
            return this.isReader;
        }

        public boolean isSingularRepeated() {
            return this.singularRepeated;
        }

        public HoldingContainer setConstant(boolean isConstant) {
            this.isConstant = isConstant;
            return this;
        }

        public JFieldRef f(String name) {
            return this.holder.ref(name);
        }

        public boolean isConstant() {
            return this.isConstant;
        }

        public JVar getHolder() {
            return this.holder;
        }

        public JFieldRef getValue() {
            return this.value;
        }

        public TypeProtos.MajorType getMajorType() {
            return this.type;
        }

        public JFieldRef getIsSet() {
            Preconditions.checkNotNull(this.isSet, "You cannot access the isSet variable when operating on a non-nullable output value.");
            return this.isSet;
        }

        public boolean isOptional() {
            return this.type.getMode() == TypeProtos.DataMode.OPTIONAL;
        }

        public boolean isRepeated() {
            return this.type.getMode() == TypeProtos.DataMode.REPEATED;
        }

        public TypeProtos.MinorType getMinorType() {
            return this.type.getMinorType();
        }

        public String toString() {
            DebugStringBuilder buf = new DebugStringBuilder(this);
            if (this.isConstant()) {
                buf.append("const ");
            }
            buf.append(this.holder.type().fullName()).append(" ").append(this.holder.name()).append(", ").append(this.type.getMode().name()).append(" ").append(this.type.getMinorType().name()).append(", ");
            this.holder.generate(buf.formatter());
            buf.append(", ");
            this.value.generate(buf.formatter());
            return buf.toString();
        }
    }

    private static class ValueVectorSetup {
        final DirectExpression batch;
        final TypedFieldId fieldId;

        public ValueVectorSetup(DirectExpression batch, TypedFieldId fieldId) {
            this.batch = batch;
            this.fieldId = fieldId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.batch == null ? 0 : this.batch.hashCode());
            result = 31 * result + (this.fieldId == null ? 0 : this.fieldId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ValueVectorSetup other = (ValueVectorSetup)obj;
            if (this.batch == null ? other.batch != null : !this.batch.equals((Object)other.batch)) {
                return false;
            }
            return !(this.fieldId == null ? other.fieldId != null : !this.fieldId.equals(other.fieldId));
        }
    }

    public static enum BlkCreateMode {
        TRUE,
        FALSE,
        TRUE_IF_BOUND;

    }

    public static enum BlockType {
        SETUP,
        EVAL,
        RESET,
        CLEANUP;

    }
}

