/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oadd.org.apache.drill.exec.cache.VectorAccessibleSerializable;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.record.VectorAccessible;
import oadd.org.apache.drill.exec.record.VectorContainer;
import oadd.org.apache.drill.exec.record.WritableBatch;
import oadd.org.apache.drill.exec.record.selection.SelectionVector2;

public class VectorSerializer {
    public static Writer writer(BufferAllocator allocator, OutputStream stream) {
        return new Writer(allocator, stream);
    }

    public static Reader reader(BufferAllocator allocator, InputStream stream) {
        return new Reader(allocator, stream);
    }

    public static class Reader {
        private final InputStream stream;
        private long timeNs;
        private final VectorAccessibleSerializable vas;

        public Reader(BufferAllocator allocator, InputStream stream) {
            this.stream = stream;
            this.vas = new VectorAccessibleSerializable(allocator);
        }

        public VectorContainer read() throws IOException {
            this.vas.readFromStream(this.stream);
            this.timeNs = this.vas.getTimeNs();
            return this.vas.get();
        }

        public SelectionVector2 sv2() {
            return this.vas.getSv2();
        }

        public long timeNs() {
            return this.timeNs;
        }
    }

    public static class Writer {
        private final OutputStream stream;
        private final BufferAllocator allocator;
        private boolean retain;
        private long timeNs;

        public Writer(BufferAllocator allocator, OutputStream stream) {
            this.allocator = allocator;
            this.stream = stream;
        }

        public Writer retain() {
            this.retain = true;
            return this;
        }

        public Writer write(VectorAccessible va) throws IOException {
            return this.write(va, null);
        }

        public Writer write(VectorAccessible va, SelectionVector2 sv2) throws IOException {
            WritableBatch batch = WritableBatch.getBatchNoHVWrap(va.getRecordCount(), va, sv2 != null);
            return this.write(batch, sv2);
        }

        public Writer write(WritableBatch batch, SelectionVector2 sv2) throws IOException {
            VectorAccessibleSerializable vas = sv2 == null ? new VectorAccessibleSerializable(batch, this.allocator) : new VectorAccessibleSerializable(batch, sv2, this.allocator);
            if (this.retain) {
                vas.writeToStreamAndRetain(this.stream);
            } else {
                vas.writeToStream(this.stream);
            }
            this.timeNs += vas.getTimeNs();
            return this;
        }

        public long timeNs() {
            return this.timeNs;
        }
    }
}

