/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.util;

import java.math.BigDecimal;
import oadd.org.apache.drill.common.types.TypeProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreDecimalUtility {
    static final Logger logger = LoggerFactory.getLogger(CoreDecimalUtility.class);

    public static long getDecimal18FromBigDecimal(BigDecimal input, int scale, int precision) {
        input = input.setScale(scale, 4);
        return input.unscaledValue().longValue();
    }

    public static int getMaxPrecision(TypeProtos.MinorType decimalType) {
        if (decimalType == TypeProtos.MinorType.DECIMAL9) {
            return 9;
        }
        if (decimalType == TypeProtos.MinorType.DECIMAL18) {
            return 18;
        }
        if (decimalType == TypeProtos.MinorType.DECIMAL28SPARSE) {
            return 28;
        }
        if (decimalType == TypeProtos.MinorType.DECIMAL38SPARSE) {
            return 38;
        }
        return 0;
    }

    public static TypeProtos.MinorType getDecimalDataType(int precision) {
        if (precision <= 9) {
            return TypeProtos.MinorType.DECIMAL9;
        }
        if (precision <= 18) {
            return TypeProtos.MinorType.DECIMAL18;
        }
        if (precision <= 28) {
            return TypeProtos.MinorType.DECIMAL28SPARSE;
        }
        return TypeProtos.MinorType.DECIMAL38SPARSE;
    }

    public static int getPrecisionRange(int precision) {
        return CoreDecimalUtility.getMaxPrecision(CoreDecimalUtility.getDecimalDataType(precision));
    }

    public static int getDecimal9FromBigDecimal(BigDecimal input, int scale, int precision) {
        input = input.setScale(scale, 4);
        return input.unscaledValue().intValue();
    }

    public static boolean isDecimalType(TypeProtos.MajorType type) {
        return CoreDecimalUtility.isDecimalType(type.getMinorType());
    }

    public static boolean isDecimalType(TypeProtos.MinorType minorType) {
        return minorType == TypeProtos.MinorType.DECIMAL9 || minorType == TypeProtos.MinorType.DECIMAL18 || minorType == TypeProtos.MinorType.DECIMAL28SPARSE || minorType == TypeProtos.MinorType.DECIMAL38SPARSE;
    }
}

