/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.expression;

import java.io.IOException;
import java.util.Iterator;
import oadd.com.fasterxml.jackson.core.JsonParser;
import oadd.com.fasterxml.jackson.databind.DeserializationContext;
import oadd.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.collect.Iterators;
import oadd.org.antlr.runtime.ANTLRStringStream;
import oadd.org.antlr.runtime.CommonTokenStream;
import oadd.org.antlr.runtime.RecognitionException;
import oadd.org.apache.drill.common.expression.ExpressionPosition;
import oadd.org.apache.drill.common.expression.ExpressionStringBuilder;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.LogicalExpressionBase;
import oadd.org.apache.drill.common.expression.PathSegment;
import oadd.org.apache.drill.common.expression.parser.ExprLexer;
import oadd.org.apache.drill.common.expression.parser.ExprParser;
import oadd.org.apache.drill.common.expression.visitors.ExprVisitor;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.proto.UserBitShared;

public class SchemaPath
extends LogicalExpressionBase {
    private final PathSegment.NameSegment rootSegment;

    public static SchemaPath getSimplePath(String name) {
        return SchemaPath.getCompoundPath(name);
    }

    public static SchemaPath getCompoundPath(String ... strings) {
        PathSegment.NameSegment s = null;
        for (int i = strings.length - 1; i >= 0; --i) {
            s = new PathSegment.NameSegment(strings[i], s);
        }
        return new SchemaPath(s);
    }

    public PathSegment getLastSegment() {
        PathSegment s = this.rootSegment;
        while (s.getChild() != null) {
            s = s.getChild();
        }
        return s;
    }

    @Deprecated
    public SchemaPath(String simpleName, ExpressionPosition pos) {
        super(pos);
        this.rootSegment = new PathSegment.NameSegment(simpleName);
    }

    public UserBitShared.NamePart getAsNamePart() {
        return SchemaPath.getNamePart(this.rootSegment);
    }

    private static UserBitShared.NamePart getNamePart(PathSegment s) {
        if (s == null) {
            return null;
        }
        UserBitShared.NamePart.Builder b = UserBitShared.NamePart.newBuilder();
        if (s.getChild() != null) {
            b.setChild(SchemaPath.getNamePart(s.getChild()));
        }
        if (s.isArray()) {
            if (s.getArraySegment().hasIndex()) {
                throw new IllegalStateException("You cannot convert a indexed schema path to a NamePart.  NameParts can only reference Vectors, not individual records or values.");
            }
            b.setType(UserBitShared.NamePart.Type.ARRAY);
        } else {
            b.setType(UserBitShared.NamePart.Type.NAME);
            b.setName(s.getNameSegment().getPath());
        }
        return b.build();
    }

    private static PathSegment getPathSegment(UserBitShared.NamePart n) {
        PathSegment child;
        PathSegment pathSegment = child = n.hasChild() ? SchemaPath.getPathSegment(n.getChild()) : null;
        if (n.getType() == UserBitShared.NamePart.Type.ARRAY) {
            return new PathSegment.ArraySegment(child);
        }
        return new PathSegment.NameSegment(n.getName(), child);
    }

    public static SchemaPath create(UserBitShared.NamePart namePart) {
        Preconditions.checkArgument(namePart.getType() == UserBitShared.NamePart.Type.NAME);
        return new SchemaPath((PathSegment.NameSegment)SchemaPath.getPathSegment(namePart));
    }

    public static SchemaPath parseFromString(String expr) {
        if (expr == null || expr.isEmpty()) {
            return null;
        }
        try {
            ExprLexer lexer = new ExprLexer(new ANTLRStringStream(expr));
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            ExprParser parser = new ExprParser(tokens);
            ExprParser.parse_return ret = parser.parse();
            if (ret.e instanceof SchemaPath) {
                return (SchemaPath)ret.e;
            }
            throw new IllegalStateException("Schema path is not a valid format.");
        }
        catch (RecognitionException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isSimplePath() {
        for (PathSegment seg = this.rootSegment; seg != null; seg = seg.getChild()) {
            if (!((PathSegment)seg).isArray() || seg.isLastPath()) continue;
            return false;
        }
        return true;
    }

    public SchemaPath(SchemaPath path) {
        super(path.getPosition());
        this.rootSegment = path.rootSegment;
    }

    public SchemaPath(PathSegment.NameSegment rootSegment) {
        super(ExpressionPosition.UNKNOWN);
        this.rootSegment = rootSegment;
    }

    public SchemaPath(PathSegment.NameSegment rootSegment, ExpressionPosition pos) {
        super(pos);
        this.rootSegment = rootSegment;
    }

    @Override
    public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
        return visitor.visitSchemaPath(this, value);
    }

    public SchemaPath getChild(String childPath) {
        PathSegment.NameSegment newRoot = this.rootSegment.cloneWithNewChild(new PathSegment.NameSegment(childPath));
        return new SchemaPath(newRoot);
    }

    public SchemaPath getUnindexedArrayChild() {
        PathSegment.NameSegment newRoot = this.rootSegment.cloneWithNewChild(new PathSegment.ArraySegment(null));
        return new SchemaPath(newRoot);
    }

    public SchemaPath getChild(int index) {
        PathSegment.NameSegment newRoot = this.rootSegment.cloneWithNewChild(new PathSegment.ArraySegment(index));
        return new SchemaPath(newRoot);
    }

    public PathSegment.NameSegment getRootSegment() {
        return this.rootSegment;
    }

    @Override
    public TypeProtos.MajorType getMajorType() {
        return Types.LATE_BIND_TYPE;
    }

    public int hashCode() {
        return this.rootSegment == null ? 0 : this.rootSegment.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaPath)) {
            return false;
        }
        SchemaPath other = (SchemaPath)obj;
        if (this.rootSegment == null) {
            return other.rootSegment == null;
        }
        return this.rootSegment.equals(other.rootSegment);
    }

    public boolean contains(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaPath)) {
            return false;
        }
        SchemaPath other = (SchemaPath)obj;
        return this.rootSegment == null || this.rootSegment.contains(other.rootSegment);
    }

    @Override
    public Iterator<LogicalExpression> iterator() {
        return Iterators.emptyIterator();
    }

    public String toString() {
        return ExpressionStringBuilder.toString(this);
    }

    public String toExpr() {
        return ExpressionStringBuilder.toString(this);
    }

    public String getRootSegmentPath() {
        return this.rootSegment.getPath();
    }

    public static class De
    extends StdDeserializer<SchemaPath> {
        public De() {
            super(LogicalExpression.class);
        }

        @Override
        public SchemaPath deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            return SchemaPath.parseFromString(jp.getText());
        }
    }
}

