/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.calcite.avatica.remote;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import oadd.org.apache.calcite.avatica.AvaticaUtils;
import oadd.org.apache.calcite.avatica.remote.JsonService;

public class RemoteService
extends JsonService {
    private final URL url;

    public RemoteService(URL url) {
        this.url = url;
    }

    @Override
    public String apply(String request) {
        try {
            HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            if (request.length() < 256) {
                connection.setRequestProperty("request", request);
            } else {
                try (DataOutputStream wr = new DataOutputStream(connection.getOutputStream());){
                    wr.writeBytes(request);
                    wr.flush();
                    wr.close();
                }
            }
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new RuntimeException("response code " + responseCode);
            }
            InputStream inputStream = connection.getInputStream();
            return AvaticaUtils.readFully(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

