/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.calcite.avatica;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import oadd.org.apache.calcite.avatica.AvaticaConnection;
import oadd.org.apache.calcite.avatica.AvaticaParameter;
import oadd.org.apache.calcite.avatica.AvaticaSite;
import oadd.org.apache.calcite.avatica.AvaticaStatement;
import oadd.org.apache.calcite.avatica.Meta;
import oadd.org.apache.calcite.avatica.remote.TypedValue;

public abstract class AvaticaPreparedStatement
extends AvaticaStatement
implements PreparedStatement,
ParameterMetaData {
    private Meta.Signature signature;
    private final ResultSetMetaData resultSetMetaData;
    private Calendar calendar;
    protected final TypedValue[] slots;

    protected AvaticaPreparedStatement(AvaticaConnection connection, Meta.StatementHandle h, Meta.Signature signature, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(connection, h, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.signature = signature;
        this.slots = new TypedValue[signature.parameters.size()];
        this.resultSetMetaData = connection.factory.newResultSetMetaData(this, signature);
    }

    @Override
    protected List<TypedValue> getParameterValues() {
        return Arrays.asList(this.slots);
    }

    protected synchronized Calendar getCalendar() {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance(this.connection.getTimeZone());
        }
        return this.calendar;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.getConnection().executeQueryInternal(this, this.signature, null);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this;
    }

    @Override
    public final int executeUpdate() throws SQLException {
        return (int)this.executeLargeUpdate();
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.getConnection().executeQueryInternal(this, this.signature, null);
        return this.updateCount;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.getSite(parameterIndex).setNull(sqlType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.getSite(parameterIndex).setBoolean(x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.getSite(parameterIndex).setByte(x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.getSite(parameterIndex).setShort(x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.getSite(parameterIndex).setInt(x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.getSite(parameterIndex).setLong(x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.getSite(parameterIndex).setFloat(x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.getSite(parameterIndex).setDouble(x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.getSite(parameterIndex).setBigDecimal(x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.getSite(parameterIndex).setString(x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.getSite(parameterIndex).setBytes(x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getSite(parameterIndex).setAsciiStream(x, length);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getSite(parameterIndex).setUnicodeStream(x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getSite(parameterIndex).setBinaryStream(x, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = null;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.getSite(parameterIndex).setObject(x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.getSite(parameterIndex).setObject(x);
    }

    @Override
    public boolean execute() throws SQLException {
        this.getConnection().executeQueryInternal(this, this.signature, null);
        return this.openResultSet != null && !this.openResultSet.isClosed();
    }

    @Override
    public void addBatch() throws SQLException {
        throw this.connection.helper.unsupported();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.getSite(parameterIndex).setCharacterStream(reader, length);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.getSite(parameterIndex).setRef(x);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.getSite(parameterIndex).setBlob(x);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.getSite(parameterIndex).setClob(x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.getSite(parameterIndex).setArray(x);
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return this.resultSetMetaData;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar calendar) throws SQLException {
        this.getSite(parameterIndex).setDate(x, calendar);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, this.getCalendar());
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar calendar) throws SQLException {
        this.getSite(parameterIndex).setTime(x, calendar);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, this.getCalendar());
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar calendar) throws SQLException {
        this.getSite(parameterIndex).setTimestamp(x, calendar);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestamp(parameterIndex, x, this.getCalendar());
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.getSite(parameterIndex).setNull(sqlType, typeName);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.getSite(parameterIndex).setURL(x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.getSite(parameterIndex).setObject(x, targetSqlType, scaleOrLength);
    }

    protected AvaticaParameter getParameter(int param) throws SQLException {
        try {
            return this.signature.parameters.get(param - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.connection.helper.toSQLException(this.connection.helper.createException("parameter ordinal " + param + " out of range"));
        }
    }

    protected AvaticaSite getSite(int param) throws SQLException {
        AvaticaParameter parameter = this.getParameter(param);
        return new AvaticaSite(parameter, this.getCalendar(), param - 1, this.slots);
    }

    @Override
    public int getParameterCount() {
        return this.signature.parameters.size();
    }

    @Override
    public int isNullable(int param) throws SQLException {
        return 2;
    }

    @Override
    public boolean isSigned(int index) throws SQLException {
        return this.getParameter((int)index).signed;
    }

    @Override
    public int getPrecision(int index) throws SQLException {
        return this.getParameter((int)index).precision;
    }

    @Override
    public int getScale(int index) throws SQLException {
        return this.getParameter((int)index).scale;
    }

    @Override
    public int getParameterType(int index) throws SQLException {
        return this.getParameter((int)index).parameterType;
    }

    @Override
    public String getParameterTypeName(int index) throws SQLException {
        return this.getParameter((int)index).typeName;
    }

    @Override
    public String getParameterClassName(int index) throws SQLException {
        return this.getParameter((int)index).className;
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        AvaticaParameter paramDef = this.getParameter(param);
        return 1;
    }
}

