/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.fasterxml.jackson.databind.cfg;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Locale;
import java.util.TimeZone;
import oadd.com.fasterxml.jackson.annotation.JsonFormat;
import oadd.com.fasterxml.jackson.annotation.JsonInclude;
import oadd.com.fasterxml.jackson.core.Base64Variant;
import oadd.com.fasterxml.jackson.core.SerializableString;
import oadd.com.fasterxml.jackson.core.io.SerializedString;
import oadd.com.fasterxml.jackson.core.type.TypeReference;
import oadd.com.fasterxml.jackson.databind.AnnotationIntrospector;
import oadd.com.fasterxml.jackson.databind.BeanDescription;
import oadd.com.fasterxml.jackson.databind.JavaType;
import oadd.com.fasterxml.jackson.databind.MapperFeature;
import oadd.com.fasterxml.jackson.databind.PropertyName;
import oadd.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import oadd.com.fasterxml.jackson.databind.cfg.BaseSettings;
import oadd.com.fasterxml.jackson.databind.cfg.ConfigFeature;
import oadd.com.fasterxml.jackson.databind.cfg.ContextAttributes;
import oadd.com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import oadd.com.fasterxml.jackson.databind.introspect.Annotated;
import oadd.com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import oadd.com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import oadd.com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import oadd.com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import oadd.com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import oadd.com.fasterxml.jackson.databind.type.TypeFactory;
import oadd.com.fasterxml.jackson.databind.util.ClassUtil;

public abstract class MapperConfig<T extends MapperConfig<T>>
implements ClassIntrospector.MixInResolver,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final JsonInclude.Value EMPTY_INCLUDE = JsonInclude.Value.empty();
    protected static final JsonFormat.Value EMPTY_FORMAT = JsonFormat.Value.empty();
    protected final int _mapperFeatures;
    protected final BaseSettings _base;

    protected MapperConfig(BaseSettings base, int mapperFeatures) {
        this._base = base;
        this._mapperFeatures = mapperFeatures;
    }

    protected MapperConfig(MapperConfig<T> src, int mapperFeatures) {
        this._base = src._base;
        this._mapperFeatures = mapperFeatures;
    }

    protected MapperConfig(MapperConfig<T> src, BaseSettings base) {
        this._base = base;
        this._mapperFeatures = src._mapperFeatures;
    }

    protected MapperConfig(MapperConfig<T> src) {
        this._base = src._base;
        this._mapperFeatures = src._mapperFeatures;
    }

    public static <F extends Enum<F>> int collectFeatureDefaults(Class<F> enumClass) {
        int flags = 0;
        for (Enum value : (Enum[])enumClass.getEnumConstants()) {
            if (!((ConfigFeature)((Object)value)).enabledByDefault()) continue;
            flags |= ((ConfigFeature)((Object)value)).getMask();
        }
        return flags;
    }

    public abstract T with(MapperFeature ... var1);

    public abstract T without(MapperFeature ... var1);

    public abstract T with(MapperFeature var1, boolean var2);

    public final boolean isEnabled(MapperFeature f) {
        return (this._mapperFeatures & f.getMask()) != 0;
    }

    public final boolean hasMapperFeatures(int featureMask) {
        return (this._mapperFeatures & featureMask) == featureMask;
    }

    public final boolean isAnnotationProcessingEnabled() {
        return this.isEnabled(MapperFeature.USE_ANNOTATIONS);
    }

    public final boolean canOverrideAccessModifiers() {
        return this.isEnabled(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS);
    }

    public final boolean shouldSortPropertiesAlphabetically() {
        return this.isEnabled(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY);
    }

    public abstract boolean useRootWrapping();

    public SerializableString compileString(String src) {
        return new SerializedString(src);
    }

    public ClassIntrospector getClassIntrospector() {
        return this._base.getClassIntrospector();
    }

    public AnnotationIntrospector getAnnotationIntrospector() {
        return this._base.getAnnotationIntrospector();
    }

    public VisibilityChecker<?> getDefaultVisibilityChecker() {
        return this._base.getVisibilityChecker();
    }

    public final PropertyNamingStrategy getPropertyNamingStrategy() {
        return this._base.getPropertyNamingStrategy();
    }

    public final HandlerInstantiator getHandlerInstantiator() {
        return this._base.getHandlerInstantiator();
    }

    public final TypeResolverBuilder<?> getDefaultTyper(JavaType baseType) {
        return this._base.getTypeResolverBuilder();
    }

    public abstract SubtypeResolver getSubtypeResolver();

    public final TypeFactory getTypeFactory() {
        return this._base.getTypeFactory();
    }

    public final JavaType constructType(Class<?> cls) {
        return this.getTypeFactory().constructType(cls);
    }

    public final JavaType constructType(TypeReference<?> valueTypeRef) {
        return this.getTypeFactory().constructType(valueTypeRef.getType());
    }

    public JavaType constructSpecializedType(JavaType baseType, Class<?> subclass) {
        return this.getTypeFactory().constructSpecializedType(baseType, subclass);
    }

    public BeanDescription introspectClassAnnotations(Class<?> cls) {
        return this.introspectClassAnnotations(this.constructType(cls));
    }

    public abstract BeanDescription introspectClassAnnotations(JavaType var1);

    public BeanDescription introspectDirectClassAnnotations(Class<?> cls) {
        return this.introspectDirectClassAnnotations(this.constructType(cls));
    }

    public abstract BeanDescription introspectDirectClassAnnotations(JavaType var1);

    public abstract JsonInclude.Value getDefaultPropertyInclusion();

    public abstract JsonInclude.Value getDefaultPropertyInclusion(Class<?> var1);

    public abstract JsonFormat.Value getDefaultPropertyFormat(Class<?> var1);

    public final DateFormat getDateFormat() {
        return this._base.getDateFormat();
    }

    public final Locale getLocale() {
        return this._base.getLocale();
    }

    public final TimeZone getTimeZone() {
        return this._base.getTimeZone();
    }

    public abstract Class<?> getActiveView();

    public Base64Variant getBase64Variant() {
        return this._base.getBase64Variant();
    }

    public abstract ContextAttributes getAttributes();

    public abstract PropertyName findRootName(JavaType var1);

    public abstract PropertyName findRootName(Class<?> var1);

    public TypeResolverBuilder<?> typeResolverBuilderInstance(Annotated annotated, Class<? extends TypeResolverBuilder<?>> builderClass) {
        TypeResolverBuilder<?> builder;
        HandlerInstantiator hi = this.getHandlerInstantiator();
        if (hi != null && (builder = hi.typeResolverBuilderInstance(this, annotated, builderClass)) != null) {
            return builder;
        }
        return ClassUtil.createInstance(builderClass, this.canOverrideAccessModifiers());
    }

    public TypeIdResolver typeIdResolverInstance(Annotated annotated, Class<? extends TypeIdResolver> resolverClass) {
        TypeIdResolver builder;
        HandlerInstantiator hi = this.getHandlerInstantiator();
        if (hi != null && (builder = hi.typeIdResolverInstance(this, annotated, resolverClass)) != null) {
            return builder;
        }
        return ClassUtil.createInstance(resolverClass, this.canOverrideAccessModifiers());
    }
}

