/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.codahale.metrics.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oadd.com.codahale.metrics.servlets.HealthCheckServlet;
import oadd.com.codahale.metrics.servlets.MetricsServlet;
import oadd.com.codahale.metrics.servlets.PingServlet;
import oadd.com.codahale.metrics.servlets.ThreadDumpServlet;

public class AdminServlet
extends HttpServlet {
    public static final String DEFAULT_HEALTHCHECK_URI = "/healthcheck";
    public static final String DEFAULT_METRICS_URI = "/metrics";
    public static final String DEFAULT_PING_URI = "/ping";
    public static final String DEFAULT_THREADS_URI = "/threads";
    private static final String TEMPLATE = String.format("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"%n        \"http://www.w3.org/TR/html4/loose.dtd\">%n<html>%n<head>%n  <title>Metrics{8}</title>%n</head>%n<body>%n  <h1>Operational Menu{8}</h1>%n  <ul>%n    <li><a href=\"{0}{1}?pretty=true\">Metrics</a></li>%n    <li><a href=\"{2}{3}\">Ping</a></li>%n    <li><a href=\"{4}{5}\">Threads</a></li>%n    <li><a href=\"{6}{7}\">Healthcheck</a></li>%n  </ul>%n</body>%n</html>", new Object[0]);
    private static final String CONTENT_TYPE = "text/html";
    private static final long serialVersionUID = -2850794040708785318L;
    private transient HealthCheckServlet healthCheckServlet;
    private transient MetricsServlet metricsServlet;
    private transient PingServlet pingServlet;
    private transient ThreadDumpServlet threadDumpServlet;
    private transient String metricsUri;
    private transient String pingUri;
    private transient String threadsUri;
    private transient String healthcheckUri;
    private transient String serviceName;

    public void init(ServletConfig config) throws ServletException {
        this.healthCheckServlet = new HealthCheckServlet();
        this.healthCheckServlet.init(config);
        this.metricsServlet = new MetricsServlet();
        this.metricsServlet.init(config);
        this.pingServlet = new PingServlet();
        this.pingServlet.init(config);
        this.threadDumpServlet = new ThreadDumpServlet();
        this.threadDumpServlet.init(config);
        this.metricsUri = AdminServlet.getParam(config.getInitParameter("metrics-uri"), DEFAULT_METRICS_URI);
        this.pingUri = AdminServlet.getParam(config.getInitParameter("ping-uri"), DEFAULT_PING_URI);
        this.threadsUri = AdminServlet.getParam(config.getInitParameter("threads-uri"), DEFAULT_THREADS_URI);
        this.healthcheckUri = AdminServlet.getParam(config.getInitParameter("healthcheck-uri"), DEFAULT_HEALTHCHECK_URI);
        this.serviceName = AdminServlet.getParam(config.getInitParameter("service-name"), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getContextPath() + req.getServletPath();
        resp.setStatus(200);
        resp.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        resp.setContentType(CONTENT_TYPE);
        PrintWriter writer = resp.getWriter();
        try {
            writer.println(MessageFormat.format(TEMPLATE, path, this.metricsUri, path, this.pingUri, path, this.threadsUri, path, this.healthcheckUri, this.serviceName == null ? "" : " (" + this.serviceName + ")"));
        }
        finally {
            writer.close();
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String uri = req.getPathInfo();
        if (uri == null || uri.equals("/")) {
            super.service(req, resp);
        } else if (uri.equals(this.healthcheckUri)) {
            this.healthCheckServlet.service((ServletRequest)req, (ServletResponse)resp);
        } else if (uri.startsWith(this.metricsUri)) {
            this.metricsServlet.service((ServletRequest)req, (ServletResponse)resp);
        } else if (uri.equals(this.pingUri)) {
            this.pingServlet.service((ServletRequest)req, (ServletResponse)resp);
        } else if (uri.equals(this.threadsUri)) {
            this.threadDumpServlet.service((ServletRequest)req, (ServletResponse)resp);
        } else {
            resp.sendError(404);
        }
    }

    private static String getParam(String initParam, String defaultValue) {
        return initParam == null ? defaultValue : initParam;
    }
}

