
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;

/*
 * This class is generated using freemarker and the DateIntervalFunctionTemplates/TimestampDiffFunction.java template.
 */

public class GTimestampDiff {



  @FunctionTemplate(name = "timestampdiffNanosecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffNanosecondDateToDate implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) * 1_000_000;
    }
  }

  @FunctionTemplate(name = "timestampdiffNanosecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffNanosecondDateToTimeStamp implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) * 1_000_000;
    }
  }

  @FunctionTemplate(name = "timestampdiffNanosecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffNanosecondDateToTime implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) * 1_000_000;
    }
  }

  @FunctionTemplate(name = "timestampdiffNanosecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffNanosecondTimeStampToDate implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) * 1_000_000;
    }
  }

  @FunctionTemplate(name = "timestampdiffNanosecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffNanosecondTimeStampToTimeStamp implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) * 1_000_000;
    }
  }

  @FunctionTemplate(name = "timestampdiffNanosecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffNanosecondTimeStampToTime implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) * 1_000_000;
    }
  }

  @FunctionTemplate(name = "timestampdiffNanosecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffNanosecondTimeToDate implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) * 1_000_000;
    }
  }

  @FunctionTemplate(name = "timestampdiffNanosecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffNanosecondTimeToTimeStamp implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) * 1_000_000;
    }
  }

  @FunctionTemplate(name = "timestampdiffNanosecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffNanosecondTimeToTime implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) * 1_000_000;
    }
  }



  @FunctionTemplate(name = "timestampdiffMicrosecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMicrosecondDateToDate implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) * 1_000;
    }
  }

  @FunctionTemplate(name = "timestampdiffMicrosecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMicrosecondDateToTimeStamp implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) * 1_000;
    }
  }

  @FunctionTemplate(name = "timestampdiffMicrosecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMicrosecondDateToTime implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) * 1_000;
    }
  }

  @FunctionTemplate(name = "timestampdiffMicrosecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMicrosecondTimeStampToDate implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) * 1_000;
    }
  }

  @FunctionTemplate(name = "timestampdiffMicrosecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMicrosecondTimeStampToTimeStamp implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) * 1_000;
    }
  }

  @FunctionTemplate(name = "timestampdiffMicrosecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMicrosecondTimeStampToTime implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) * 1_000;
    }
  }

  @FunctionTemplate(name = "timestampdiffMicrosecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMicrosecondTimeToDate implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) * 1_000;
    }
  }

  @FunctionTemplate(name = "timestampdiffMicrosecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMicrosecondTimeToTimeStamp implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) * 1_000;
    }
  }

  @FunctionTemplate(name = "timestampdiffMicrosecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMicrosecondTimeToTime implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) * 1_000;
    }
  }



  @FunctionTemplate(name = "timestampdiffMillisecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMillisecondDateToDate implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = right.value - left.value;
    }
  }

  @FunctionTemplate(name = "timestampdiffMillisecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMillisecondDateToTimeStamp implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = right.value - left.value;
    }
  }

  @FunctionTemplate(name = "timestampdiffMillisecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMillisecondDateToTime implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = right.value - left.value;
    }
  }

  @FunctionTemplate(name = "timestampdiffMillisecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMillisecondTimeStampToDate implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = right.value - left.value;
    }
  }

  @FunctionTemplate(name = "timestampdiffMillisecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMillisecondTimeStampToTimeStamp implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = right.value - left.value;
    }
  }

  @FunctionTemplate(name = "timestampdiffMillisecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMillisecondTimeStampToTime implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = right.value - left.value;
    }
  }

  @FunctionTemplate(name = "timestampdiffMillisecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMillisecondTimeToDate implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = right.value - left.value;
    }
  }

  @FunctionTemplate(name = "timestampdiffMillisecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMillisecondTimeToTimeStamp implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = right.value - left.value;
    }
  }

  @FunctionTemplate(name = "timestampdiffMillisecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMillisecondTimeToTime implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = right.value - left.value;
    }
  }



  @FunctionTemplate(name = "timestampdiffSecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffSecondDateToDate implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.secondsToMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffSecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffSecondDateToTimeStamp implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.secondsToMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffSecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffSecondDateToTime implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.secondsToMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffSecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffSecondTimeStampToDate implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.secondsToMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffSecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffSecondTimeStampToTimeStamp implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.secondsToMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffSecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffSecondTimeStampToTime implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.secondsToMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffSecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffSecondTimeToDate implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.secondsToMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffSecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffSecondTimeToTimeStamp implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.secondsToMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffSecond",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffSecondTimeToTime implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.secondsToMillis;
    }
  }



  @FunctionTemplate(name = "timestampdiffMinute",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMinuteDateToDate implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.minutesToMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffMinute",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMinuteDateToTimeStamp implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.minutesToMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffMinute",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMinuteDateToTime implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.minutesToMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffMinute",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMinuteTimeStampToDate implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.minutesToMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffMinute",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMinuteTimeStampToTimeStamp implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.minutesToMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffMinute",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMinuteTimeStampToTime implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.minutesToMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffMinute",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMinuteTimeToDate implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.minutesToMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffMinute",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMinuteTimeToTimeStamp implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.minutesToMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffMinute",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMinuteTimeToTime implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.minutesToMillis;
    }
  }



  @FunctionTemplate(name = "timestampdiffHour",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffHourDateToDate implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.hoursToMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffHour",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffHourDateToTimeStamp implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.hoursToMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffHour",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffHourDateToTime implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.hoursToMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffHour",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffHourTimeStampToDate implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.hoursToMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffHour",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffHourTimeStampToTimeStamp implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.hoursToMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffHour",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffHourTimeStampToTime implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.hoursToMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffHour",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffHourTimeToDate implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.hoursToMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffHour",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffHourTimeToTimeStamp implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.hoursToMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffHour",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffHourTimeToTime implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.hoursToMillis;
    }
  }



  @FunctionTemplate(name = "timestampdiffDay",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffDayDateToDate implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.daysToStandardMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffDay",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffDayDateToTimeStamp implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.daysToStandardMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffDay",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffDayDateToTime implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.daysToStandardMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffDay",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffDayTimeStampToDate implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.daysToStandardMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffDay",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffDayTimeStampToTimeStamp implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.daysToStandardMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffDay",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffDayTimeStampToTime implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.daysToStandardMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffDay",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffDayTimeToDate implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.daysToStandardMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffDay",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffDayTimeToTimeStamp implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.daysToStandardMillis;
    }
  }

  @FunctionTemplate(name = "timestampdiffDay",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffDayTimeToTime implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / org.apache.drill.exec.vector.DateUtilities.daysToStandardMillis;
    }
  }



  @FunctionTemplate(name = "timestampdiffMonth",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMonthDateToDate implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {

      java.time.LocalDateTime from = java.time.Instant.ofEpochMilli(left.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();
      java.time.LocalDateTime to = java.time.Instant.ofEpochMilli(right.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();

      int months = (int) from.until(to, java.time.temporal.ChronoUnit.MONTHS);

      out.value = months;
    }
  }

  @FunctionTemplate(name = "timestampdiffMonth",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMonthDateToTimeStamp implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {

      java.time.LocalDateTime from = java.time.Instant.ofEpochMilli(left.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();
      java.time.LocalDateTime to = java.time.Instant.ofEpochMilli(right.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();

      int months = (int) from.until(to, java.time.temporal.ChronoUnit.MONTHS);

      out.value = months;
    }
  }

  @FunctionTemplate(name = "timestampdiffMonth",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMonthDateToTime implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {

      java.time.LocalDateTime from = java.time.Instant.ofEpochMilli(left.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();
      java.time.LocalDateTime to = java.time.Instant.ofEpochMilli(right.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();

      int months = (int) from.until(to, java.time.temporal.ChronoUnit.MONTHS);

      out.value = months;
    }
  }

  @FunctionTemplate(name = "timestampdiffMonth",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMonthTimeStampToDate implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {

      java.time.LocalDateTime from = java.time.Instant.ofEpochMilli(left.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();
      java.time.LocalDateTime to = java.time.Instant.ofEpochMilli(right.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();

      int months = (int) from.until(to, java.time.temporal.ChronoUnit.MONTHS);

      out.value = months;
    }
  }

  @FunctionTemplate(name = "timestampdiffMonth",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMonthTimeStampToTimeStamp implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {

      java.time.LocalDateTime from = java.time.Instant.ofEpochMilli(left.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();
      java.time.LocalDateTime to = java.time.Instant.ofEpochMilli(right.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();

      int months = (int) from.until(to, java.time.temporal.ChronoUnit.MONTHS);

      out.value = months;
    }
  }

  @FunctionTemplate(name = "timestampdiffMonth",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMonthTimeStampToTime implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {

      java.time.LocalDateTime from = java.time.Instant.ofEpochMilli(left.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();
      java.time.LocalDateTime to = java.time.Instant.ofEpochMilli(right.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();

      int months = (int) from.until(to, java.time.temporal.ChronoUnit.MONTHS);

      out.value = months;
    }
  }

  @FunctionTemplate(name = "timestampdiffMonth",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMonthTimeToDate implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {

      java.time.LocalDateTime from = java.time.Instant.ofEpochMilli(left.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();
      java.time.LocalDateTime to = java.time.Instant.ofEpochMilli(right.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();

      int months = (int) from.until(to, java.time.temporal.ChronoUnit.MONTHS);

      out.value = months;
    }
  }

  @FunctionTemplate(name = "timestampdiffMonth",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMonthTimeToTimeStamp implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {

      java.time.LocalDateTime from = java.time.Instant.ofEpochMilli(left.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();
      java.time.LocalDateTime to = java.time.Instant.ofEpochMilli(right.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();

      int months = (int) from.until(to, java.time.temporal.ChronoUnit.MONTHS);

      out.value = months;
    }
  }

  @FunctionTemplate(name = "timestampdiffMonth",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffMonthTimeToTime implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {

      java.time.LocalDateTime from = java.time.Instant.ofEpochMilli(left.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();
      java.time.LocalDateTime to = java.time.Instant.ofEpochMilli(right.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();

      int months = (int) from.until(to, java.time.temporal.ChronoUnit.MONTHS);

      out.value = months;
    }
  }



  @FunctionTemplate(name = "timestampdiffYear",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffYearDateToDate implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {

      java.time.LocalDateTime from = java.time.Instant.ofEpochMilli(left.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();
      java.time.LocalDateTime to = java.time.Instant.ofEpochMilli(right.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();

      int months = (int) from.until(to, java.time.temporal.ChronoUnit.MONTHS);

      out.value = months / org.apache.drill.exec.vector.DateUtilities.yearsToMonths;
    }
  }

  @FunctionTemplate(name = "timestampdiffYear",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffYearDateToTimeStamp implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {

      java.time.LocalDateTime from = java.time.Instant.ofEpochMilli(left.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();
      java.time.LocalDateTime to = java.time.Instant.ofEpochMilli(right.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();

      int months = (int) from.until(to, java.time.temporal.ChronoUnit.MONTHS);

      out.value = months / org.apache.drill.exec.vector.DateUtilities.yearsToMonths;
    }
  }

  @FunctionTemplate(name = "timestampdiffYear",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffYearDateToTime implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {

      java.time.LocalDateTime from = java.time.Instant.ofEpochMilli(left.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();
      java.time.LocalDateTime to = java.time.Instant.ofEpochMilli(right.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();

      int months = (int) from.until(to, java.time.temporal.ChronoUnit.MONTHS);

      out.value = months / org.apache.drill.exec.vector.DateUtilities.yearsToMonths;
    }
  }

  @FunctionTemplate(name = "timestampdiffYear",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffYearTimeStampToDate implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {

      java.time.LocalDateTime from = java.time.Instant.ofEpochMilli(left.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();
      java.time.LocalDateTime to = java.time.Instant.ofEpochMilli(right.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();

      int months = (int) from.until(to, java.time.temporal.ChronoUnit.MONTHS);

      out.value = months / org.apache.drill.exec.vector.DateUtilities.yearsToMonths;
    }
  }

  @FunctionTemplate(name = "timestampdiffYear",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffYearTimeStampToTimeStamp implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {

      java.time.LocalDateTime from = java.time.Instant.ofEpochMilli(left.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();
      java.time.LocalDateTime to = java.time.Instant.ofEpochMilli(right.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();

      int months = (int) from.until(to, java.time.temporal.ChronoUnit.MONTHS);

      out.value = months / org.apache.drill.exec.vector.DateUtilities.yearsToMonths;
    }
  }

  @FunctionTemplate(name = "timestampdiffYear",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffYearTimeStampToTime implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {

      java.time.LocalDateTime from = java.time.Instant.ofEpochMilli(left.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();
      java.time.LocalDateTime to = java.time.Instant.ofEpochMilli(right.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();

      int months = (int) from.until(to, java.time.temporal.ChronoUnit.MONTHS);

      out.value = months / org.apache.drill.exec.vector.DateUtilities.yearsToMonths;
    }
  }

  @FunctionTemplate(name = "timestampdiffYear",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffYearTimeToDate implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {

      java.time.LocalDateTime from = java.time.Instant.ofEpochMilli(left.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();
      java.time.LocalDateTime to = java.time.Instant.ofEpochMilli(right.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();

      int months = (int) from.until(to, java.time.temporal.ChronoUnit.MONTHS);

      out.value = months / org.apache.drill.exec.vector.DateUtilities.yearsToMonths;
    }
  }

  @FunctionTemplate(name = "timestampdiffYear",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffYearTimeToTimeStamp implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {

      java.time.LocalDateTime from = java.time.Instant.ofEpochMilli(left.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();
      java.time.LocalDateTime to = java.time.Instant.ofEpochMilli(right.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();

      int months = (int) from.until(to, java.time.temporal.ChronoUnit.MONTHS);

      out.value = months / org.apache.drill.exec.vector.DateUtilities.yearsToMonths;
    }
  }

  @FunctionTemplate(name = "timestampdiffYear",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffYearTimeToTime implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {

      java.time.LocalDateTime from = java.time.Instant.ofEpochMilli(left.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();
      java.time.LocalDateTime to = java.time.Instant.ofEpochMilli(right.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();

      int months = (int) from.until(to, java.time.temporal.ChronoUnit.MONTHS);

      out.value = months / org.apache.drill.exec.vector.DateUtilities.yearsToMonths;
    }
  }



  @FunctionTemplate(name = "timestampdiffWeek",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffWeekDateToDate implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / 604800000; // 7 * 24 * 60 * 60 * 1000
    }
  }

  @FunctionTemplate(name = "timestampdiffWeek",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffWeekDateToTimeStamp implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / 604800000; // 7 * 24 * 60 * 60 * 1000
    }
  }

  @FunctionTemplate(name = "timestampdiffWeek",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffWeekDateToTime implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / 604800000; // 7 * 24 * 60 * 60 * 1000
    }
  }

  @FunctionTemplate(name = "timestampdiffWeek",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffWeekTimeStampToDate implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / 604800000; // 7 * 24 * 60 * 60 * 1000
    }
  }

  @FunctionTemplate(name = "timestampdiffWeek",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffWeekTimeStampToTimeStamp implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / 604800000; // 7 * 24 * 60 * 60 * 1000
    }
  }

  @FunctionTemplate(name = "timestampdiffWeek",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffWeekTimeStampToTime implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / 604800000; // 7 * 24 * 60 * 60 * 1000
    }
  }

  @FunctionTemplate(name = "timestampdiffWeek",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffWeekTimeToDate implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / 604800000; // 7 * 24 * 60 * 60 * 1000
    }
  }

  @FunctionTemplate(name = "timestampdiffWeek",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffWeekTimeToTimeStamp implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / 604800000; // 7 * 24 * 60 * 60 * 1000
    }
  }

  @FunctionTemplate(name = "timestampdiffWeek",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffWeekTimeToTime implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {
      out.value = (right.value - left.value) / 604800000; // 7 * 24 * 60 * 60 * 1000
    }
  }



  @FunctionTemplate(name = "timestampdiffQuarter",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffQuarterDateToDate implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {

      java.time.LocalDateTime from = java.time.Instant.ofEpochMilli(left.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();
      java.time.LocalDateTime to = java.time.Instant.ofEpochMilli(right.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();

      int months = (int) from.until(to, java.time.temporal.ChronoUnit.MONTHS);

      // Quarter has 3 month
      out.value = months / 3;
    }
  }

  @FunctionTemplate(name = "timestampdiffQuarter",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffQuarterDateToTimeStamp implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {

      java.time.LocalDateTime from = java.time.Instant.ofEpochMilli(left.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();
      java.time.LocalDateTime to = java.time.Instant.ofEpochMilli(right.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();

      int months = (int) from.until(to, java.time.temporal.ChronoUnit.MONTHS);

      // Quarter has 3 month
      out.value = months / 3;
    }
  }

  @FunctionTemplate(name = "timestampdiffQuarter",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffQuarterDateToTime implements DrillSimpleFunc {

    @Param DateHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {

      java.time.LocalDateTime from = java.time.Instant.ofEpochMilli(left.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();
      java.time.LocalDateTime to = java.time.Instant.ofEpochMilli(right.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();

      int months = (int) from.until(to, java.time.temporal.ChronoUnit.MONTHS);

      // Quarter has 3 month
      out.value = months / 3;
    }
  }

  @FunctionTemplate(name = "timestampdiffQuarter",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffQuarterTimeStampToDate implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {

      java.time.LocalDateTime from = java.time.Instant.ofEpochMilli(left.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();
      java.time.LocalDateTime to = java.time.Instant.ofEpochMilli(right.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();

      int months = (int) from.until(to, java.time.temporal.ChronoUnit.MONTHS);

      // Quarter has 3 month
      out.value = months / 3;
    }
  }

  @FunctionTemplate(name = "timestampdiffQuarter",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffQuarterTimeStampToTimeStamp implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {

      java.time.LocalDateTime from = java.time.Instant.ofEpochMilli(left.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();
      java.time.LocalDateTime to = java.time.Instant.ofEpochMilli(right.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();

      int months = (int) from.until(to, java.time.temporal.ChronoUnit.MONTHS);

      // Quarter has 3 month
      out.value = months / 3;
    }
  }

  @FunctionTemplate(name = "timestampdiffQuarter",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffQuarterTimeStampToTime implements DrillSimpleFunc {

    @Param TimeStampHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {

      java.time.LocalDateTime from = java.time.Instant.ofEpochMilli(left.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();
      java.time.LocalDateTime to = java.time.Instant.ofEpochMilli(right.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();

      int months = (int) from.until(to, java.time.temporal.ChronoUnit.MONTHS);

      // Quarter has 3 month
      out.value = months / 3;
    }
  }

  @FunctionTemplate(name = "timestampdiffQuarter",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffQuarterTimeToDate implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param DateHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {

      java.time.LocalDateTime from = java.time.Instant.ofEpochMilli(left.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();
      java.time.LocalDateTime to = java.time.Instant.ofEpochMilli(right.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();

      int months = (int) from.until(to, java.time.temporal.ChronoUnit.MONTHS);

      // Quarter has 3 month
      out.value = months / 3;
    }
  }

  @FunctionTemplate(name = "timestampdiffQuarter",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffQuarterTimeToTimeStamp implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param TimeStampHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {

      java.time.LocalDateTime from = java.time.Instant.ofEpochMilli(left.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();
      java.time.LocalDateTime to = java.time.Instant.ofEpochMilli(right.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();

      int months = (int) from.until(to, java.time.temporal.ChronoUnit.MONTHS);

      // Quarter has 3 month
      out.value = months / 3;
    }
  }

  @FunctionTemplate(name = "timestampdiffQuarter",
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = FunctionTemplate.NullHandling.NULL_IF_NULL)
  public static class TimestampDiffQuarterTimeToTime implements DrillSimpleFunc {

    @Param TimeHolder left;
    @Param TimeHolder right;
    @Output BigIntHolder out;

    public void setup() {
    }

    public void eval() {

      java.time.LocalDateTime from = java.time.Instant.ofEpochMilli(left.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();
      java.time.LocalDateTime to = java.time.Instant.ofEpochMilli(right.value).atZone(java.time.ZoneOffset.UTC).toLocalDateTime();

      int months = (int) from.until(to, java.time.temporal.ChronoUnit.MONTHS);

      // Quarter has 3 month
      out.value = months / 3;
    }
  }

}
