
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.*;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
/*
 * This class is generated using freemarker and the ConvertToNullableHolder.java template.
 */

@FunctionTemplate(name = "convertToNullableDECIMAL28SPARSE",
    scope = FunctionTemplate.FunctionScope.SIMPLE,
    returnType = FunctionTemplate.ReturnType.DECIMAL_MAX_SCALE,
    nulls = FunctionTemplate.NullHandling.INTERNAL,
    isInternal = true)
public class GConvertToNullableDecimal28SparseHolder implements DrillSimpleFunc {

  @Param Decimal28SparseHolder input;
  @Output NullableDecimal28SparseHolder output;

  public void setup() { }

  public void eval() {
    output.isSet = 1;
    output.scale = input.scale;
    output.precision = input.precision;
    output.setSign(input.getSign(input.start, input.buffer), output.start, output.buffer);
    output.start = input.start;
    output.buffer = input.buffer;
  }
}


