/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.expression;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.LogicalExpressionBase;
import org.apache.drill.common.expression.visitors.ExprVisitor;
import org.apache.drill.common.types.TypeProtos;

public class FunctionCall
extends LogicalExpressionBase
implements Iterable<LogicalExpression> {
    private final String name;
    protected final ImmutableList<LogicalExpression> args;
    private final ExpressionPosition pos;

    public FunctionCall(String name, List<LogicalExpression> args, ExpressionPosition pos) {
        super(pos);
        this.name = name;
        if (args == null) {
            args = Lists.newArrayList();
        }
        if (!(args instanceof ImmutableList)) {
            args = ImmutableList.copyOf((Collection)args);
        }
        this.args = (ImmutableList)args;
        this.pos = pos;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public ExpressionPosition getPosition() {
        return this.pos;
    }

    public List<LogicalExpression> args() {
        return this.args;
    }

    public int argCount() {
        return this.args.size();
    }

    public LogicalExpression arg(int i) {
        return (LogicalExpression)this.args.get(i);
    }

    @Override
    public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
        return visitor.visitFunctionCall(this, value);
    }

    @Override
    public Iterator<LogicalExpression> iterator() {
        return this.args.iterator();
    }

    @Override
    public TypeProtos.MajorType getMajorType() {
        throw new UnsupportedOperationException("No return type as FunctionCall is not a materialized expression");
    }

    public String toString() {
        int maxLen = 10;
        return "FunctionCall [func=" + this.name + ", args=" + String.valueOf(this.args != null ? this.args.subList(0, Math.min(this.args.size(), 10)) : null) + ", pos=" + String.valueOf(this.pos) + "]";
    }
}

