/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.logical;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.logical.OAuthConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.shaded.guava.com.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonFormat(with={JsonFormat.Feature.ACCEPT_CASE_INSENSITIVE_PROPERTIES})
public abstract class StoragePluginConfig {
    Logger logger = LoggerFactory.getLogger(StoragePluginConfig.class);
    protected Boolean enabled;
    protected final boolean directCredentials;
    protected final CredentialsProvider credentialsProvider;
    protected final AuthMode authMode;
    protected OAuthConfig oAuthConfig;

    public StoragePluginConfig() {
        this(PlainCredentialsProvider.EMPTY_CREDENTIALS_PROVIDER, true);
    }

    public StoragePluginConfig(CredentialsProvider credentialsProvider, boolean directCredentials) {
        this(credentialsProvider, directCredentials, AuthMode.SHARED_USER);
    }

    public StoragePluginConfig(CredentialsProvider credentialsProvider, boolean directCredentials, AuthMode authMode) {
        this(credentialsProvider, directCredentials, authMode, null);
    }

    public StoragePluginConfig(CredentialsProvider credentialsProvider, boolean directCredentials, AuthMode authMode, OAuthConfig oAuthConfig) {
        this.credentialsProvider = credentialsProvider;
        this.directCredentials = directCredentials;
        this.authMode = authMode;
        this.oAuthConfig = oAuthConfig;
    }

    public boolean isEnabled() {
        return this.enabled != null && this.enabled != false;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @JsonIgnore
    public boolean isEnabledStatusPresent() {
        return this.enabled != null;
    }

    public String getValue(String key) {
        return null;
    }

    public CredentialsProvider getCredentialsProvider() {
        if (this.directCredentials) {
            return null;
        }
        return this.credentialsProvider;
    }

    public StoragePluginConfig updateCredentialProvider(CredentialsProvider credentialsProvider) {
        throw UserException.unsupportedError().message("%s does not support credential provider updates.", new Object[]{this.getClass()}).build(this.logger);
    }

    public AuthMode getAuthMode() {
        return this.authMode;
    }

    @JsonProperty(value="oAuthConfig")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OAuthConfig oAuthConfig() {
        return this.oAuthConfig;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public static enum AuthMode {
        SHARED_USER,
        USER_IMPERSONATION,
        USER_TRANSLATION;


        public static AuthMode parseOrDefault(String authMode, AuthMode defavlt) {
            return !Strings.isNullOrEmpty((String)authMode) ? AuthMode.valueOf(authMode.toUpperCase()) : defavlt;
        }
    }
}

