/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.util;

import java.text.MessageFormat;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.scopedpool.ScopedClassPoolRepository;
import javassist.scopedpool.ScopedClassPoolRepositoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufPatcher {
    private static final Logger logger = LoggerFactory.getLogger(ProtobufPatcher.class);
    private static final String protobufPackage = "com.google.protobuf.";
    private static boolean patchingAttempted = false;

    public static synchronized void patch() {
        if (!patchingAttempted) {
            patchingAttempted = true;
            ProtobufPatcher.patchByteString();
            ProtobufPatcher.patchGeneratedMessageLite();
            ProtobufPatcher.patchGeneratedMessageLiteBuilder();
        }
    }

    private static void patchByteString() {
        try {
            ClassPool classPool = ProtobufPatcher.getClassPool();
            CtClass byteString = classPool.get("com.google.protobuf.ByteString");
            ProtobufPatcher.removeFinal(byteString.getDeclaredMethod("toString"));
            ProtobufPatcher.removeFinal(byteString.getDeclaredMethod("hashCode"));
            ProtobufPatcher.removeFinal(byteString.getDeclaredMethod("iterator"));
            CtClass googleLiteralByteString = classPool.get("com.google.protobuf.ByteString$LiteralByteString");
            ProtobufPatcher.removePrivate(googleLiteralByteString);
            CtClass googleBoundedByteString = classPool.get("com.google.protobuf.ByteString$BoundedByteString");
            ProtobufPatcher.removePrivate(googleBoundedByteString);
            ProtobufPatcher.removeFinal(googleBoundedByteString);
            for (CtMethod ctMethod : googleLiteralByteString.getDeclaredMethods()) {
                ProtobufPatcher.removeFinal(ctMethod);
            }
            byteString.toClass();
            googleLiteralByteString.toClass();
            googleBoundedByteString.toClass();
            CtClass literalByteString = classPool.makeClass("com.google.protobuf.LiteralByteString");
            literalByteString.setSuperclass(googleLiteralByteString);
            literalByteString.toClass();
            CtClass boundedByteString = classPool.makeClass("com.google.protobuf.BoundedByteString");
            boundedByteString.setSuperclass(googleBoundedByteString);
            boundedByteString.toClass();
        }
        catch (Exception e) {
            logger.warn("Unable to patch Protobuf.", (Throwable)e);
        }
    }

    private static void patchGeneratedMessageLite() {
        try {
            ClassPool classPool = ProtobufPatcher.getClassPool();
            CtClass generatedMessageLite = classPool.get("com.google.protobuf.GeneratedMessageLite");
            ProtobufPatcher.removeFinal(generatedMessageLite.getDeclaredMethod("getParserForType"));
            ProtobufPatcher.removeFinal(generatedMessageLite.getDeclaredMethod("isInitialized"));
            generatedMessageLite.addMethod(CtNewMethod.make((String)"protected void makeExtensionsImmutable() { }", (CtClass)generatedMessageLite));
            String className = "com.google.protobuf.GeneratedMessageLite.Builder";
            generatedMessageLite.addConstructor(CtNewConstructor.make((String)("protected GeneratedMessageLite(" + className + " builder) { }"), (CtClass)generatedMessageLite));
            CtMethod dynamicMethod = generatedMessageLite.getDeclaredMethod("dynamicMethod", new CtClass[]{classPool.get("com.google.protobuf.GeneratedMessageLite$MethodToInvoke"), classPool.get("java.lang.Object"), classPool.get("java.lang.Object")});
            className = "com.google.protobuf.GeneratedMessageLite.MethodToInvoke";
            String dynamicMethodBody = MessageFormat.format("if ($1.equals({0}.GET_DEFAULT_INSTANCE)) '{'  return this;'}' else if ($1.equals({0}.BUILD_MESSAGE_INFO)) '{'   {1}StructuralMessageInfo.Builder builder = {1}StructuralMessageInfo.newBuilder();  builder.withSyntax({1}ProtoSyntax.PROTO2);  builder.withDefaultInstance(this);  return builder.build();'}' else '{'  return null;'}'", className, protobufPackage);
            ProtobufPatcher.addImplementation(dynamicMethod, dynamicMethodBody);
            generatedMessageLite.toClass();
        }
        catch (Exception e) {
            logger.warn("Unable to patch Protobuf.", (Throwable)e);
        }
    }

    private static void patchGeneratedMessageLiteBuilder() {
        try {
            ClassPool classPool = ProtobufPatcher.getClassPool();
            CtClass builder = classPool.get("com.google.protobuf.GeneratedMessageLite$Builder");
            ProtobufPatcher.removeFinal(builder.getDeclaredMethod("isInitialized"));
            ProtobufPatcher.removeFinal(builder.getDeclaredMethod("clear"));
            builder.addConstructor(CtNewConstructor.defaultConstructor((CtClass)builder));
            builder.toClass();
        }
        catch (Exception e) {
            logger.warn("Unable to patch Protobuf.", (Throwable)e);
        }
    }

    private static void removeFinal(CtMethod ctMethod) {
        int modifiers = Modifier.clear((int)ctMethod.getModifiers(), (int)16);
        ctMethod.setModifiers(modifiers);
    }

    private static void removeFinal(CtClass ctClass) {
        int modifiers = Modifier.clear((int)ctClass.getModifiers(), (int)16);
        ctClass.setModifiers(modifiers);
    }

    private static void removePrivate(CtClass ctClass) {
        int modifiers = Modifier.clear((int)ctClass.getModifiers(), (int)2);
        ctClass.setModifiers(modifiers);
    }

    private static void addImplementation(CtMethod ctMethod, String methodBody) throws CannotCompileException {
        ctMethod.setBody(methodBody);
        int modifiers = Modifier.clear((int)ctMethod.getModifiers(), (int)1024);
        ctMethod.setModifiers(modifiers);
    }

    private static ClassPool getClassPool() {
        ScopedClassPoolRepository classPoolRepository = ScopedClassPoolRepositoryImpl.getInstance();
        classPoolRepository.setPrune(false);
        return classPoolRepository.createScopedClassPool(ProtobufPatcher.class.getClassLoader(), null);
    }
}

