/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.exceptions;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.drill.exec.proto.CoordinationProtos;

class UserExceptionContext {
    private static final String NEW_LINE = System.lineSeparator();
    private final String errorId = UUID.randomUUID().toString();
    private final List<String> contextList = new ArrayList<String>();
    private CoordinationProtos.DrillbitEndpoint endpoint;

    UserExceptionContext() {
    }

    void add(String context) {
        this.contextList.add(context);
    }

    void add(CoordinationProtos.DrillbitEndpoint endpoint) {
        if (this.endpoint == null) {
            this.endpoint = endpoint;
        }
    }

    void add(String context, String value) {
        this.add(this.deColon(context) + ": " + value);
    }

    void add(String context, long value) {
        this.add(this.deColon(context) + ": " + value);
    }

    void add(String context, double value) {
        this.add(this.deColon(context) + ": " + value);
    }

    private String deColon(String context) {
        if ((context = context.trim()).endsWith(":")) {
            return context.substring(0, context.length() - 1);
        }
        return context;
    }

    void push(String context) {
        this.contextList.add(0, context);
    }

    void push(String context, String value) {
        this.push(this.deColon(context) + ": " + value);
    }

    void push(String context, long value) {
        this.push(this.deColon(context) + ": " + value);
    }

    void push(String context, double value) {
        this.push(this.deColon(context) + ": " + value);
    }

    String getErrorId() {
        return this.errorId;
    }

    CoordinationProtos.DrillbitEndpoint getEndpoint() {
        return this.endpoint;
    }

    String generateContextMessage(boolean includeErrorIdAndIdentity, boolean includeSeeLogsMessage) {
        StringBuilder sb = new StringBuilder();
        for (String context : this.contextList) {
            sb.append(context).append(NEW_LINE);
        }
        if (includeSeeLogsMessage) {
            sb.append(NEW_LINE).append("Please, refer to logs for more information.").append(NEW_LINE);
        }
        if (includeErrorIdAndIdentity) {
            sb.append(NEW_LINE).append("[Error Id: ").append(this.errorId).append(" ");
            if (this.endpoint != null) {
                sb.append("on ").append(this.endpoint.getAddress()).append(":").append(this.endpoint.getUserPort());
            }
            sb.append("]");
        }
        return sb.toString();
    }
}

