/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common;

import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.base.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeferredException
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(DeferredException.class);
    private Exception exception = null;
    private boolean isClosed = false;
    private final Supplier<Exception> exceptionSupplier;

    public DeferredException() {
        this(null);
    }

    public DeferredException(Supplier<Exception> exceptionSupplier) {
        this.exceptionSupplier = exceptionSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addException(Exception exception) {
        Preconditions.checkNotNull((Object)exception);
        DeferredException deferredException = this;
        synchronized (deferredException) {
            Preconditions.checkState((!this.isClosed ? 1 : 0) != 0);
            if (this.exception == null) {
                if (this.exceptionSupplier == null) {
                    this.exception = exception;
                } else {
                    this.exception = (Exception)this.exceptionSupplier.get();
                    if (this.exception == null) {
                        this.exception = new RuntimeException("Missing root exception");
                    }
                    this.exception.addSuppressed(exception);
                }
            } else {
                this.exception.addSuppressed(exception);
            }
        }
    }

    public void addThrowable(Throwable throwable) {
        Preconditions.checkNotNull((Object)throwable);
        if (throwable instanceof Exception) {
            this.addException((Exception)throwable);
            return;
        }
        this.addException(new RuntimeException(throwable));
    }

    public synchronized Exception getException() {
        return this.exception;
    }

    public synchronized Exception getAndClear() {
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0);
        if (this.exception != null) {
            Exception local = this.exception;
            this.exception = null;
            return local;
        }
        return null;
    }

    public synchronized void throwAndClear() throws Exception {
        Exception e = this.getAndClear();
        if (e != null) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suppressingClose(AutoCloseable autoCloseable) {
        DeferredException deferredException = this;
        synchronized (deferredException) {
            Preconditions.checkState((!this.isClosed ? 1 : 0) != 0);
            if (autoCloseable == null) {
                return;
            }
            try {
                autoCloseable.close();
            }
            catch (Exception e) {
                this.addException(e);
            }
        }
    }

    @Override
    public synchronized void close() throws Exception {
        try {
            this.throwAndClear();
        }
        finally {
            this.isClosed = true;
        }
    }
}

