/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.drill.common.util.GuavaPatcher;
import org.apache.drill.test.BaseTest;
import org.junit.Assert;
import org.junit.Test;

public class TestGuavaPatcher
extends BaseTest {
    @Test
    public void checkSuccessfulPatching() {
        Assert.assertTrue((String)"Guava Patcher ran with errors, check error log messages", (boolean)GuavaPatcher.isPatchingSuccessful());
    }

    @Test
    public void checkStopwatchEllapsedMillis() throws Exception {
        final long[] currentTimeMillis = new long[]{0L};
        Ticker ticker = new Ticker(){

            public long read() {
                return TimeUnit.MILLISECONDS.toNanos(currentTimeMillis[0]);
            }
        };
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)ticker);
        currentTimeMillis[0] = 12345L;
        stopwatch.stop();
        Assert.assertEquals((long)currentTimeMillis[0], (long)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)currentTimeMillis[0], (long)((Long)TestGuavaPatcher.invokeMethod(Stopwatch.class, "elapsedMillis", new Class[0], stopwatch, new Object[0])));
    }

    @Test
    public void checkCloseablesCloseQuietly() throws Exception {
        Closeable alwaysThrows = () -> {
            throw new IOException("Always fail");
        };
        TestGuavaPatcher.invokeMethod(Closeables.class, "closeQuietly", new Class[]{Closeable.class}, null, alwaysThrows);
    }

    @Test
    public void checkPreconditionsCheckArgumentIntParam() throws Exception {
        TestGuavaPatcher.invokeMethod(Preconditions.class, "checkArgument", new Class[]{Boolean.TYPE, String.class, Integer.TYPE}, null, true, "Error Message %s", 1);
        try {
            TestGuavaPatcher.invokeMethod(Preconditions.class, "checkArgument", new Class[]{Boolean.TYPE, String.class, Integer.TYPE}, null, false, "Error Message %s", 1);
            Assert.fail();
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            Assert.assertEquals(IllegalArgumentException.class, cause.getClass());
            Assert.assertEquals((Object)"Error Message 1", (Object)cause.getMessage());
        }
    }

    @Test
    public void checkPreconditionsCheckArgumentLongParam() throws Exception {
        TestGuavaPatcher.invokeMethod(Preconditions.class, "checkArgument", new Class[]{Boolean.TYPE, String.class, Long.TYPE}, null, true, "Error Message %s", 2L);
        try {
            TestGuavaPatcher.invokeMethod(Preconditions.class, "checkArgument", new Class[]{Boolean.TYPE, String.class, Long.TYPE}, null, false, "Error Message %s", 2L);
            Assert.fail();
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            Assert.assertEquals(IllegalArgumentException.class, cause.getClass());
            Assert.assertEquals((Object)"Error Message 2", (Object)cause.getMessage());
        }
    }

    @Test
    public void checkPreconditionsCheckArgumentLongLongParam() throws Exception {
        TestGuavaPatcher.invokeMethod(Preconditions.class, "checkArgument", new Class[]{Boolean.TYPE, String.class, Long.TYPE, Long.TYPE}, null, true, "Error Message %s %s", 3L, 4L);
        try {
            TestGuavaPatcher.invokeMethod(Preconditions.class, "checkArgument", new Class[]{Boolean.TYPE, String.class, Long.TYPE, Long.TYPE}, null, false, "Error Message %s %s", 3L, 4L);
            Assert.fail();
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            Assert.assertEquals(IllegalArgumentException.class, cause.getClass());
            Assert.assertEquals((Object)"Error Message 3 4", (Object)cause.getMessage());
        }
    }

    @Test
    public void checkPreconditionsCheckNotNullIntParam() throws Exception {
        TestGuavaPatcher.invokeMethod(Preconditions.class, "checkNotNull", new Class[]{Object.class, String.class, Integer.TYPE}, null, this, "Error Message %s", 5);
        try {
            TestGuavaPatcher.invokeMethod(Preconditions.class, "checkNotNull", new Class[]{Object.class, String.class, Integer.TYPE}, null, null, "Error Message %s", 5);
            Assert.fail();
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            Assert.assertEquals(NullPointerException.class, cause.getClass());
            Assert.assertEquals((Object)"Error Message 5", (Object)cause.getMessage());
        }
    }

    @Test
    public void checkPreconditionsCheckStateIntParam() throws Exception {
        TestGuavaPatcher.invokeMethod(Preconditions.class, "checkState", new Class[]{Boolean.TYPE, String.class, Integer.TYPE}, null, true, "Error Message %s", 6);
        try {
            TestGuavaPatcher.invokeMethod(Preconditions.class, "checkState", new Class[]{Boolean.TYPE, String.class, Integer.TYPE}, null, false, "Error Message %s", 6);
            Assert.fail();
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            Assert.assertEquals(IllegalStateException.class, cause.getClass());
            Assert.assertEquals((Object)"Error Message 6", (Object)cause.getMessage());
        }
    }

    @Test
    public void checkPreconditionsCheckNotNullVarargs() throws Exception {
        this.checkPreconditionsCheckVarargMethod("checkNotNull", Object.class, this, null, NullPointerException.class);
    }

    @Test
    public void checkPreconditionsCheckArgumentVarargs() throws Exception {
        this.checkPreconditionsCheckVarargMethod("checkArgument", Boolean.TYPE, true, false, IllegalArgumentException.class);
    }

    @Test
    public void checkPreconditionsCheckStateVarargs() throws Exception {
        this.checkPreconditionsCheckVarargMethod("checkState", Boolean.TYPE, true, false, IllegalStateException.class);
    }

    private <T> void checkPreconditionsCheckVarargMethod(String methodName, Class<T> argClass, T goodValue, T badValue, Class<? extends Throwable> exceptionClass) throws Exception {
        for (int i = 1; i < 5; ++i) {
            Object[] templatePlaceholders = new String[i];
            Arrays.fill(templatePlaceholders, "%s");
            Object[] templateArguments = new Object[i];
            Arrays.setAll(templateArguments, Integer::valueOf);
            String template = "Error message: " + Stream.of(templatePlaceholders).collect(Collectors.joining(","));
            String message = "Error message: " + Stream.of(templateArguments).map(Object::toString).collect(Collectors.joining(","));
            Object[] parameterTypes = new Class[2 + i];
            parameterTypes[0] = argClass;
            parameterTypes[1] = String.class;
            Arrays.fill(parameterTypes, 2, parameterTypes.length, Object.class);
            Object[] parameters = new Object[2 + i];
            parameters[0] = goodValue;
            parameters[1] = template;
            System.arraycopy(templateArguments, 0, parameters, 2, i);
            TestGuavaPatcher.invokeMethod(Preconditions.class, methodName, parameterTypes, null, parameters);
            try {
                parameters[0] = badValue;
                TestGuavaPatcher.invokeMethod(Preconditions.class, methodName, parameterTypes, null, parameters);
                Assert.fail();
                continue;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                Assert.assertEquals(exceptionClass, cause.getClass());
                Assert.assertEquals((Object)message, (Object)cause.getMessage());
            }
        }
    }

    private static <T> T invokeMethod(Class<?> clazz, String methodName, Class<?>[] argumentTypes, Object object, Object ... arguments) throws Exception {
        Method method = clazz.getMethod(methodName, argumentTypes);
        return (T)method.invoke(object, arguments);
    }
}

