/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.subtree;

import java.util.Collections;
import java.util.Set;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.subtree.BaseSubtreeSpecification;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubtreeSpecificationModifier {
    private DN base = new DN();
    private Set<DN> chopBefore = Collections.EMPTY_SET;
    private Set<DN> chopAfter = Collections.EMPTY_SET;
    private int minBaseDistance = 0;
    private int maxBaseDistance = -1;
    private ExprNode refinement = null;

    public SubtreeSpecification getSubtreeSpecification() {
        return new BaseSubtreeSpecification(this.base, this.minBaseDistance, this.maxBaseDistance, this.chopAfter, this.chopBefore, this.refinement);
    }

    public void setBase(DN base) {
        this.base = base;
    }

    public void setChopBeforeExclusions(Set<DN> chopBefore) {
        this.chopBefore = chopBefore;
    }

    public void setChopAfterExclusions(Set<DN> chopAfter) {
        this.chopAfter = chopAfter;
    }

    public void setMinBaseDistance(int minBaseDistance) {
        if (minBaseDistance < 0) {
            throw new IllegalArgumentException(I18n.err((String)"ERR_04330", (Object[])new Object[0]));
        }
        this.minBaseDistance = minBaseDistance;
    }

    public void setMaxBaseDistance(int maxBaseDistance) {
        this.maxBaseDistance = maxBaseDistance < 0 ? -1 : maxBaseDistance;
    }

    public void setRefinement(ExprNode refinement) {
        this.refinement = refinement;
    }
}

