/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.bind;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.LdapResponseCodec;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.apache.directory.shared.ldap.util.StringTools;

public class BindResponseCodec
extends LdapResponseCodec {
    private byte[] serverSaslCreds;
    private int bindResponseLength;

    public MessageTypeEnum getMessageType() {
        return MessageTypeEnum.BIND_RESPONSE;
    }

    public String getMessageTypeName() {
        return "BIND_RESPONSE";
    }

    public byte[] getServerSaslCreds() {
        if (this.serverSaslCreds == null) {
            return null;
        }
        byte[] copy = new byte[this.serverSaslCreds.length];
        System.arraycopy(this.serverSaslCreds, 0, copy, 0, this.serverSaslCreds.length);
        return copy;
    }

    public void setServerSaslCreds(byte[] serverSaslCreds) {
        if (serverSaslCreds != null) {
            this.serverSaslCreds = new byte[serverSaslCreds.length];
            System.arraycopy(serverSaslCreds, 0, this.serverSaslCreds, 0, serverSaslCreds.length);
        } else {
            this.serverSaslCreds = null;
        }
    }

    protected int computeLengthProtocolOp() {
        int ldapResultLength;
        this.bindResponseLength = ldapResultLength = this.computeLdapResultLength();
        if (this.serverSaslCreds != null) {
            this.bindResponseLength += 1 + TLV.getNbBytes((int)this.serverSaslCreds.length) + this.serverSaslCreds.length;
        }
        return 1 + TLV.getNbBytes((int)this.bindResponseLength) + this.bindResponseLength;
    }

    protected void encodeProtocolOp(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)97);
            buffer.put(TLV.getBytes((int)this.bindResponseLength));
            super.encode(buffer);
            if (this.serverSaslCreds != null) {
                buffer.put((byte)-121);
                buffer.put(TLV.getBytes((int)this.serverSaslCreds.length));
                if (this.serverSaslCreds.length != 0) {
                    buffer.put(this.serverSaslCreds);
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err((String)"ERR_04005", (Object[])new Object[0]));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    BindResponse");
        if (this.serverSaslCreds != null) {
            sb.append("\n        Server sasl credentials : '").append(StringTools.dumpBytes(this.serverSaslCreds)).append('\'');
        }
        sb.append(super.toString());
        return this.toString(sb.toString());
    }
}

