/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.normalizers;

import javax.naming.NamingException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.syntaxCheckers.NumericOidSyntaxChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameOrNumericIdNormalizer
extends Normalizer {
    public static final long serialVersionUID = 1L;
    private NumericOidSyntaxChecker checker = new NumericOidSyntaxChecker();
    private SchemaManager schemaManager;
    public static final NameOrNumericIdNormalizer INSTANCE = new NameOrNumericIdNormalizer();

    public NameOrNumericIdNormalizer() {
        super("1.3.6.1.4.1.18060.0.4.0.1.0");
    }

    @Override
    public Value<?> normalize(Value<?> value) throws NamingException {
        if (value == null) {
            return null;
        }
        String strValue = value.getString();
        if (strValue.length() == 0) {
            return new ClientStringValue("");
        }
        if (this.checker.isValidSyntax(strValue)) {
            return value;
        }
        String oid = this.schemaManager.getRegistries().getOid(strValue);
        if (oid != null) {
            return new ClientStringValue(oid);
        }
        throw new LdapNamingException(I18n.err((String)"ERR_04225", (Object[])new Object[]{value}), ResultCodeEnum.OTHER);
    }

    @Override
    public String normalize(String value) throws NamingException {
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return value;
        }
        if (this.checker.isValidSyntax(value)) {
            return value;
        }
        String oid = this.schemaManager.getRegistries().getOid(value);
        if (oid != null) {
            return oid;
        }
        throw new LdapNamingException(I18n.err((String)"ERR_04226", (Object[])new Object[]{value}), ResultCodeEnum.OTHER);
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }
}

