/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.normalizers;

import javax.naming.NamingException;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.registries.Registries;
import org.apache.directory.shared.ldap.util.SynchronizedLRUMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingNormalizer
extends Normalizer {
    public static final long serialVersionUID = 1L;
    public static final int CACHE_MAX = 250;
    private final SynchronizedLRUMap cache;
    protected final Normalizer normalizer;

    public CachingNormalizer(Normalizer normalizer) {
        this(normalizer, 250);
    }

    public CachingNormalizer(Normalizer normalizer, int cacheSz) {
        super(normalizer.getOid());
        this.normalizer = normalizer;
        this.cache = new SynchronizedLRUMap(cacheSz);
    }

    @Override
    public String getOid() {
        return this.normalizer.getOid();
    }

    @Override
    public void setOid(String oid) {
        super.setOid(oid);
        this.normalizer.setOid(oid);
    }

    @Override
    public Value<?> normalize(Value<?> value) throws NamingException {
        if (value == null) {
            return null;
        }
        Value result = (Value)this.cache.get(value);
        if (result != null) {
            return result;
        }
        Value<?> normalized = this.normalizer.normalize(value);
        this.cache.put(value, normalized);
        return normalized;
    }

    @Override
    public String normalize(String value) throws NamingException {
        if (value == null) {
            return null;
        }
        String normalized = (String)this.cache.get(value);
        if (normalized != null) {
            return normalized;
        }
        normalized = this.normalizer.normalize(value);
        this.cache.put(value, normalized);
        return normalized;
    }

    @Override
    public void setRegistries(Registries registries) {
        this.normalizer.setRegistries(registries);
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        this.normalizer.setSchemaManager(schemaManager);
    }
}

