/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.name;

import java.io.StringReader;
import java.util.List;
import javax.naming.InvalidNameException;
import org.apache.directory.shared.ldap.name.AntlrDnLexer;
import org.apache.directory.shared.ldap.name.AntlrDnParser;
import org.apache.directory.shared.ldap.name.RDN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexDnParser {
    public void parseDn(String name, List<RDN> rdns) throws InvalidNameException {
        AntlrDnParser dnParser = new AntlrDnParser(new AntlrDnLexer(new StringReader(name)));
        try {
            dnParser.relativeDistinguishedNames(rdns);
        }
        catch (Exception e) {
            InvalidNameException ine = new InvalidNameException(e.getMessage());
            ine.setRootCause(e);
            throw ine;
        }
    }

    public void parseRdn(String name, RDN rdn) throws InvalidNameException {
        AntlrDnParser dnParser = new AntlrDnParser(new AntlrDnLexer(new StringReader(name)));
        try {
            dnParser.relativeDistinguishedName(rdn);
        }
        catch (Exception e) {
            InvalidNameException ine = new InvalidNameException(e.getMessage());
            ine.setRootCause(e);
            throw ine;
        }
    }
}

